/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Graphics;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.DiagramComponent;
import oracle.jdevimpl.xml.schema.diagram.Row;

public class Grid
extends DiagramComponent {
    private Row[] rows;

    void $init$() {
        this.rows = new Row[0];
    }

    public Grid(Diagram diagram) {
        super(diagram);
        this.$init$();
    }

    public void addRow(Row row) {
        Row[] rowArray = this.rows;
        this.rows = new Row[this.rows.length + 1];
        System.arraycopy(rowArray, 0, this.rows, 0, this.rows.length - 1);
        this.rows[this.rows.length - 1] = row;
        int n = 0;
        while (n < row.getColumnCount()) {
            this.add(row.getColumn(n));
            ++n;
        }
    }

    public void removeRow(Row row) {
        int n = 0;
        while (n < this.rows.length) {
            if (row == this.rows[n]) {
                Row[] rowArray = this.rows;
                this.rows = new Row[this.rows.length - 1];
                System.arraycopy(rowArray, 0, this.rows, 0, n);
                System.arraycopy(rowArray, n + 1, this.rows, n, rowArray.length - n - 1);
                return;
            }
            ++n;
        }
    }

    public void removeAllRows() {
        int n = 0;
        while (n < this.rows.length) {
            Row row = this.rows[n];
            int n2 = 0;
            while (n2 < row.getColumnCount()) {
                this.remove(row.getColumn(n2));
                ++n2;
            }
            this.rows[n] = null;
            ++n;
        }
        this.rows = new Row[0];
    }

    public int getPreferredWidth() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.rows.length) {
            n = Math.max(n, this.rows[n2].getColumn(0).getPreferredWidth());
            ++n2;
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.rows.length) {
            Row row = this.rows[n4];
            int n5 = n;
            int n6 = 1;
            while (n6 < row.getColumnCount()) {
                n5 += row.getColumn(n6).getPreferredWidth();
                ++n6;
            }
            if (row.getColumnCount() > 0) {
                n5 += row.getColumnCount() - 1;
            }
            n3 = Math.max(n3, n5);
            ++n4;
        }
        return n3;
    }

    public int getPreferredHeight() {
        if (this.rows.length == 0) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.rows.length) {
            n += this.rows[n2].getRowHeight();
            ++n2;
        }
        return n + this.rows.length - 1;
    }

    public void layout() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.rows.length) {
            n = Math.max(n, this.rows[n2].getColumn(0).getPreferredWidth());
            ++n2;
        }
        n = Math.min(this.width, n);
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.rows.length) {
            Row row = this.rows[n4];
            int n5 = row.getColumnCount() > 1 ? (this.width - n - row.getColumnCount() + 1) / (row.getColumnCount() - 1) : 0;
            int n6 = 0;
            int n7 = row.getRowHeight();
            int n8 = 0;
            while (n8 < row.getColumnCount()) {
                DiagramComponent diagramComponent = row.getColumn(n8);
                int n9 = n8 == 0 ? n : n5;
                diagramComponent.setBounds(n6, n3, n9, n7);
                n6 += n9 + 1;
                ++n8;
            }
            n3 += n7 + 1;
            ++n4;
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        int n = 0;
        int n2 = 0;
        while (n2 < this.rows.length) {
            Row row = this.rows[n2];
            int n3 = row.getRowHeight();
            int n4 = 0;
            while (n4 < row.getColumnCount() - 1) {
                DiagramComponent diagramComponent = row.getColumn(n4);
                int n5 = diagramComponent.getX() + diagramComponent.getWidth();
                graphics.drawLine(n5, n, n5, n + n3);
                ++n4;
            }
            n += n3;
            if (n2 < this.rows.length - 1) {
                graphics.drawLine(0, n, this.width, n);
            }
            ++n;
            ++n2;
        }
    }

    public int getRowCount() {
        return this.rows.length;
    }
}

