/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.ImageComponent;
import oracle.jdevimpl.xml.schema.diagram.ModelGroup;
import oracle.jdevimpl.xml.schema.resource.XmlSchemaArb;
import org.w3c.dom.Element;

public class IconicModelGroup
extends ModelGroup {
    private ImageComponent image;

    public IconicModelGroup(Diagram diagram, Element element) {
        super(diagram, element);
        String string = element.getLocalName();
        int n = -1;
        if ("sequence".equals(string)) {
            n = 7;
        } else if ("choice".equals(string)) {
            n = 8;
        } else if ("all".equals(string)) {
            n = 9;
        }
        if (n > 0) {
            this.image = new ImageComponent(diagram, XmlSchemaArb.getInstance(), n);
            this.add(this.image);
        }
        this.update();
    }

    public int getPreferredWidth() {
        int n = 0;
        if (this.image != null) {
            n = this.image.getPreferredWidth() + 10;
        }
        return n;
    }

    public int getPreferredHeight() {
        int n = 0;
        if (this.image != null) {
            n = this.image.getPreferredHeight() + 4;
        }
        return n;
    }

    public void layout() {
        super.layout();
        if (this.image != null) {
            this.image.setBounds(5, 2, this.image.getPreferredWidth(), this.height - 4);
        }
    }
}

