/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import oracle.ide.util.ArrayResourceBundle;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.DiagramComponent;

public class ImageComponent
extends DiagramComponent {
    protected ArrayResourceBundle bundle;
    protected int key;
    protected Image image;

    public ImageComponent(Diagram diagram) {
        super(diagram);
    }

    public ImageComponent(Diagram diagram, ArrayResourceBundle arrayResourceBundle, int n) {
        super(diagram);
        this.bundle = arrayResourceBundle;
        this.key = n;
    }

    public void setImage(ArrayResourceBundle arrayResourceBundle, int n) {
        this.bundle = arrayResourceBundle;
        this.key = n;
        this.image = null;
        this.invalidate();
        this.repaint();
    }

    public int getPreferredWidth() {
        int n = this.insets.left + this.insets.right;
        if (this.image == null) {
            this.loadImage();
        }
        if (this.image != null) {
            n += this.image.getWidth(null);
        }
        return n;
    }

    public int getPreferredHeight() {
        int n = this.insets.top + this.insets.bottom;
        if (this.image == null) {
            this.loadImage();
        }
        if (this.image != null) {
            n += this.image.getHeight(null);
        }
        return n;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.image != null) {
            int n = (this.height - this.insets.top - this.insets.bottom - this.image.getHeight(null)) / 2;
            n = Math.max(n, 0);
            this.paintImage(graphics, this.insets.left, this.insets.top + n);
        }
    }

    protected void paintImage(Graphics graphics, int n, int n2) {
        graphics.drawImage(this.image, n, n2, null);
    }

    protected void loadImage() {
        if (this.bundle != null) {
            MediaTracker mediaTracker = new MediaTracker(this.diagram);
            this.image = this.bundle.getImageImpl(this.key);
            mediaTracker.addImage(this.image, 0);
            try {
                mediaTracker.waitForAll();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

