/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Window;
import java.util.Collections;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.model.XmlCommitException;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdevimpl.xml.schema.GlobalReference;
import oracle.jdevimpl.xml.schema.ProxyElement;
import oracle.jdevimpl.xml.schema.ReferenceNode;
import oracle.jdevimpl.xml.schema.XmlSchemaEditorController;
import oracle.jdevimpl.xml.schema.XmlSchemaModel;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.FacetContainer;
import oracle.jdevimpl.xml.schema.diagram.GraphicsUtils;
import oracle.jdevimpl.xml.schema.diagram.HierarchalSchemaComponent;
import oracle.jdevimpl.xml.schema.diagram.ListChangeListener;
import oracle.jdevimpl.xml.schema.diagram.ListComponent;
import oracle.jdevimpl.xml.schema.diagram.ModelUtils;
import oracle.jdevimpl.xml.schema.diagram.TextComponent;
import oracle.jdevimpl.xml.schema.diagram.TypeEditor;
import oracle.jdevimpl.xml.schema.resource.XmlSchemaArb;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class List
extends HierarchalSchemaComponent
implements ListChangeListener {
    private TextComponent label;
    private TextComponent typeLabel;
    private TypeEditor type;
    private FacetContainer facets;
    private Element parentElement;
    private static final Color COLOR = new Color(174, 174, 255);

    public List(Diagram diagram, Element element) {
        super(diagram, element);
        this.setBackground(COLOR);
        this.setForeground(Color.BLACK);
        this.label = new TextComponent(diagram);
        this.label.setFont(GraphicsUtils.getDiagramFont().deriveFont(1));
        this.label.setText("<list>");
        this.label.setInsets(new Insets(3, 5, 0, 5));
        this.add(this.label);
        this.typeLabel = new TextComponent(diagram);
        this.typeLabel.setInsets(new Insets(0, 10, 3, 0));
        this.add(this.typeLabel);
        this.type = new TypeEditor(diagram, 3);
        this.type.setInsets(new Insets(0, 5, 3, 10));
        this.type.addListChangeListener(this);
        this.add(this.type);
        this.facets = new FacetContainer(diagram, element);
        this.add(this.facets);
        this.update();
    }

    public void destroy() {
        super.destroy();
        this.type.removeListChangeListener(this);
    }

    public int getPreferredWidth() {
        int n = this.type.getPreferredWidth();
        if (this.typeLabel.isVisible()) {
            n += this.typeLabel.getPreferredWidth();
        }
        int n2 = Math.max(this.label.getPreferredWidth() + 10, n);
        n2 = Math.max(n2, this.facets.getPreferredWidth());
        return this.insets.left + n2 + this.insets.right;
    }

    public int getPreferredHeight() {
        int n = this.type.getPreferredHeight();
        if (this.typeLabel.isVisible()) {
            n = Math.max(n, this.typeLabel.getPreferredHeight());
        }
        if (n == 0) {
            n = 2;
        }
        int n2 = this.facets.getPreferredHeight();
        return this.insets.top + this.label.getPreferredHeight() + n + n2 + (n2 > 0 ? 1 : 0) + this.insets.bottom;
    }

    public void layout() {
        int n = this.width - this.insets.left - this.insets.right;
        int n2 = this.insets.top;
        this.label.setBounds(this.insets.left + 5, n2, n - 10, this.label.getPreferredHeight());
        n2 += this.label.getHeight();
        if (this.typeLabel.isVisible()) {
            this.typeLabel.setBounds(this.insets.left, n2, this.typeLabel.getPreferredWidth(), this.typeLabel.getPreferredHeight());
        }
        this.type.setBounds(this.insets.left + this.typeLabel.getWidth(), n2, n - this.typeLabel.getWidth(), this.type.getPreferredHeight());
        int n3 = Math.max(this.typeLabel.getHeight(), this.type.getHeight());
        n2 += n3;
        if (n3 == 0) {
            n2 += 2;
        }
        if (this.facets.getPreferredHeight() > 0) {
            ++n2;
        }
        this.facets.setBounds(this.insets.left, n2, n, this.facets.getPreferredHeight());
    }

    public Shape getShape() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        int[] nArray = new int[]{0, 1, 1, 2, 3, 4, 5, 6, n - 7, n - 6, n - 5, n - 4, n - 3, n - 2, n - 2, n - 1, n - 1, 0, 0};
        int[] nArray2 = new int[]{6, 5, 4, 3, 2, 1, 1, 0, 0, 1, 1, 2, 3, 4, 5, 6, n2 - 1, n2 - 1, 6};
        return new Polygon(nArray, nArray2, nArray.length);
    }

    public java.util.List getActions() {
        if (!(this.element instanceof ProxyElement && ((ProxyElement)this.element).isExternal() || this.element.getAttributeNodeNS(null, "itemType") != null)) {
            this.diagram.getView().acquireReadLock();
            try {
                TreeTraversal treeTraversal = this.diagram.getView().getTreeTraversal();
                Node node = treeTraversal.getFirstChild((Node)this.element);
                if (node == null || !(node instanceof ReferenceNode) && ModelUtils.getSchemaRole(node) != 20) {
                    java.util.List<Integer> list = Collections.singletonList(new Integer(XmlSchemaEditorController.SET_ITEM_TYPE_CMD_ID));
                    this.diagram.getView().releaseReadLock();
                    return list;
                }
            }
            finally {
                this.diagram.getView().releaseReadLock();
            }
        }
        return Collections.EMPTY_LIST;
    }

    public boolean handleAction(IdeAction ideAction) {
        int n = ideAction.getCommandId();
        if (n == XmlSchemaEditorController.SET_ITEM_TYPE_CMD_ID) {
            this.setItemType();
            return true;
        }
        return false;
    }

    public void update() {
        Attr attr = this.element.getAttributeNodeNS(null, "itemType");
        if (attr != null) {
            String string = attr.getValue();
            GlobalReference globalReference = new GlobalReference(this.diagram.getView().getNamespace(this.element, string), ModelUtils.getName(string), 3, 5, attr);
            ReferenceNode referenceNode = new ReferenceNode(((XmlSchemaModel)this.diagram.getView().getBaseModel()).getModelManager(), this.element, globalReference);
            this.type.setReference(referenceNode);
            this.typeLabel.setVisible(true);
            this.typeLabel.setText("itemType");
        } else {
            this.type.setReference(null);
            this.typeLabel.setVisible(false);
            this.typeLabel.setText(null);
        }
    }

    public void valueChanged(ListComponent listComponent) {
        if (listComponent == this.type) {
            this.handleTypeChange();
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
    }

    private void handleTypeChange() {
        String string = this.type.getText().trim();
        if (string.length() == 0) {
            this.removeType();
        } else {
            this.setType(string);
        }
    }

    private void removeType() {
        Attr attr = this.type.getAttr();
        Element element = attr.getOwnerElement();
        if (element != null) {
            this.diagram.getModel().startTransaction(XmlSchemaArb.getString(11));
            try {
                element.removeAttributeNode(attr);
                if (element != this.element) {
                    ModelUtils.removePath(this.element, element);
                }
                this.diagram.getModel().commitTransaction();
            }
            catch (XmlCommitException xmlCommitException) {
                this.diagram.getModel().rollbackTransaction();
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)((Object)xmlCommitException));
            }
            catch (ThreadDeath threadDeath) {
                this.diagram.getModel().rollbackTransaction();
                throw threadDeath;
            }
            catch (Throwable throwable) {
                this.diagram.getModel().rollbackTransaction();
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)throwable);
            }
        } else {
            this.type.setAttr(null);
        }
    }

    private void setType(String string) {
        this.diagram.getModel().startTransaction(XmlSchemaArb.getString(11));
        try {
            this.element.setAttributeNS(null, "itemType", string);
            this.diagram.getModel().commitTransaction();
        }
        catch (XmlCommitException xmlCommitException) {
            this.diagram.getModel().rollbackTransaction();
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)((Object)xmlCommitException));
        }
        catch (ThreadDeath threadDeath) {
            this.diagram.getModel().rollbackTransaction();
            throw threadDeath;
        }
        catch (Throwable throwable) {
            this.diagram.getModel().rollbackTransaction();
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)throwable);
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.facets.getHeight() > 0) {
            int n = this.insets.top + this.label.getHeight() + this.type.getHeight();
            if (this.type.getHeight() == 0) {
                n += 2;
            }
            graphics.drawLine(this.insets.left, n, this.width - 1, n);
        }
    }

    private void setItemType() {
        this.diagram.getView().acquireReadLock();
        try {
            Attr attr = this.diagram.getView().getDocument().createAttributeNS(null, "itemType");
            this.type.setAttr(attr);
            this.type.startEditing();
        }
        finally {
            this.diagram.getView().releaseReadLock();
        }
    }
}

