/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.ide.controls.SortedComboBoxModel;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.EditableTextComponent;
import oracle.jdevimpl.xml.schema.diagram.ListChangeListener;

public class ListComponent
extends EditableTextComponent {
    private ArrayList listeners;
    private boolean editable;
    private String[] items;
    private ListListener listListener;

    void $init$() {
        this.listListener = new ListListener(null);
    }

    public ListComponent(Diagram diagram) {
        this(diagram, true);
    }

    public ListComponent(Diagram diagram, boolean bl) {
        super(diagram);
        this.$init$();
        this.editable = bl;
    }

    public void setItems(String[] stringArray) {
        this.items = stringArray;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
        if (this.editor != null) {
            ((JComboBox)this.editor).setEditable(false);
        }
    }

    public void addListChangeListener(ListChangeListener listChangeListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listChangeListener);
    }

    public void removeListChangeListener(ListChangeListener listChangeListener) {
        if (this.listeners != null) {
            this.listeners.remove(listChangeListener);
        }
    }

    protected JComponent createEditor() {
        JComboBox jComboBox = new JComboBox();
        SortedComboBoxModel sortedComboBoxModel = new SortedComboBoxModel();
        int n = 0;
        while (n < this.items.length) {
            sortedComboBoxModel.addElement((Object)this.items[n]);
            ++n;
        }
        jComboBox.setModel(sortedComboBoxModel);
        jComboBox.setEditable(this.editable);
        jComboBox.setSelectedItem(this.text);
        jComboBox.addActionListener(this.listListener);
        jComboBox.addFocusListener(this.listListener);
        jComboBox.addPopupMenuListener(this.listListener);
        jComboBox.addKeyListener(this.listener);
        jComboBox.getEditor().getEditorComponent().addKeyListener(this.listener);
        jComboBox.getEditor().getEditorComponent().addFocusListener(this.listListener);
        return jComboBox;
    }

    protected void destroyEditor(JComponent jComponent) {
        JComboBox jComboBox = (JComboBox)jComponent;
        jComboBox.removeActionListener(this.listListener);
        jComboBox.removeFocusListener(this.listListener);
        jComboBox.removePopupMenuListener(this.listListener);
        jComboBox.removeKeyListener(this.listener);
        jComboBox.getEditor().getEditorComponent().removeKeyListener(this.listener);
        jComboBox.getEditor().getEditorComponent().removeFocusListener(this.listListener);
    }

    protected void focusEditor() {
        JComboBox jComboBox = (JComboBox)this.editor;
        if (jComboBox.isEditable()) {
            jComboBox.getEditor().getEditorComponent().requestFocus();
        } else {
            jComboBox.requestFocus();
        }
    }

    protected String getEditorValue() {
        return (String)((JComboBox)this.editor).getSelectedItem();
    }

    protected Rectangle getEditorBounds() {
        Rectangle rectangle = super.getEditorBounds();
        Dimension dimension = this.editor.getPreferredSize();
        rectangle.width = Math.max(dimension.width, rectangle.width);
        rectangle.height = Math.max(dimension.height, rectangle.height);
        return rectangle;
    }

    protected void stopEditing() {
        boolean bl = this.editor != null;
        super.stopEditing();
        if (bl) {
            this.fireValueChanged();
        }
    }

    protected void fireValueChanged() {
        if (this.listeners != null) {
            for (ListChangeListener listChangeListener : (List)this.listeners.clone()) {
                listChangeListener.valueChanged(this);
            }
        }
    }

    private class ListListener
    implements FocusListener,
    ActionListener,
    PopupMenuListener {
        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)ListComponent.this.editor;
            if (!jComboBox.isPopupVisible()) {
                ListComponent.this.stopEditing();
                if (ListComponent.this.editor == null) {
                    ListComponent.this.getGlassPane().requestFocus();
                }
            }
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            SwingUtilities.invokeLater(new 1());
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            if (!((JComboBox)ListComponent.this.editor).isPopupVisible()) {
                ListComponent.this.stopEditing();
            }
        }

        private ListListener() {
        }

        ListListener(1 var2_2) {
            this();
        }

        public final class 1
        implements Runnable {
            public void run() {
                ListComponent.this.stopEditing();
                if (ListComponent.this.editor == null) {
                    ListComponent.this.getGlassPane().requestFocus();
                }
            }
        }
    }
}

