/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Component;
import java.awt.Window;
import java.util.HashMap;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.util.DefaultPrefixLookup;
import oracle.bali.xml.util.NamespaceUtils;
import oracle.ide.Ide;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdevimpl.xml.schema.GlobalReference;
import oracle.jdevimpl.xml.schema.ProxyNode;
import oracle.jdevimpl.xml.schema.ReferenceNode;
import oracle.jdevimpl.xml.schema.XmlSchemaLayoutView;
import oracle.jdevimpl.xml.schema.XmlSchemaModel;
import oracle.jdevimpl.xml.schema.resource.XmlSchemaArb;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ModelUtils {
    public static final int CONTENT_TYPE_SIMPLE = 0;
    public static final int CONTENT_TYPE_COMPLEX = 1;
    public static final int CONTENT_TYPE_UNKNOWN = 2;
    private static String[] markupTable = new String[]{"&apos;", "'", "&lt;", "<", "&gt;", ">", "&quot;", "\"", "&amp;", "&"};
    private static HashMap roleMap = new HashMap();

    static {
        Integer n = new Integer(13);
        roleMap.put("key", n);
        roleMap.put("keyref", n);
        roleMap.put("unique", n);
        n = new Integer(1);
        roleMap.put("annotation", n);
        roleMap.put("documentation", n);
        n = new Integer(11);
        roleMap.put("enumeration", n);
        roleMap.put("fractionDigits", n);
        roleMap.put("length", n);
        roleMap.put("maxExclusive", n);
        roleMap.put("maxInclusive", n);
        roleMap.put("maxLength", n);
        roleMap.put("minExclusive", n);
        roleMap.put("minInclusive", n);
        roleMap.put("minLength", n);
        roleMap.put("pattern", n);
        roleMap.put("totalDigits", n);
        roleMap.put("whiteSpace", n);
        n = new Integer(14);
        roleMap.put("import", n);
        roleMap.put("include", n);
        roleMap.put("redefine", n);
        roleMap.put("all", new Integer(0));
        roleMap.put("any", new Integer(2));
        roleMap.put("anyAttribute", new Integer(3));
        roleMap.put("attribute", new Integer(4));
        roleMap.put("attributeGroup", new Integer(5));
        roleMap.put("choice", new Integer(6));
        roleMap.put("complexContent", new Integer(7));
        roleMap.put("complexType", new Integer(8));
        roleMap.put("element", new Integer(9));
        roleMap.put("extension", new Integer(10));
        roleMap.put("group", new Integer(12));
        roleMap.put("list", new Integer(15));
        roleMap.put("restriction", new Integer(16));
        roleMap.put("schema", new Integer(17));
        roleMap.put("sequence", new Integer(18));
        roleMap.put("simpleContent", new Integer(19));
        roleMap.put("simpleType", new Integer(20));
        roleMap.put("union", new Integer(21));
    }

    private ModelUtils() {
    }

    public static final String getType(Node node) {
        String string = null;
        if (node.getNodeType() == 1 && (string = ((Element)node).getAttributeNS(null, "type")) != null && string.length() == 0) {
            string = null;
        }
        return string;
    }

    public static final String getName(String string) {
        int n = string.indexOf(58);
        if (n != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    public static final String getPrefix(String string) {
        int n = string.indexOf(58);
        if (n != -1) {
            return string.substring(0, n);
        }
        return null;
    }

    public static final boolean isElementDeclaration(Node node) {
        return ModelUtils.isType(node, "element");
    }

    public static final boolean isComplexTypeDefinition(Node node) {
        return ModelUtils.isType(node, "complexType");
    }

    public static final boolean isSimpleTypeDefinition(Node node) {
        return ModelUtils.isType(node, "simpleType");
    }

    public static final boolean isList(Node node) {
        return ModelUtils.isType(node, "list");
    }

    public static final boolean isUnion(Node node) {
        return ModelUtils.isType(node, "union");
    }

    public static final boolean isType(Node node, String string) {
        return string.equals(node.getLocalName()) && "http://www.w3.org/2001/XMLSchema".equals(node.getNamespaceURI());
    }

    public static final boolean isAttributeRole(int n) {
        return n == 3 || n == 4 || n == 5;
    }

    public static final boolean isModelGroupRole(int n) {
        return n == 0 || n == 6 || n == 18 || n == 12;
    }

    public static final boolean isContainerRole(int n) {
        return n == 7 || n == 19 || n == 10 || n == 16;
    }

    public static final String getAnnotation(TreeTraversal treeTraversal, Node node) {
        Element element;
        Node node2 = ModelUtils.getRef(treeTraversal, node);
        if (node2 != null) {
            return ModelUtils.getAnnotation(treeTraversal, node2);
        }
        Element element2 = ModelUtils.getChild(node, "annotation");
        if (element2 != null && (element = ModelUtils.getChild(element2, "documentation")) != null) {
            StringBuffer stringBuffer = new StringBuffer();
            Node node3 = element.getFirstChild();
            while (node3 != null) {
                if (node3.getNodeType() == 3) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append("\n");
                    }
                    stringBuffer.append(node3.getNodeValue());
                }
                node3 = node3.getNextSibling();
            }
            String string = stringBuffer.toString().trim();
            if (string.length() > 0) {
                return ModelUtils.translateXmlMarkup(string);
            }
        }
        return null;
    }

    public static final Node getRef(TreeTraversal treeTraversal, Node node) {
        ReferenceNode referenceNode;
        Node node2 = treeTraversal.getFirstChild(node);
        if (node2 instanceof ReferenceNode && (referenceNode = (ReferenceNode)((Object)node2)).getReference().getReferenceType() == 1) {
            return referenceNode.getReferee();
        }
        return null;
    }

    public static final boolean isGlobal(Node node) {
        Node node2 = node.getParentNode();
        if (node2 != null) {
            return (node2 = node2.getParentNode()) != null && node2.getNodeType() == 9;
        }
        return false;
    }

    public static final Element getFirstElementChild(TreeTraversal treeTraversal, Node node) {
        Node node2 = treeTraversal.getFirstChild(node);
        while (node2 != null) {
            if (node2.getNodeType() == 1) {
                return (Element)node2;
            }
            node2 = treeTraversal.getNextSibling(node2);
        }
        return null;
    }

    public static final String translateXmlMarkup(String string) {
        int n = 0;
        while (n < markupTable.length) {
            Pattern pattern = Pattern.compile(markupTable[n]);
            Matcher matcher = pattern.matcher(string);
            string = matcher.replaceAll(markupTable[n + 1]);
            n += 2;
        }
        return string;
    }

    public static final String getName(Node node) {
        String string = null;
        if (node.getNodeType() == 1) {
            string = ModelUtils.getAttribute((Element)node, "name");
        }
        return string;
    }

    public static final String getAttribute(Element element, String string) {
        Attr attr = element.getAttributeNodeNS(null, string);
        return attr != null ? attr.getValue() : null;
    }

    public static final boolean areDifferent(Object object, Object object2) {
        return object == null && object2 != null || object != null && object2 == null || object != null && !object.equals(object2);
    }

    public static final boolean isAttribute(Node node) {
        String string = node.getLocalName();
        return "attribute".equals(string) || "attributeGroup".equals(string);
    }

    public static final boolean isContent(Node node, Node node2) {
        String string;
        String string2;
        int n = ModelUtils.getSchemaRole(node2);
        int n2 = ModelUtils.getSchemaRole(node);
        if (ModelUtils.isContainerRole(n) || n == -1 || n == 1 || n == 11 || n == 13) {
            return false;
        }
        if (ModelUtils.isAttributeRole(n) && n2 != 17) {
            return false;
        }
        if (n == 20 && (string2 = ModelUtils.getName(node2)) == null && n2 != 15 && n2 != 21) {
            return false;
        }
        return n != 8 || (string = ModelUtils.getName(node2)) != null;
    }

    public static final boolean hasContent(XmlView xmlView, Node node) {
        xmlView.acquireReadLock();
        try {
            TreeTraversal treeTraversal = xmlView.getTreeTraversal();
            Stack<Node> stack = new Stack<Node>();
            stack.push(node);
            while (!stack.isEmpty()) {
                ReferenceNode referenceNode;
                Node node2 = (Node)stack.pop();
                if (node2 instanceof ReferenceNode && ((referenceNode = (ReferenceNode)((Object)node2)).isCyclicReference() || (node2 = referenceNode.getReferee()) == null)) continue;
                int n = treeTraversal.getChildCount(node2);
                int n2 = 0;
                while (n2 < n) {
                    Node node3 = treeTraversal.getChild(node2, n2);
                    if (node3 instanceof ReferenceNode) {
                        ReferenceNode referenceNode2 = (ReferenceNode)((Object)node3);
                        int n3 = referenceNode2.getReference().getReferenceType();
                        if (n3 != 2) {
                            stack.push(node3);
                        }
                    } else if (ModelUtils.isContent(node, node3)) {
                        boolean bl = true;
                        xmlView.releaseReadLock();
                        return bl;
                    }
                    ++n2;
                }
            }
            boolean bl = false;
            xmlView.releaseReadLock();
            return bl;
        }
        catch (Throwable throwable) {
            xmlView.releaseReadLock();
            throw throwable;
        }
    }

    public static final int getContentCount(XmlView xmlView, Node node) {
        xmlView.acquireReadLock();
        try {
            TreeTraversal treeTraversal = xmlView.getTreeTraversal();
            int n = 0;
            Node node2 = treeTraversal.getFirstChild(node);
            while (node2 != null) {
                if (ModelUtils.isContent(node, node2)) {
                    ++n;
                }
                node2 = treeTraversal.getNextSibling(node2);
            }
            int n2 = n;
            xmlView.releaseReadLock();
            return n2;
        }
        catch (Throwable throwable) {
            xmlView.releaseReadLock();
            throw throwable;
        }
    }

    public static final void toggleReference(Node node) {
        Element element = (Element)node;
        Attr attr = element.getAttributeNodeNS(null, "ref");
        Attr attr2 = element.getAttributeNodeNS(null, "name");
        if (attr == null) {
            ModelUtils.removeContent(node);
            NamedNodeMap namedNodeMap = element.getAttributes();
            int n = namedNodeMap.getLength();
            int n2 = n - 1;
            while (n2 >= 0) {
                Attr attr3 = (Attr)namedNodeMap.item(n2);
                if (!"minOccurs".equals(attr3.getLocalName()) && !"maxOccurs".equals(attr3.getLocalName())) {
                    element.removeAttributeNode(attr3);
                }
                --n2;
            }
            element.setAttributeNS(null, "ref", attr2.getValue());
        } else {
            element.setAttributeNS(null, "name", ModelUtils.getName(attr.getValue()));
            element.removeAttributeNS(null, "ref");
        }
    }

    public static final void removeContent(Node node) {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        int n2 = n - 1;
        while (n2 >= 0) {
            Node node2 = nodeList.item(n2);
            int n3 = ModelUtils.getSchemaRole(node2);
            if (n3 != 1 && n3 != -1) {
                node.removeChild(node2);
            }
            --n2;
        }
    }

    public static final void removeFacets(Node node) {
        Node node2 = DomUtils.getNamedChild((Node)node, (String)"http://www.w3.org/2001/XMLSchema", (String)"restriction");
        if (node2 != null) {
            NodeList nodeList = node2.getChildNodes();
            int n = nodeList.getLength();
            int n2 = n - 1;
            while (n2 >= 0) {
                Node node3 = nodeList.item(n2);
                if (ModelUtils.getSchemaRole(node3) == 11) {
                    node2.removeChild(node3);
                }
                --n2;
            }
        }
    }

    public static final void copyContent(Node node, Node node2, TreeTraversal treeTraversal, DefaultPrefixLookup defaultPrefixLookup) {
        Node node3 = node;
        Stack<Node> stack = new Stack<Node>();
        while (node3 != null) {
            ReferenceNode referenceNode;
            stack.push(node3);
            Node node4 = treeTraversal.getFirstChild(node3);
            node3 = null;
            if (!(node4 instanceof ReferenceNode) || (referenceNode = (ReferenceNode)((Object)node4)).isCyclicReference()) continue;
            node3 = referenceNode.getReferee();
        }
        Node node5 = null;
        boolean bl = false;
        Document document = node2.getOwnerDocument();
        while (!stack.isEmpty()) {
            node3 = (Node)stack.pop();
            int n = treeTraversal.getChildCount(node3);
            int n2 = 0;
            while (n2 < n) {
                Node node6 = treeTraversal.getChild(node3, n2);
                int n3 = ModelUtils.getSchemaRole(node6);
                if (ModelUtils.isModelGroupRole(ModelUtils.getSchemaRole(node6))) {
                    Node node7 = node6;
                    if (node6 instanceof ProxyNode) {
                        node7 = ((ProxyNode)node6).getReferee();
                    }
                    Node node8 = ModelUtils.copyNode(node7, document);
                    if (node5 != null) {
                        if (!bl) {
                            Element element = document.createElementNS("http://www.w3.org/2001/XMLSchema", "sequence");
                            element.appendChild(node5);
                            node5 = element;
                            bl = true;
                        }
                        node5.appendChild(node8);
                    } else {
                        node5 = node8;
                    }
                }
                ++n2;
            }
        }
        if (node5 != null) {
            NamespaceUtils.fixPrefixes((Node)node2, node5, (DefaultPrefixLookup)defaultPrefixLookup);
            node2.appendChild(node5);
        }
    }

    public static final Node copyNode(Node node, Document document) {
        if (node.getOwnerDocument() == document) {
            return node.cloneNode(true);
        }
        return document.importNode(node, true);
    }

    public static final void copyAttr(Element element, Element element2, String string, String string2) {
        Attr attr = element.getAttributeNodeNS(string, string2);
        if (attr != null) {
            element2.setAttributeNS(attr.getNamespaceURI(), attr.getNodeName(), attr.getValue());
        }
    }

    public static final int getSchemaRole(Node node) {
        if (node.getNodeType() != 1) {
            return -1;
        }
        return ModelUtils.getSchemaRole(node.getNamespaceURI(), node.getLocalName());
    }

    public static final int getSchemaRole(String string, String string2) {
        Integer n;
        if ("http://www.w3.org/2001/XMLSchema".equals(string) && (n = (Integer)roleMap.get(string2)) != null) {
            return n;
        }
        return -1;
    }

    public static final boolean isSimpleType(XmlSchemaModel xmlSchemaModel, Node node, String string) {
        GlobalReference globalReference = new GlobalReference(xmlSchemaModel.getNamespace(node, string), ModelUtils.getName(string), 4);
        boolean bl = false;
        if (globalReference.isBuiltInType()) {
            return true;
        }
        Node node2 = xmlSchemaModel.resolveReference(globalReference);
        return node2 != null && ModelUtils.getSchemaRole(node2) == 20;
    }

    public static final boolean hasSimpleContent(XmlSchemaModel xmlSchemaModel, Node node, String string) {
        GlobalReference globalReference = new GlobalReference(xmlSchemaModel.getNamespace(node, string), ModelUtils.getName(string), 4);
        boolean bl = false;
        if (globalReference.isBuiltInType()) {
            return true;
        }
        Node node2 = xmlSchemaModel.resolveReference(globalReference);
        return node2 != null && ModelUtils.hasSimpleContent(node2);
    }

    public static final boolean hasSimpleContent(Node node) {
        if (ModelUtils.isSimpleTypeDefinition(node)) {
            return true;
        }
        if (ModelUtils.isComplexTypeDefinition(node)) {
            Node node2 = DomUtils.getNamedChild((Node)node, (String)"http://www.w3.org/2001/XMLSchema", (String)"simpleContent");
            return node2 != null;
        }
        return false;
    }

    public static Node createAnonymousSimpleType(XmlSchemaModel xmlSchemaModel, Element element) {
        String string = null;
        Attr attr = element.getAttributeNodeNS(null, "type");
        if (attr != null) {
            string = attr.getValue();
        }
        return ModelUtils.createAnonymousSimpleType(xmlSchemaModel, element, string);
    }

    public static Node createAnonymousSimpleType(XmlSchemaModel xmlSchemaModel, Element element, String string) {
        Attr attr = element.getAttributeNodeNS(null, "type");
        if (attr != null) {
            element.removeAttributeNode(attr);
        }
        DefaultPrefixLookup defaultPrefixLookup = xmlSchemaModel.getDefaultPrefixLookup();
        Document document = element.getOwnerDocument();
        Element element2 = document.createElementNS("http://www.w3.org/2001/XMLSchema", "simpleType");
        NamespaceUtils.fixPrefixes((Node)element, (Node)element2, (DefaultPrefixLookup)defaultPrefixLookup);
        element.appendChild(element2);
        Element element3 = element2;
        if (string != null) {
            Element element4 = document.createElementNS("http://www.w3.org/2001/XMLSchema", "restriction");
            element4.setAttributeNS(null, "base", string);
            NamespaceUtils.fixPrefixes((Node)element2, (Node)element4, (DefaultPrefixLookup)defaultPrefixLookup);
            element2.appendChild(element4);
            element3 = element4;
        }
        return element3;
    }

    public static Node createAnonymousComplexTypeWithExtension(XmlSchemaModel xmlSchemaModel, Element element) {
        String string = null;
        Attr attr = element.getAttributeNodeNS(null, "type");
        if (attr != null) {
            string = attr.getValue();
        }
        return ModelUtils.createAnonymousComplexTypeWithExtension(xmlSchemaModel, element, string);
    }

    public static Node createAnonymousComplexTypeWithExtension(XmlSchemaModel xmlSchemaModel, Element element, String string) {
        Attr attr = element.getAttributeNodeNS(null, "type");
        if (attr != null) {
            element.removeAttributeNode(attr);
        }
        DefaultPrefixLookup defaultPrefixLookup = xmlSchemaModel.getDefaultPrefixLookup();
        Document document = element.getOwnerDocument();
        Element element2 = document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
        NamespaceUtils.fixPrefixes((Node)element, (Node)element2, (DefaultPrefixLookup)defaultPrefixLookup);
        element.appendChild(element2);
        Element element3 = element2;
        if (string != null) {
            Element element4;
            Element element5;
            int n = ModelUtils.getContentType(xmlSchemaModel, element, string);
            element3 = n == 0 ? (element5 = document.createElementNS("http://www.w3.org/2001/XMLSchema", "simpleContent")) : (element4 = document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexContent"));
            NamespaceUtils.fixPrefixes((Node)element2, (Node)element3, (DefaultPrefixLookup)defaultPrefixLookup);
            element2.appendChild(element3);
            Element element6 = document.createElementNS("http://www.w3.org/2001/XMLSchema", "extension");
            element6.setAttributeNS(null, "base", string);
            NamespaceUtils.fixPrefixes((Node)element3, (Node)element6, (DefaultPrefixLookup)defaultPrefixLookup);
            element3.appendChild(element6);
            element3 = element6;
        }
        return element3;
    }

    public static Node createAnonymousComplexTypeWithRestriction(XmlSchemaModel xmlSchemaModel, Element element) {
        String string = null;
        Attr attr = element.getAttributeNodeNS(null, "type");
        if (attr != null) {
            string = attr.getValue();
        }
        return ModelUtils.createAnonymousComplexTypeWithRestriction(xmlSchemaModel, element, string);
    }

    public static Node createAnonymousComplexTypeWithRestriction(XmlSchemaModel xmlSchemaModel, Element element, String string) {
        Attr attr = element.getAttributeNodeNS(null, "type");
        if (attr != null) {
            element.removeAttributeNode(attr);
        }
        DefaultPrefixLookup defaultPrefixLookup = xmlSchemaModel.getDefaultPrefixLookup();
        Document document = element.getOwnerDocument();
        Element element2 = document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
        NamespaceUtils.fixPrefixes((Node)element, (Node)element2, (DefaultPrefixLookup)defaultPrefixLookup);
        element.appendChild(element2);
        Element element3 = element2;
        if (string != null) {
            GlobalReference globalReference;
            Node node;
            Element element4;
            Element element5;
            int n = ModelUtils.getContentType(xmlSchemaModel, element, string);
            element3 = n == 0 ? (element5 = document.createElementNS("http://www.w3.org/2001/XMLSchema", "simpleContent")) : (element4 = document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexContent"));
            NamespaceUtils.fixPrefixes((Node)element2, (Node)element3, (DefaultPrefixLookup)defaultPrefixLookup);
            element2.appendChild(element3);
            Element element6 = document.createElementNS("http://www.w3.org/2001/XMLSchema", "restriction");
            element6.setAttributeNS(null, "base", string);
            NamespaceUtils.fixPrefixes((Node)element3, (Node)element6, (DefaultPrefixLookup)defaultPrefixLookup);
            element3.appendChild(element6);
            element3 = element6;
            if (n == 1 && (node = xmlSchemaModel.resolveReference(globalReference = new GlobalReference(xmlSchemaModel.getNamespace(element, string), ModelUtils.getName(string), 4))) != null) {
                ModelUtils.copyContent(node, element3, (TreeTraversal)xmlSchemaModel.getSchemaTraversal(), defaultPrefixLookup);
            }
        }
        return element3;
    }

    public static final void removePath(Node node, Node node2) {
        Node node3;
        Node node4 = node2;
        do {
            if ((node3 = node4.getParentNode()) == null) continue;
            node3.removeChild(node4);
        } while ((node4 = node3) != null && node4 != node);
    }

    public static final int getContentType(XmlSchemaModel xmlSchemaModel, Node node, String string) {
        GlobalReference globalReference = new GlobalReference(xmlSchemaModel.getNamespace(node, string), ModelUtils.getName(string), 4);
        if (globalReference.isBuiltInType()) {
            return 0;
        }
        Node node2 = xmlSchemaModel.resolveReference(globalReference);
        if (node2 != null) {
            if (ModelUtils.hasSimpleContent(node2)) {
                return 0;
            }
            return 1;
        }
        return 2;
    }

    public static final void setBaseType(XmlSchemaLayoutView xmlSchemaLayoutView, Node node, String string) {
        Node node2 = null;
        boolean bl = false;
        GlobalReference globalReference = new GlobalReference(xmlSchemaLayoutView.getNamespace(node, string), ModelUtils.getName(string), 4);
        node2 = xmlSchemaLayoutView.resolveReference(globalReference);
        if (node2 != null) {
            bl = ModelUtils.hasSimpleContent(node2);
        } else if (globalReference.isBuiltInType()) {
            bl = true;
        }
        boolean bl2 = false;
        xmlSchemaLayoutView.getBaseModel().startTransaction(XmlSchemaArb.getString(11));
        try {
            Node node3 = DomUtils.getNamedChild((Node)node, (String)"http://www.w3.org/2001/XMLSchema", (String)"simpleContent");
            Node node4 = DomUtils.getNamedChild((Node)node, (String)"http://www.w3.org/2001/XMLSchema", (String)"complexContent");
            Node node5 = bl ? node3 : node4;
            Node node6 = bl ? node4 : node3;
            Document document = node.getOwnerDocument();
            DefaultPrefixLookup defaultPrefixLookup = xmlSchemaLayoutView.getBaseModel().getDefaultPrefixLookup();
            if (node5 == null) {
                Node node7;
                ModelUtils.removeContent(node);
                node5 = document.createElementNS("http://www.w3.org/2001/XMLSchema", bl ? "simpleContent" : "complexContent");
                NamespaceUtils.fixPrefixes((Node)node, (Node)node5, (DefaultPrefixLookup)defaultPrefixLookup);
                node.appendChild(node5);
                if (node6 != null && (node7 = DomUtils.getNamedChild((Node)node6, (String)"http://www.w3.org/2001/XMLSchema", (String)"restriction")) != null) {
                    bl2 = true;
                }
            } else {
                Node node8 = DomUtils.getNamedChild((Node)node5, (String)"http://www.w3.org/2001/XMLSchema", (String)"restriction");
                if (node8 != null) {
                    bl2 = true;
                }
            }
            Node node9 = null;
            if (bl2) {
                node9 = DomUtils.getNamedChild((Node)node5, (String)"http://www.w3.org/2001/XMLSchema", (String)"restriction");
                if (node9 == null) {
                    node9 = document.createElementNS("http://www.w3.org/2001/XMLSchema", "restriction");
                    NamespaceUtils.fixPrefixes((Node)node5, (Node)node9, (DefaultPrefixLookup)defaultPrefixLookup);
                    node5.appendChild(node9);
                }
                ModelUtils.removeContent(node9);
                if (!bl && node2 != null) {
                    ModelUtils.copyContent(node2, node9, xmlSchemaLayoutView.getTreeTraversal(), defaultPrefixLookup);
                }
            } else {
                node9 = DomUtils.getNamedChild((Node)node5, (String)"http://www.w3.org/2001/XMLSchema", (String)"extension");
                if (node9 == null) {
                    node9 = document.createElementNS("http://www.w3.org/2001/XMLSchema", "extension");
                    NamespaceUtils.fixPrefixes((Node)node5, (Node)node9, (DefaultPrefixLookup)defaultPrefixLookup);
                    node5.appendChild(node9);
                }
            }
            ((Element)node9).setAttributeNS(null, "base", string);
            xmlSchemaLayoutView.getBaseModel().commitTransaction();
        }
        catch (XmlCommitException xmlCommitException) {
            xmlSchemaLayoutView.getBaseModel().rollbackTransaction();
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)((Object)xmlCommitException));
        }
        catch (ThreadDeath threadDeath) {
            xmlSchemaLayoutView.getBaseModel().rollbackTransaction();
            throw threadDeath;
        }
        catch (Throwable throwable) {
            xmlSchemaLayoutView.getBaseModel().rollbackTransaction();
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)throwable);
        }
    }

    public static final Element getChild(Node node, String string) {
        Node node2 = DomUtils.getNamedChild((Node)node, (String)"http://www.w3.org/2001/XMLSchema", (String)string);
        if (node2 != null && node2.getNodeType() == 1) {
            return (Element)node2;
        }
        return null;
    }

    public static final Node getAnonymousType(Node node) {
        Element element = ModelUtils.getChild(node, "simpleType");
        if (element == null) {
            element = ModelUtils.getChild(node, "complexType");
        }
        return element;
    }

    public static final DomPosition getAnnotationInsertionPosition(Node node) {
        Object var1_1 = null;
        int n = ModelUtils.getSchemaRole(node);
        if (n != 17 && n != 14) {
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                int n2 = ModelUtils.getSchemaRole(node2);
                if (n2 != 1 && n2 != -1) break;
                node2 = node2.getNextSibling();
            }
            if (node2 != null) {
                return DomPositionFactory.createDomPosition((Node)node2, (int)1);
            }
        }
        return DomPositionFactory.createDomPosition((Node)node, (int)0);
    }
}

