/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Shape;
import oracle.jdevimpl.xml.schema.ReferenceNode;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.DiagramComponent;
import oracle.jdevimpl.xml.schema.diagram.GraphicsUtils;
import oracle.jdevimpl.xml.schema.diagram.ReferenceComponent;
import oracle.jdevimpl.xml.schema.diagram.Subtree;
import oracle.jdevimpl.xml.schema.diagram.TopLevelComponent;
import org.w3c.dom.Element;

public class ReferenceSubtree
extends Subtree {
    private ReferenceNode reference;
    private ReferenceComponent name;
    private boolean showBox;

    public ReferenceSubtree(Diagram diagram, ReferenceNode referenceNode) {
        super(diagram, new TopLevelComponent(diagram, diagram.getComponentFactory().createSchemaComponent(referenceNode.getReferee())));
        this.reference = referenceNode;
        boolean bl = this.showBox = referenceNode.isExternal() || referenceNode.getReference().getReferenceType() != 1;
        if (this.showBox) {
            this.setShowBorder(true);
            this.setStroke(new BasicStroke(2.0f));
            this.name = new ReferenceComponent(diagram, (Element)referenceNode.getReferee());
            if (referenceNode.isExternal()) {
                this.setBackground(GraphicsUtils.EXTERNAL_REFERENCE_COLOR);
                this.setForeground(GraphicsUtils.EXTERNAL_REFERENCE_COLOR_DARK);
                this.name.setBackground(GraphicsUtils.EXTERNAL_REFERENCE_COLOR_DARK);
            } else {
                this.setBackground(GraphicsUtils.REFERENCE_COLOR);
                this.setForeground(GraphicsUtils.REFERENCE_COLOR_DARK);
                this.name.setBackground(GraphicsUtils.REFERENCE_COLOR_DARK);
            }
            this.name.setForeground(Color.GRAY);
            this.name.setInsets(new Insets(2, 5, 2, 5));
            this.add(this.name);
        }
        this.root.setVisible(false);
        this.setExpanded(true);
    }

    protected void computeSizes() {
        if (this.showBox) {
            this.insets = new Insets(this.name.getPreferredHeight() + 11, 10, 10, 10);
        }
        super.computeSizes();
    }

    public int getPreferredWidth() {
        int n = super.getPreferredWidth();
        if (this.showBox) {
            n = Math.max(n, this.name.getPreferredWidth() + 2);
        }
        return n;
    }

    public void layout() {
        if (this.showBox) {
            int n = this.name.getPreferredWidth();
            this.name.setBounds((this.width - n) / 2, 1, n, this.name.getPreferredHeight());
        }
        super.layout();
    }

    public Shape getDomPositionShape(DiagramComponent diagramComponent, int n) {
        if (diagramComponent == this.name) {
            return null;
        }
        return super.getDomPositionShape(diagramComponent, n);
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.showBox) {
            Color color = graphics.getColor();
            if (this.reference.isExternal()) {
                graphics.setColor(GraphicsUtils.EXTERNAL_REFERENCE_COLOR_DARK);
            } else {
                graphics.setColor(GraphicsUtils.REFERENCE_COLOR_DARK);
            }
            graphics.fillRect(0, 0, this.width, this.name.getY() + this.name.getHeight());
            graphics.setColor(color);
        }
    }

    public Color getBackground() {
        if (this.showBox) {
            if (this.reference.isExternal()) {
                return GraphicsUtils.EXTERNAL_REFERENCE_COLOR;
            }
            return GraphicsUtils.REFERENCE_COLOR;
        }
        return super.getBackground();
    }

    public Color getBorderColor() {
        if (this.showBox) {
            if (this.reference.isExternal()) {
                return GraphicsUtils.EXTERNAL_REFERENCE_COLOR_DARK;
            }
            return GraphicsUtils.REFERENCE_COLOR_DARK;
        }
        return super.getBorderColor();
    }
}

