/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import oracle.bali.xml.model.XmlCommitException;
import oracle.jdevimpl.xml.schema.XmlSchemaLayoutView;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.EditableTextComponent;
import oracle.jdevimpl.xml.schema.diagram.GraphicsUtils;
import oracle.jdevimpl.xml.schema.diagram.HierarchalSchemaComponent;
import oracle.jdevimpl.xml.schema.diagram.TextComponent;
import oracle.jdevimpl.xml.schema.resource.XmlSchemaArb;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class SchemaRootComponent
extends HierarchalSchemaComponent
implements TextListener {
    private TextComponent name;
    private TextComponent label;
    private EditableTextComponent targetNamespace;

    public SchemaRootComponent(Diagram diagram, Element element) {
        super(diagram, element);
        this.name = new TextComponent(diagram);
        this.name.setInsets(new Insets(3, 10, 3, 10));
        this.name.setFont(GraphicsUtils.getDiagramFont().deriveFont(1));
        this.name.setText("<schema>");
        this.add(this.name);
        this.update();
    }

    public void destroy() {
        if (this.targetNamespace != null) {
            this.targetNamespace.removeTextListener(this);
        }
    }

    public int getChildConnectionXOffset() {
        return 15;
    }

    public int getChildConnectionYOffset() {
        return this.getPreferredHeight();
    }

    public Shape getShape() {
        int[] nArray = new int[]{0, this.width - 6, this.width - 1, this.width - 1, 0, 0};
        int[] nArray2 = new int[]{0, 0, 5, this.height - 1, this.height - 1, 0};
        return new Polygon(nArray, nArray2, nArray.length);
    }

    public int getPreferredWidth() {
        int n = this.name.getPreferredWidth() + 5;
        if (this.targetNamespace != null) {
            n = Math.max(n, this.label.getPreferredWidth() + this.targetNamespace.getPreferredWidth() + 1);
        }
        return n += this.insets.left + this.insets.right;
    }

    public int getPreferredHeight() {
        int n = this.name.getPreferredHeight() + this.insets.top + this.insets.bottom;
        if (this.targetNamespace != null) {
            n += Math.max(this.label.getPreferredHeight(), this.targetNamespace.getPreferredHeight()) + 1;
        }
        return n;
    }

    public void layout() {
        this.name.setBounds(this.insets.left, this.insets.top, this.width - this.insets.left - this.insets.right - 5, this.name.getPreferredHeight());
        if (this.targetNamespace != null) {
            int n = Math.max(this.label.getPreferredHeight(), this.targetNamespace.getPreferredHeight());
            this.label.setBounds(this.insets.left, this.insets.top + this.name.getHeight() + 1, this.label.getPreferredWidth(), n);
            this.targetNamespace.setBounds(this.insets.left + this.label.getWidth() + 1, this.insets.top + this.name.getHeight() + 1, this.targetNamespace.getPreferredWidth(), n);
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.targetNamespace != null) {
            int n = this.insets.top + this.name.getHeight();
            graphics.drawLine(0, n, this.width - 1, n);
            int n2 = this.label.getX() + this.label.getWidth();
            graphics.drawLine(n2, n, n2, this.height - 1);
        }
        graphics.drawLine(this.width - 6, 0, this.width - 6, 6);
        graphics.drawLine(this.width - 6, 6, this.width - 1, 6);
    }

    public void update() {
        Attr attr = this.element.getAttributeNodeNS(null, "targetNamespace");
        if (attr != null) {
            if (this.targetNamespace == null) {
                this.label = new TextComponent(this.diagram);
                this.label.setInsets(new Insets(2, 3, 2, 3));
                this.label.setText("targetNamespace");
                this.add(this.label);
                this.targetNamespace = new EditableTextComponent(this.diagram);
                this.targetNamespace.setInsets(new Insets(2, 3, 2, 3));
                this.targetNamespace.addTextListener(this);
                this.add(this.targetNamespace);
            }
            this.targetNamespace.setText(attr.getValue());
        } else if (this.targetNamespace != null) {
            this.remove(this.label);
            this.remove(this.targetNamespace);
            this.targetNamespace.removeTextListener(this);
            this.label = null;
            this.targetNamespace = null;
        }
    }

    public void textValueChanged(TextEvent textEvent) {
        String string = this.targetNamespace.getText().trim();
        Attr attr = this.element.getAttributeNodeNS(null, "targetNamespace");
        if (attr != null) {
            String string2 = attr.getValue();
            XmlSchemaLayoutView xmlSchemaLayoutView = this.diagram.getView();
            boolean bl = false;
            xmlSchemaLayoutView.startTransaction(XmlSchemaArb.getString(10));
            try {
                if (string.length() == 0) {
                    attr.getOwnerElement().removeAttributeNode(attr);
                    bl = true;
                } else {
                    attr.setValue(string);
                }
                if (string2 != null && !bl) {
                    NamedNodeMap namedNodeMap = this.element.getAttributes();
                    int n = 0;
                    while (n < namedNodeMap.getLength()) {
                        Attr attr2 = (Attr)namedNodeMap.item(n);
                        if ("http://www.w3.org/2000/xmlns/".equals(attr2.getNamespaceURI()) && string2.equals(attr2.getValue())) {
                            attr2.setValue(string);
                        }
                        ++n;
                    }
                }
                xmlSchemaLayoutView.commitTransaction();
            }
            catch (XmlCommitException xmlCommitException) {
                xmlSchemaLayoutView.rollbackTransaction();
            }
            catch (ThreadDeath threadDeath) {
                xmlSchemaLayoutView.rollbackTransaction();
                throw threadDeath;
            }
            catch (Throwable throwable) {
                xmlSchemaLayoutView.rollbackTransaction();
            }
        }
    }
}

