/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JToolTip;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;

public class SchemaToolTip
extends JToolTip {
    private JLabel nameLabel;
    private MultiLineLabel annotationLabel;

    public void updateUI() {
        super.updateUI();
        this.createLabels();
        this.nameLabel.setForeground(null);
        this.nameLabel.setBackground(null);
        this.nameLabel.setFont(this.getFont().deriveFont(1));
        this.annotationLabel.setForeground(null);
        this.annotationLabel.setBackground(null);
        this.annotationLabel.setFont(null);
    }

    protected void paintComponent(Graphics graphics) {
        Color color = graphics.getColor();
        Insets insets = this.getInsets();
        graphics.setColor(this.getBackground());
        graphics.fillRect(insets.top, insets.left, this.getWidth() - insets.right - insets.left, this.getHeight() - insets.top - insets.bottom);
        graphics.setColor(color);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getPreferredSize() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Dimension dimension = this.getLayout().preferredLayoutSize(this);
            return dimension;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getMinimumSize() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Dimension dimension = this.getLayout().minimumLayoutSize(this);
            return dimension;
        }
    }

    public void setTipText(String string) {
        int n;
        this.createLabels();
        String string2 = null;
        String string3 = string;
        if (string != null && string.startsWith("%%%") && (n = string.indexOf("%%%", 3)) != -1) {
            string2 = string.substring(3, n);
            string3 = string.substring(n + 3);
            if (string3.length() == 0) {
                string3 = null;
            }
        }
        this.nameLabel.setText(string2);
        this.nameLabel.setVisible(string2 != null);
        this.annotationLabel.setText(string3);
        this.annotationLabel.setVisible(string3 != null);
        super.setTipText(string);
    }

    private void createLabels() {
        if (this.nameLabel == null) {
            this.setLayout(new BorderLayout());
            this.nameLabel = new JLabel();
            this.nameLabel.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
            this.add((Component)this.nameLabel, "North");
            this.annotationLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), null);
            this.annotationLabel.setPreferredColumns(50);
            this.annotationLabel.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
            this.add((Component)this.annotationLabel, "Center");
        }
    }
}

