/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.util.DefaultPrefixLookup;
import oracle.bali.xml.util.NamespaceUtils;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdevimpl.xml.schema.ReferenceNode;
import oracle.jdevimpl.xml.schema.XmlSchemaEditorController;
import oracle.jdevimpl.xml.schema.diagram.AttrEditor;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.FacetContainer;
import oracle.jdevimpl.xml.schema.diagram.GraphicsUtils;
import oracle.jdevimpl.xml.schema.diagram.HierarchalSchemaComponent;
import oracle.jdevimpl.xml.schema.diagram.ListChangeListener;
import oracle.jdevimpl.xml.schema.diagram.ListComponent;
import oracle.jdevimpl.xml.schema.diagram.ModelUtils;
import oracle.jdevimpl.xml.schema.diagram.TextComponent;
import oracle.jdevimpl.xml.schema.diagram.TypeEditor;
import oracle.jdevimpl.xml.schema.resource.XmlSchemaArb;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SimpleTypeDefinition
extends HierarchalSchemaComponent
implements ListChangeListener {
    private TextComponent name;
    private TypeEditor type;
    private TextComponent restricts;
    private FacetContainer facets;
    private static final int MINIMUM_WIDTH = 60;
    private static final int MAXIMUM_WIDTH = 200;
    private static final Color COLOR = new Color(90, 186, 90);

    public SimpleTypeDefinition(Diagram diagram, Element element) {
        super(diagram, element);
        this.setBackground(COLOR);
        this.setForeground(Color.BLACK);
        Attr attr = element.getAttributeNodeNS(null, "name");
        this.restricts = new TextComponent(diagram);
        this.restricts.setText(XmlSchemaArb.getString(27));
        this.restricts.setInsets(new Insets(0, 10, 2, 5));
        this.add(this.restricts);
        this.type = new TypeEditor(diagram, 3);
        this.type.setInsets(new Insets(0, 0, 2, 0));
        this.type.addListChangeListener(this);
        this.add(this.type);
        this.update();
    }

    public void destroy() {
        super.destroy();
        this.type.removeListChangeListener(this);
    }

    public int getPreferredWidth() {
        int n = this.name.getPreferredWidth() + 10;
        if (this.facets != null) {
            n = Math.max(n, this.facets.getPreferredWidth());
        }
        int n2 = this.type.getPreferredWidth() + 10;
        if (this.restricts.isVisible()) {
            n2 += this.restricts.getPreferredWidth();
        }
        n = Math.max(n, n2);
        n += this.insets.left + this.insets.right;
        n = Math.max(n, 60);
        n = Math.min(n, 200);
        return n;
    }

    public int getPreferredHeight() {
        int n = this.type.getPreferredHeight();
        if (n == 0) {
            n = 2;
        }
        if (this.restricts.isVisible()) {
            n = Math.max(this.restricts.getPreferredHeight(), n);
        }
        int n2 = 0;
        if (this.facets != null) {
            n2 = this.facets.getPreferredHeight();
        }
        return this.insets.top + this.name.getPreferredHeight() + n + n2 + (n2 > 0 ? 1 : 0) + this.insets.bottom;
    }

    public Shape getShape() {
        int n = this.getWidth();
        int[] nArray = new int[]{0, 5, n - 6, n - 1, n - 1, n - 2, 1, 0, 0};
        int[] nArray2 = new int[]{5, 0, 0, 5, this.height - 2, this.height - 1, this.height - 1, this.height - 2, 5};
        return new Polygon(nArray, nArray2, nArray.length);
    }

    public void layout() {
        int n = this.width - this.insets.left - this.insets.right;
        int n2 = n - 10;
        this.name.setBounds(this.insets.left + 5, this.insets.top, n2, this.name.getPreferredHeight());
        int n3 = this.insets.left;
        int n4 = n;
        if (this.restricts.isVisible()) {
            this.restricts.setBounds(n3, this.insets.top + this.name.getHeight(), this.restricts.getPreferredWidth(), this.restricts.getPreferredHeight());
            n3 += this.restricts.getWidth();
            n4 -= this.restricts.getWidth();
        }
        this.type.setBounds(n3, this.insets.top + this.name.getHeight(), n4, this.type.getPreferredHeight());
        int n5 = Math.max(this.type.getHeight(), this.restricts.getHeight());
        if (n5 == 0) {
            n5 = 2;
        }
        if (this.facets != null) {
            this.facets.setBounds(this.insets.left, this.insets.top + this.name.getHeight() + n5 + 1, n, this.facets.getPreferredHeight());
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.facets != null) {
            int n = this.insets.top + this.name.getHeight() + Math.max(this.type.getHeight(), this.restricts.getHeight());
            if (this.type.getHeight() == 0) {
                n += 2;
            }
            graphics.drawLine(this.insets.left, n, this.width - 1, n);
        }
    }

    public void update() {
        super.update();
        if (this.name != null) {
            this.name.destroy();
            this.remove(this.name);
            this.name = null;
        }
        this.diagram.getView().acquireReadLock();
        try {
            Attr attr = this.element.getAttributeNodeNS(null, "name");
            if (attr != null) {
                this.name = new AttrEditor(this.diagram, attr);
            } else {
                this.name = new TextComponent(this.diagram);
                this.name.setText("<simpleType>");
            }
            this.name.setFont(GraphicsUtils.getDiagramFont().deriveFont(1));
            this.name.setInsets(new Insets(3, 5, 0, 5));
            this.add(this.name);
            Node node = this.diagram.getView().getTreeTraversal().getFirstChild((Node)this.element);
            if (node instanceof ReferenceNode) {
                this.restricts.setVisible(true);
                this.type.setReference((ReferenceNode)((Object)node));
            } else {
                this.restricts.setVisible(false);
                this.type.setReference(null);
            }
            Node node2 = DomUtils.getNamedChild((TreeTraversal)this.diagram.getView().getTreeTraversal(), (Node)this.element, (String)"http://www.w3.org/2001/XMLSchema", (String)"list");
            Node node3 = DomUtils.getNamedChild((TreeTraversal)this.diagram.getView().getTreeTraversal(), (Node)this.element, (String)"http://www.w3.org/2001/XMLSchema", (String)"union");
            if (node2 == null && node3 == null) {
                if (this.facets == null) {
                    this.facets = new FacetContainer(this.diagram, this.element);
                    this.add(this.facets);
                }
            } else if (this.facets != null) {
                this.facets.destroy();
                this.remove(this.facets);
                this.facets = null;
            }
        }
        finally {
            this.diagram.getView().releaseReadLock();
        }
    }

    public List getActions() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(3);
        arrayList.addAll(super.getActions());
        this.diagram.getView().acquireReadLock();
        try {
            TreeTraversal treeTraversal = this.diagram.getView().getTreeTraversal();
            Node node = treeTraversal.getFirstChild((Node)this.element);
            if (!(node instanceof ReferenceNode)) {
                arrayList.add(new Integer(XmlSchemaEditorController.SET_BASE_TYPE_CMD_ID));
            }
        }
        finally {
            this.diagram.getView().releaseReadLock();
        }
        return arrayList;
    }

    public boolean handleAction(IdeAction ideAction) {
        if (ideAction.getCommandId() == XmlSchemaEditorController.SET_BASE_TYPE_CMD_ID) {
            this.setBaseType();
            return true;
        }
        return super.handleAction(ideAction);
    }

    private void setBaseType() {
        this.diagram.getView().acquireReadLock();
        try {
            Attr attr = this.diagram.getView().getDocument().createAttributeNS(null, "base");
            this.type.setAttr(attr);
            this.type.startEditing();
        }
        finally {
            this.diagram.getView().releaseReadLock();
        }
    }

    public void valueChanged(ListComponent listComponent) {
        if (listComponent == this.type) {
            this.handleTypeChange();
        }
    }

    private void handleTypeChange() {
        String string = this.type.getText().trim();
        if (string.length() == 0) {
            this.removeType();
        } else {
            this.setType(string);
        }
    }

    private void removeType() {
        Attr attr = this.type.getAttr();
        Element element = attr.getOwnerElement();
        if (element != null) {
            this.diagram.getModel().startTransaction(XmlSchemaArb.getString(11));
            try {
                element.removeAttributeNode(attr);
                if (element != this.element) {
                    ModelUtils.removePath(this.element, element);
                }
                this.diagram.getModel().commitTransaction();
            }
            catch (XmlCommitException xmlCommitException) {
                this.diagram.getModel().rollbackTransaction();
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)((Object)xmlCommitException));
            }
            catch (ThreadDeath threadDeath) {
                this.diagram.getModel().rollbackTransaction();
                throw threadDeath;
            }
            catch (Throwable throwable) {
                this.diagram.getModel().rollbackTransaction();
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)throwable);
            }
        } else {
            this.type.setAttr(null);
        }
    }

    private void setType(String string) {
        this.diagram.getModel().startTransaction(XmlSchemaArb.getString(11));
        try {
            Document document = this.element.getOwnerDocument();
            DefaultPrefixLookup defaultPrefixLookup = this.diagram.getView().getBaseModel().getDefaultPrefixLookup();
            Element element = (Element)DomUtils.getNamedChild((Node)this.element, (String)"http://www.w3.org/2001/XMLSchema", (String)"restriction");
            if (element == null) {
                element = document.createElementNS("http://www.w3.org/2001/XMLSchema", "restriction");
                NamespaceUtils.fixPrefixes((Node)this.element, (Node)element, (DefaultPrefixLookup)defaultPrefixLookup);
                this.element.appendChild(element);
            }
            element.setAttributeNS(null, "base", string);
            ModelUtils.removeFacets(this.element);
            this.diagram.getModel().commitTransaction();
        }
        catch (XmlCommitException xmlCommitException) {
            this.diagram.getModel().rollbackTransaction();
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)((Object)xmlCommitException));
        }
        catch (ThreadDeath threadDeath) {
            this.diagram.getModel().rollbackTransaction();
            throw threadDeath;
        }
        catch (Throwable throwable) {
            this.diagram.getModel().rollbackTransaction();
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)throwable);
        }
    }
}

