/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.model.XmlView;
import oracle.jdevimpl.xml.schema.NodeListener;
import oracle.jdevimpl.xml.schema.ReferenceNode;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.DiagramComponent;
import oracle.jdevimpl.xml.schema.diagram.Expandable;
import oracle.jdevimpl.xml.schema.diagram.HierarchalSchemaComponent;
import oracle.jdevimpl.xml.schema.diagram.IconicModelGroup;
import oracle.jdevimpl.xml.schema.diagram.ModelUtils;
import oracle.jdevimpl.xml.schema.diagram.ReferenceSubtree;
import oracle.jdevimpl.xml.schema.diagram.TopLevelComponent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Subtree
extends DiagramComponent
implements NodeListener,
Expandable {
    protected TopLevelComponent root;
    protected Subtree[] subtrees;
    protected boolean expanded;
    protected static final int PARENT_CHILD_SPACING = 20;
    protected static final int SIBLING_SPACING = 5;
    private static final Object EXPANDED = new Object();
    protected int layoutWidth;
    protected int layoutHeight;
    private int a;
    private int b;
    private int rootChildCount;

    void $init$() {
        this.layoutWidth = -1;
        this.layoutHeight = -1;
        this.rootChildCount = -1;
    }

    public Subtree(Diagram diagram, TopLevelComponent topLevelComponent) {
        super(diagram);
        this.$init$();
        this.root = topLevelComponent;
        this.add(topLevelComponent);
        if (topLevelComponent.getComponent() instanceof IconicModelGroup) {
            this.setExpanded(true);
        }
        this.rootChildCount = ModelUtils.getContentCount((XmlView)diagram.getView(), topLevelComponent.getComponent().getDomElement());
        diagram.getView().addNodeListener(topLevelComponent.getComponent().getDomElement(), this);
    }

    public void destroy() {
        super.destroy();
        this.destroySubtrees();
        this.root.destroy();
        this.diagram.getView().removeNodeListener(this.root.getComponent().getDomElement(), this);
    }

    public void nodeChanged(Node node) {
        this.update();
    }

    public void referenceChanged(Node node) {
        this.update();
    }

    public TopLevelComponent getRoot() {
        return this.root;
    }

    public void update() {
        this.expandIfNodesAdded();
        if (this.expanded || this.subtrees != null) {
            Map map = this.saveExpansionState();
            this.destroySubtrees();
            this.createSubtrees();
            this.restoreExpansionState(map);
        }
    }

    public int getPreferredWidth() {
        if (this.layoutWidth == -1) {
            this.computeSizes();
        }
        return this.layoutWidth;
    }

    public int getPreferredHeight() {
        if (this.layoutWidth == -1) {
            this.computeSizes();
        }
        return this.layoutHeight;
    }

    public Color getBackground() {
        if (this.parent != null) {
            return this.parent.getBackground();
        }
        return super.getBackground();
    }

    public Subtree getFirstSubtree() {
        if (this.subtrees == null) {
            this.createSubtrees();
        }
        return this.subtrees.length == 0 ? null : this.subtrees[0];
    }

    public Subtree getNextSubtree(Subtree subtree) {
        if (this.subtrees.length == 1) {
            return null;
        }
        int n = this.getIndexOf(subtree);
        if (n == -1) {
            return null;
        }
        return n < this.subtrees.length - 1 ? this.subtrees[n + 1] : this.subtrees[0];
    }

    public Subtree getPreviousSubtree(Subtree subtree) {
        if (this.subtrees.length == 1) {
            return null;
        }
        int n = this.getIndexOf(subtree);
        if (n == -1) {
            return null;
        }
        return n > 0 ? this.subtrees[n - 1] : this.subtrees[this.subtrees.length - 1];
    }

    protected void computeSizes() {
        this.layoutWidth = this.insets.left + (this.root.isVisible() ? this.root.getPreferredWidth() : 0) + this.insets.right;
        if (this.expanded && this.subtrees.length > 0) {
            this.layoutWidth = this.subtrees.length == 1 ? (this.layoutWidth += 10) : (this.layoutWidth += 20);
            int n = 0;
            this.a = this.root.isVisible() ? this.root.getChildConnectionYOffset() : 0;
            this.b = 0;
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.subtrees.length) {
                if (this.subtrees[n3].getPreferredWidth() > n) {
                    n = this.subtrees[n3].getPreferredWidth();
                }
                n2 += this.subtrees[n3].getPreferredHeight();
                this.b = n3 == this.subtrees.length - 1 ? (this.b += this.subtrees[n3].getConnectionYOffset()) : (this.b += this.subtrees[n3].getPreferredHeight());
                if (n3 == 0) {
                    this.b -= this.subtrees[n3].getConnectionYOffset();
                }
                ++n3;
            }
            this.layoutWidth += n;
            int n4 = 5 * (this.subtrees.length - 1);
            this.b += n4;
            this.b = this.b / 2 + this.subtrees[0].getConnectionYOffset();
            int n5 = this.root.isVisible() ? this.root.getPreferredHeight() - this.a : 0;
            int n6 = (n2 += n4) - this.b;
            this.layoutHeight = this.insets.top + Math.max(this.a, this.b) + Math.max(n5, n6) + this.insets.bottom;
        } else {
            this.b = 0;
            this.a = 0;
            this.layoutWidth = this.insets.left + this.root.getPreferredWidth() + this.insets.right;
            this.layoutHeight = this.insets.top + this.root.getPreferredHeight() + this.insets.bottom;
        }
    }

    public void paintChildren(Graphics graphics) {
        super.paintChildren(graphics);
        if (this.expanded && this.subtrees.length > 0) {
            this.paintEdges(graphics);
        }
    }

    protected void paintEdges(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = this.root.isVisible() ? this.root.getX() + this.root.getChildConnectionXOffset() : this.insets.left;
        int n2 = this.root.isVisible() ? this.root.getY() + this.root.getChildConnectionYOffset() : this.b + this.insets.top;
        int n3 = 0;
        while (n3 < this.subtrees.length) {
            Subtree subtree = this.subtrees[n3];
            Stroke stroke = subtree.getRoot().getStroke();
            Stroke stroke2 = null;
            if (stroke != null) {
                stroke2 = graphics2D.getStroke();
                graphics2D.setStroke(stroke);
            }
            int n4 = n;
            int n5 = n2;
            int n6 = this.root.isVisible() ? (this.root.getX() + this.root.getWidth() + subtree.getX()) / 2 : (n + subtree.getX()) / 2;
            int n7 = n5;
            graphics.drawLine(n4, n5, n6, n7);
            n4 = n6;
            n7 = subtree.getY() + subtree.getConnectionYOffset();
            graphics.drawLine(n4, n5, n6, n7);
            n5 = n7;
            n6 = subtree.getX() + subtree.getConnectionXOffset();
            graphics.drawLine(n4, n5, n6, n7);
            if (stroke2 != null) {
                graphics2D.setStroke(stroke2);
            }
            ++n3;
        }
    }

    public void layout() {
        int n;
        if (this.layoutWidth == -1) {
            this.computeSizes();
        }
        if (this.expanded && this.subtrees.length > 0) {
            if (this.a > this.b) {
                this.root.setBounds(this.insets.left, this.insets.top, this.root.getPreferredWidth(), this.root.getPreferredHeight());
                n = this.insets.top + this.a - this.b;
            } else {
                this.root.setBounds(this.insets.left, this.insets.top + this.b - this.a, this.root.getPreferredWidth(), this.root.getPreferredHeight());
                n = this.insets.top;
            }
        } else {
            this.root.setBounds(this.insets.left, this.insets.top, this.root.getPreferredWidth(), this.root.getPreferredHeight());
            n = 0;
        }
        if (this.expanded) {
            int n2 = this.insets.left + (this.root.isVisible() ? this.root.getWidth() : 0) + (this.subtrees.length > 1 ? 20 : 10);
            int n3 = 0;
            while (n3 < this.subtrees.length) {
                this.subtrees[n3].setBounds(n2, n, this.subtrees[n3].getPreferredWidth(), this.subtrees[n3].getPreferredHeight());
                n += this.subtrees[n3].getHeight();
                if (n3 < this.subtrees.length - 1) {
                    n += 5;
                }
                ++n3;
            }
        }
    }

    public int getConnectionXOffset() {
        return this.insets.left + (this.root.isVisible() ? this.root.getParentConnectionXOffset() : 0);
    }

    public int getConnectionYOffset() {
        if (this.layoutWidth == -1) {
            this.computeSizes();
        }
        if (this.expanded && this.subtrees.length > 0) {
            if (this.a > this.b) {
                return this.insets.top + this.a;
            }
            return this.insets.top + this.b;
        }
        return this.insets.top + this.root.getChildConnectionYOffset();
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean bl) {
        if (bl != this.expanded) {
            this.expanded = bl;
            if (bl && this.subtrees == null) {
                this.createSubtrees();
            }
            if (this.subtrees != null) {
                int n = 0;
                while (n < this.subtrees.length) {
                    this.subtrees[n].setVisible(bl);
                    ++n;
                }
                this.invalidate();
            }
        }
    }

    public void expandAll() {
        this.setExpanded(true);
        int n = 0;
        while (n < this.subtrees.length) {
            this.subtrees[n].expandAll();
            ++n;
        }
    }

    public void invalidate() {
        super.invalidate();
        this.layoutWidth = -1;
    }

    public int getChildCount() {
        if (this.subtrees == null) {
            this.createSubtrees();
        }
        return super.getChildCount();
    }

    public DiagramComponent getChild(int n) {
        if (this.subtrees == null) {
            this.createSubtrees();
        }
        return super.getChild(n);
    }

    protected void createSubtrees() {
        XmlView xmlView = this.diagram.getGui().getView();
        xmlView.acquireReadLock();
        try {
            TreeTraversal treeTraversal = xmlView.getTreeTraversal();
            Element element = this.root.getComponent().getDomElement();
            int n = treeTraversal.getChildCount((Node)element);
            ArrayList<DiagramComponent> arrayList = new ArrayList<DiagramComponent>(n);
            int n2 = 0;
            while (n2 < n) {
                HierarchalSchemaComponent hierarchalSchemaComponent;
                DiagramComponent diagramComponent = null;
                Node node = treeTraversal.getChild((Node)element, n2);
                if (node instanceof ReferenceNode) {
                    ReferenceNode referenceNode = (ReferenceNode)((Object)node);
                    int n3 = referenceNode.getReference().getReferenceType();
                    if (n3 != 2 && ModelUtils.hasContent(xmlView, node) && !referenceNode.isCyclicReference()) {
                        diagramComponent = new ReferenceSubtree(this.diagram, referenceNode);
                    }
                } else if (ModelUtils.isContent(element, node) && (hierarchalSchemaComponent = this.diagram.getComponentFactory().createSchemaComponent(node)) != null) {
                    diagramComponent = new Subtree(this.diagram, new TopLevelComponent(this.diagram, hierarchalSchemaComponent));
                }
                if (diagramComponent != null) {
                    diagramComponent.setVisible(this.expanded);
                    arrayList.add(diagramComponent);
                    this.add(diagramComponent);
                }
                ++n2;
            }
            this.subtrees = arrayList.toArray(new Subtree[arrayList.size()]);
        }
        finally {
            xmlView.releaseReadLock();
        }
    }

    private void destroySubtrees() {
        if (this.subtrees == null) {
            return;
        }
        int n = 0;
        while (n < this.subtrees.length) {
            this.remove(this.subtrees[n]);
            this.subtrees[n].destroy();
            ++n;
        }
        this.subtrees = null;
    }

    public DomPosition getDomPosition(Point point) {
        Rectangle rectangle = new Rectangle();
        if (this.root.isVisible()) {
            if ((rectangle = this.root.getBounds(rectangle)).contains(point)) {
                point.translate(-this.root.x, -this.root.y);
                return this.root.getDomPosition(point);
            }
            if (this.parent != null && point.getX() < rectangle.getX() + rectangle.getWidth()) {
                return DomPositionFactory.createDomPosition((Node)this.root.getComponent().getDomElement(), (int)(point.getY() < rectangle.getY() ? 1 : 2));
            }
        }
        if (this.expanded) {
            int n = 0;
            while (n < this.subtrees.length) {
                rectangle = this.subtrees[n].getBounds(rectangle);
                if (point.getY() < rectangle.getY() + rectangle.getHeight() + 2.0 || n == this.subtrees.length - 1) {
                    point.translate(-this.subtrees[n].x, -this.subtrees[n].y);
                    return this.subtrees[n].getDomPosition(point);
                }
                ++n;
            }
        }
        return null;
    }

    public Shape getDomPositionShape(DiagramComponent diagramComponent, int n) {
        Shape shape = null;
        if (n == 1) {
            Rectangle rectangle = diagramComponent.getBounds(null);
            return new Line2D.Double(rectangle.getX(), rectangle.getY() - 2.0, rectangle.getX() + rectangle.getWidth(), rectangle.getY() - 2.0);
        }
        if (n == 2) {
            Rectangle rectangle = diagramComponent.getBounds(null);
            return new Line2D.Double(rectangle.getX(), rectangle.getY() + rectangle.getHeight() + 2.0, rectangle.getX() + rectangle.getWidth(), rectangle.getY() + rectangle.getHeight() + 2.0);
        }
        shape = super.getDomPositionShape(diagramComponent, n);
        return shape;
    }

    private int getIndexOf(Subtree subtree) {
        int n = 0;
        while (n < this.subtrees.length) {
            if (this.subtrees[n] == subtree) break;
            ++n;
        }
        return n == this.subtrees.length ? -1 : n;
    }

    private void expandIfNodesAdded() {
        int n = this.rootChildCount;
        this.rootChildCount = ModelUtils.getContentCount((XmlView)this.diagram.getView(), this.root.getComponent().getDomElement());
        if (n != -1 && this.rootChildCount > n) {
            this.expanded = true;
        }
    }

    private Map saveExpansionState() {
        HashMap hashMap = new HashMap();
        this.saveExpansionState(this, "", hashMap);
        return hashMap;
    }

    private void saveExpansionState(Subtree subtree, String string, Map map) {
        String string2 = string + "%" + this.getHash(subtree.getRoot().getComponent().getDomElement());
        if (subtree.isExpanded()) {
            map.put(string2, EXPANDED);
        } else {
            map.put(string2, new Integer(subtree.rootChildCount));
        }
        if (subtree.subtrees != null) {
            int n = 0;
            while (n < subtree.subtrees.length) {
                this.saveExpansionState(subtree.subtrees[n], string2, map);
                ++n;
            }
        }
    }

    private void restoreExpansionState(Map map) {
        this.restoreExpansionState(this, "", map);
    }

    private void restoreExpansionState(Subtree subtree, String string, Map map) {
        int n;
        String string2 = string + "%" + this.getHash(subtree.getRoot().getComponent().getDomElement());
        Object v = map.get(string2);
        if (v == EXPANDED) {
            subtree.setExpanded(true);
        } else if (v instanceof Integer && (n = ((Integer)v).intValue()) != -1 && subtree.rootChildCount > n) {
            subtree.setExpanded(true);
        }
        if (subtree.subtrees != null) {
            int n2 = 0;
            while (n2 < subtree.subtrees.length) {
                this.restoreExpansionState(subtree.subtrees[n2], string2, map);
                ++n2;
            }
        }
    }

    private String getHash(Element element) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(element.getLocalName());
        String string = element.getAttributeNS(null, "name");
        if (string != null && string.length() > 0) {
            stringBuffer.append("%name=");
            stringBuffer.append(string);
        } else {
            String string2 = element.getAttributeNS(null, "ref");
            if (string2 != null && string2.length() > 0) {
                stringBuffer.append("%ref=");
                stringBuffer.append(string2);
            }
        }
        String string3 = element.getAttributeNS(null, "type");
        if (string3 != null && string3.length() > 0) {
            stringBuffer.append("%type=");
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }
}

