/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import javax.swing.SwingUtilities;
import oracle.javatools.util.SwingUtils;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.DiagramComponent;
import oracle.jdevimpl.xml.schema.diagram.GraphicsUtils;

public class TextComponent
extends DiagramComponent {
    protected String text;
    private int prefWidth;
    private int prefHeight;
    private int textX;
    private int textY;
    private String clippedText;
    protected Font font;

    void $init$() {
        this.prefWidth = -1;
        this.textX = -1;
    }

    public TextComponent(Diagram diagram) {
        super(diagram);
        this.$init$();
        this.font = GraphicsUtils.getDiagramFont();
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Font getFont() {
        return this.font;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
        this.invalidate();
        this.repaint();
    }

    public void invalidate() {
        super.invalidate();
        this.prefWidth = -1;
        this.textX = -1;
    }

    public int getPreferredWidth() {
        if (this.prefWidth == -1) {
            this.cachePreferredSize();
        }
        return this.prefWidth;
    }

    public int getPreferredHeight() {
        if (this.prefWidth == -1) {
            this.cachePreferredSize();
        }
        return this.prefHeight;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.text != null) {
            if (this.textX == -1) {
                this.cachePaintOffsets(graphics);
            }
            Font font = graphics.getFont();
            Color color = graphics.getColor();
            graphics.setFont(this.font);
            graphics.setColor(this.getForeground());
            SwingUtils.drawString((Graphics)graphics, (String)this.clippedText, (int)this.textX, (int)this.textY);
            graphics.setColor(color);
            graphics.setFont(font);
        }
    }

    private void cachePreferredSize() {
        if (this.text == null || this.text.length() == 0) {
            this.prefWidth = 0;
            this.prefHeight = 0;
        } else {
            boolean bl = SwingUtils.useTextAntialiasing();
            FontRenderContext fontRenderContext = new FontRenderContext(null, bl, false);
            TextLayout textLayout = new TextLayout(this.text, this.font, fontRenderContext);
            this.prefWidth = this.insets.left + (int)((double)textLayout.getAdvance() + 0.5) + this.insets.right;
            int n = (int)((double)(textLayout.getAscent() + textLayout.getDescent()) + 0.5);
            this.prefHeight = this.insets.top + n + this.insets.bottom + 1;
        }
    }

    private void cachePaintOffsets(Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics(this.font);
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        Rectangle rectangle2 = new Rectangle(this.insets.left, this.insets.top, this.getWidth() - this.insets.left - this.insets.right, this.getHeight() - this.insets.top - this.insets.bottom);
        this.clippedText = SwingUtilities.layoutCompoundLabel(fontMetrics, this.text, null, 0, 2, 1, 2, rectangle2, new Rectangle(0, 0, 0, 0), rectangle, 0);
        this.textX = rectangle.x;
        this.textY = rectangle.y + fontMetrics.getAscent();
    }
}

