/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Shape;
import oracle.jdevimpl.xml.schema.diagram.AttrRow;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.GraphicsUtils;
import oracle.jdevimpl.xml.schema.diagram.Grid;
import oracle.jdevimpl.xml.schema.diagram.HierarchalSchemaComponent;
import oracle.jdevimpl.xml.schema.diagram.TextComponent;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public abstract class TitledGridComponent
extends HierarchalSchemaComponent {
    private TextComponent text;
    private Grid grid;

    public TitledGridComponent(Diagram diagram, Element element, String string) {
        super(diagram, element);
        this.text = new TextComponent(diagram);
        this.text.setText(string);
        this.text.setInsets(new Insets(3, 10, 3, 10));
        this.text.setFont(GraphicsUtils.getDiagramFont().deriveFont(1));
        this.add(this.text);
        this.grid = new Grid(diagram);
        this.add(this.grid);
        this.update();
    }

    public Shape getShape() {
        int[] nArray = new int[]{0, this.width - 6, this.width - 1, this.width - 1, 0, 0};
        int[] nArray2 = new int[]{0, 0, 5, this.height - 1, this.height - 1, 0};
        return new Polygon(nArray, nArray2, nArray.length);
    }

    public int getPreferredWidth() {
        int n = this.text.getPreferredWidth() + 5;
        if (this.grid.getRowCount() > 0) {
            n = Math.max(n, this.grid.getPreferredWidth());
        }
        return n += this.insets.left + this.insets.right;
    }

    public int getPreferredHeight() {
        int n = this.text.getPreferredHeight() + this.insets.top + this.insets.bottom;
        if (this.grid.getRowCount() > 0) {
            n += this.grid.getPreferredHeight() + 1;
        }
        return n;
    }

    public void layout() {
        int n = this.text.getPreferredHeight();
        this.text.setBounds(this.insets.left, this.insets.top, this.width - this.insets.left - this.insets.right - 5, n);
        this.grid.setBounds(this.insets.left, this.insets.top + n + 1, this.width - this.insets.left - this.insets.right, this.grid.getPreferredHeight());
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.grid.getRowCount() > 0) {
            int n = this.insets.top + this.text.getHeight();
            graphics.drawLine(0, n, this.width - 1, n);
        }
        graphics.drawLine(this.width - 6, 0, this.width - 6, 6);
        graphics.drawLine(this.width - 6, 6, this.width - 1, 6);
    }

    public void update() {
        super.update();
        if (this.text != null) {
            this.grid.removeAllRows();
            String[] stringArray = this.getDisplayAttributes();
            if (stringArray != null) {
                int n = 0;
                while (n < stringArray.length) {
                    Attr attr = this.element.getAttributeNodeNS(null, stringArray[n]);
                    if (attr != null) {
                        this.grid.addRow(new AttrRow(this.diagram, attr, true));
                    }
                    ++n;
                }
            }
        }
    }

    protected Attr getTitleAttr() {
        return null;
    }

    protected String[] getDisplayAttributes() {
        return null;
    }
}

