/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.jdevimpl.xml.schema.NodeListener;
import oracle.jdevimpl.xml.schema.diagram.CardinalityComponent;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.DiagramComponent;
import oracle.jdevimpl.xml.schema.diagram.Expandable;
import oracle.jdevimpl.xml.schema.diagram.Expander;
import oracle.jdevimpl.xml.schema.diagram.GraphicsUtils;
import oracle.jdevimpl.xml.schema.diagram.Hierarchal;
import oracle.jdevimpl.xml.schema.diagram.HierarchalSchemaComponent;
import oracle.jdevimpl.xml.schema.diagram.IconicModelGroup;
import oracle.jdevimpl.xml.schema.diagram.ModelUtils;
import oracle.jdevimpl.xml.schema.diagram.SchemaRootComponent;
import oracle.jdevimpl.xml.schema.diagram.Subtree;
import org.w3c.dom.Node;

public class TopLevelComponent
extends DiagramComponent
implements NodeListener,
Expandable,
Hierarchal {
    private HierarchalSchemaComponent schemaComponent;
    private Expander expander;
    private CardinalityComponent cardinality;
    private int minOccurs;
    private int maxOccurs;

    public TopLevelComponent(Diagram diagram, HierarchalSchemaComponent hierarchalSchemaComponent) {
        super(diagram);
        this.expander = new Expander(diagram, this);
        this.add(this.expander);
        this.cardinality = new CardinalityComponent(diagram);
        this.cardinality.setInsets(new Insets(0, 0, 0, 3));
        this.add(this.cardinality);
        this.schemaComponent = hierarchalSchemaComponent;
        this.add(hierarchalSchemaComponent);
        diagram.getView().addNodeListener(hierarchalSchemaComponent.getDomElement(), this);
        this.update();
    }

    public void destroy() {
        super.destroy();
        this.diagram.getView().removeNodeListener(this.schemaComponent.getDomElement(), this);
    }

    public void nodeChanged(Node node) {
        this.update();
    }

    public void referenceChanged(Node node) {
        this.update();
    }

    public void update() {
        boolean bl = this.isExpandable();
        if (bl != this.expander.isVisible()) {
            this.expander.setVisible(bl);
            this.invalidate();
        }
        String string = ModelUtils.getAttribute(this.schemaComponent.getDomElement(), "minOccurs");
        int n = this.minOccurs;
        try {
            this.minOccurs = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.minOccurs = 1;
        }
        this.cardinality.setMinimum(this.minOccurs);
        if (this.minOccurs == 0) {
            this.schemaComponent.setStroke(GraphicsUtils.getOptionalStroke());
        } else {
            this.schemaComponent.setStroke(null);
        }
        if (this.minOccurs != n) {
            this.invalidate();
            if (this.parent != null) {
                if (this.parent.getParent() != null) {
                    this.parent.getParent().repaint();
                } else {
                    this.parent.repaint();
                }
            } else {
                this.repaint();
            }
        }
        String string2 = ModelUtils.getAttribute(this.schemaComponent.getDomElement(), "maxOccurs");
        int n2 = this.maxOccurs;
        if ("unbounded".equals(string2)) {
            this.maxOccurs = -1;
        } else {
            try {
                this.maxOccurs = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.maxOccurs = 1;
            }
        }
        this.cardinality.setMaximum(this.maxOccurs);
        if (this.maxOccurs != n2) {
            this.invalidate();
        }
    }

    public Stroke getStroke() {
        return this.schemaComponent.getStroke();
    }

    public Subtree getTree() {
        return (Subtree)this.getParent();
    }

    public HierarchalSchemaComponent getComponent() {
        return this.schemaComponent;
    }

    public int getPreferredWidth() {
        int n = this.schemaComponent.getPreferredWidth() + this.cardinality.getPreferredWidth();
        n = this.expander.isVisible() ? (n += this.expander.getPreferredWidth()) : (n += 5);
        if (this.maxOccurs > 1 || this.maxOccurs == -1) {
            n += 3;
        }
        return n;
    }

    public int getPreferredHeight() {
        int n = this.schemaComponent.getPreferredHeight() + 5;
        if (this.expander.isVisible()) {
            n = Math.max(n, this.expander.getPreferredHeight());
        }
        if (this.maxOccurs > 1 || this.maxOccurs == -1) {
            n += 3;
        }
        int n2 = this.schemaComponent.getParentConnectionYOffset();
        n = Math.max(n, n2 + this.cardinality.getPreferredHeight());
        return n;
    }

    public void layout() {
        this.schemaComponent.setBounds(this.cardinality.getPreferredWidth(), 0, this.schemaComponent.getPreferredWidth(), this.schemaComponent.getPreferredHeight());
        this.expander.setBounds(this.cardinality.getPreferredWidth() + this.schemaComponent.getWidth() - this.expander.getPreferredWidth() / 2, (this.schemaComponent.getHeight() - this.expander.getPreferredHeight()) / 2, this.expander.getPreferredWidth(), this.expander.getPreferredHeight());
        this.cardinality.setBounds(0, this.schemaComponent.getParentConnectionYOffset(), this.cardinality.getPreferredWidth(), this.cardinality.getPreferredHeight());
    }

    public void paintComponent(Graphics graphics) {
        Shape shape = this.schemaComponent.getShape();
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(this.schemaComponent.getX(), this.schemaComponent.getY());
        if (this.maxOccurs > 1 || this.maxOccurs == -1) {
            graphics2D.translate(3, 3);
            GraphicsUtils.drawDropShadow(graphics, shape);
            this.schemaComponent.paint(graphics);
            graphics2D.translate(-3, -3);
        } else {
            GraphicsUtils.drawDropShadow(graphics, shape);
        }
        graphics2D.translate(-this.schemaComponent.getX(), -this.schemaComponent.getY());
    }

    public int getParentConnectionXOffset() {
        return this.schemaComponent.getX() + this.schemaComponent.getParentConnectionXOffset();
    }

    public int getParentConnectionYOffset() {
        return this.schemaComponent.getY() + this.schemaComponent.getParentConnectionYOffset();
    }

    public int getChildConnectionXOffset() {
        if (this.expander.isVisible()) {
            return this.cardinality.getPreferredWidth() + this.schemaComponent.getPreferredWidth() + this.expander.getPreferredWidth() / 2;
        }
        int n = this.schemaComponent.getX() + this.schemaComponent.getChildConnectionXOffset();
        if (this.maxOccurs > 1 || this.maxOccurs == -1) {
            n += 3;
        }
        return n;
    }

    public int getChildConnectionYOffset() {
        if (this.expander.isVisible()) {
            return this.schemaComponent.getPreferredHeight() / 2;
        }
        return this.schemaComponent.getY() + this.schemaComponent.getChildConnectionYOffset();
    }

    public boolean isExpanded() {
        return this.getTree().isExpanded();
    }

    public void setExpanded(boolean bl) {
        this.getTree().setExpanded(bl);
    }

    private boolean isExpandable() {
        if (this.schemaComponent instanceof SchemaRootComponent || this.schemaComponent instanceof IconicModelGroup) {
            return false;
        }
        return ModelUtils.hasContent(this.diagram.getGui().getView(), this.schemaComponent.getDomElement());
    }

    public Shape getDomPositionShape(DiagramComponent diagramComponent, int n) {
        return this.getTree().getDomPositionShape(diagramComponent, n);
    }

    public DomPosition getDomPosition(Point point) {
        DomPosition domPosition = super.getDomPosition(point);
        if (domPosition == null) {
            domPosition = this.diagram.getRootComponent() == this.schemaComponent ? DomPositionFactory.createDomPosition((Node)this.schemaComponent.getDomElement(), (int)0) : DomPositionFactory.createDomPosition((Node)this.schemaComponent.getDomElement(), (int)2);
        }
        return domPosition;
    }
}

