/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.util.ArrayList;
import java.util.List;
import oracle.jdevimpl.xml.schema.ProxyAttr;
import oracle.jdevimpl.xml.schema.ReferenceNode;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.GraphicsUtils;
import oracle.jdevimpl.xml.schema.diagram.ListComponent;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class TypeEditor
extends ListComponent {
    private ArrayList listeners;
    private Element parent;
    private Attr attr;
    private int type;

    public TypeEditor(Diagram diagram, int n) {
        this(diagram, null, n);
    }

    public TypeEditor(Diagram diagram, Attr attr, int n) {
        super(diagram);
        this.type = n;
        this.setAttr(attr);
    }

    public int getPreferredWidth() {
        if (this.attr != null) {
            return super.getPreferredWidth();
        }
        return 0;
    }

    public int getPreferredHeight() {
        if (this.attr != null) {
            return super.getPreferredHeight();
        }
        return 0;
    }

    public void setReference(ReferenceNode referenceNode) {
        this.setForeground(null);
        if (referenceNode != null) {
            if (referenceNode.getReferee() == null && !referenceNode.getReference().isBuiltInType()) {
                this.setForeground(GraphicsUtils.UNRESOLVED_REFERENCE_COLOR);
            }
            this.setAttr(referenceNode.getReference().getAttr());
        } else {
            this.setAttr(null);
        }
    }

    public void setAttr(Attr attr) {
        this.attr = attr;
        if (attr != null) {
            this.setText(attr.getValue());
        } else {
            this.setText(null);
        }
    }

    public Attr getAttr() {
        return this.attr;
    }

    protected void startEditing() {
        List list = this.diagram.getView().getGlobals(this.attr, this.type);
        this.setItems(list.toArray(new String[0]));
        if (!(this.attr instanceof ProxyAttr) || !((ProxyAttr)this.attr).isExternal()) {
            super.startEditing();
        }
    }

    protected void cancelEditing() {
        super.cancelEditing();
        if (this.attr != null) {
            String string = this.attr.getValue();
            if (string.trim().length() == 0) {
                this.setAttr(null);
            } else {
                this.setText(string);
                this.invalidate();
                this.diagram.revalidate();
                this.fireTextChanged();
            }
        }
    }
}

