/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.HierarchalSchemaComponent;
import oracle.jdevimpl.xml.schema.diagram.Subtree;
import oracle.jdevimpl.xml.schema.diagram.TopLevelComponent;

public class VerticalTree
extends Subtree {
    private static final int INDENT = 15;

    public VerticalTree(Diagram diagram, HierarchalSchemaComponent hierarchalSchemaComponent) {
        super(diagram, new TopLevelComponent(diagram, hierarchalSchemaComponent));
    }

    public void layout() {
        if (this.layoutWidth == -1) {
            this.computeSizes();
        }
        this.root.setBounds(this.insets.top, this.insets.left, this.root.getPreferredWidth(), this.root.getPreferredHeight());
        if (this.expanded && this.subtrees.length > 0) {
            int n = this.insets.left + this.root.getChildConnectionXOffset() + 15;
            int n2 = this.insets.top + this.root.getHeight() + 5;
            int n3 = 0;
            while (n3 < this.subtrees.length) {
                this.subtrees[n3].setBounds(n, n2, this.subtrees[n3].getPreferredWidth(), this.subtrees[n3].getPreferredHeight());
                n2 += this.subtrees[n3].getHeight() + 5;
                ++n3;
            }
        }
    }

    protected void computeSizes() {
        this.layoutWidth = this.insets.left + this.root.getPreferredWidth() + this.insets.right;
        this.layoutHeight = this.insets.top + this.root.getPreferredHeight() + this.insets.bottom;
        if (this.expanded && this.subtrees.length > 0) {
            int n = 0;
            int n2 = 0;
            while (n2 < this.subtrees.length) {
                this.layoutHeight += this.subtrees[n2].getPreferredHeight();
                n = Math.max(n, this.subtrees[n2].getPreferredWidth());
                ++n2;
            }
            this.layoutHeight += 5 * this.subtrees.length;
            this.layoutWidth = Math.max(this.layoutWidth, this.root.getX() + this.root.getChildConnectionXOffset() + 15 + n + this.insets.right);
        }
    }

    protected void paintEdges(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = this.root.getX() + this.root.getChildConnectionXOffset();
        int n2 = this.root.getY() + this.root.getChildConnectionYOffset();
        int n3 = 0;
        while (n3 < this.subtrees.length) {
            Subtree subtree = this.subtrees[n3];
            Stroke stroke = subtree.getRoot().getStroke();
            Stroke stroke2 = null;
            if (stroke != null) {
                stroke2 = graphics2D.getStroke();
                graphics2D.setStroke(stroke);
            }
            int n4 = n;
            int n5 = n2;
            int n6 = n4;
            int n7 = subtree.getY() + subtree.getConnectionYOffset();
            graphics.drawLine(n4, n5, n6, n7);
            n5 = n7;
            n6 = subtree.getX() + subtree.getConnectionXOffset();
            graphics.drawLine(n4, n5, n6, n7);
            if (stroke2 != null) {
                graphics2D.setStroke(stroke2);
            }
            ++n3;
        }
    }
}

