/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.wizard;

import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bali.xml.dom.XmlDeclarationInfo;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlModel;
import oracle.ide.Context;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.util.IdeUtil;
import oracle.jdeveloper.builder.file.FileBuilderModel;
import oracle.jdevimpl.xml.schema.resource.XmlSchemaArb;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class XmlSchemaWizardModel
extends FileBuilderModel {
    private static final String EXTENSION = ".xsd";
    private static final String TARGET_NAMESPACE = "http://www.example.org";
    private static final String SCHEMA_PREFIX = "xsd";
    private Project project;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        $assertionsDisabled = XmlSchemaWizardModel.class.desiredAssertionStatus() ^ true;
    }

    public XmlSchemaWizardModel(Context context) {
        super(context, EXTENSION);
        this.project = context.getProject();
    }

    public String getFileType() {
        return XmlSchemaArb.getString(58);
    }

    public String getBuilderType() {
        return "XML Schema";
    }

    protected String getBaseName() {
        return "untitled";
    }

    protected boolean buildFile(Node node) {
        if (super.buildFile(node)) {
            this.writeSchema(node);
            return true;
        }
        return false;
    }

    private void writeSchema(Node node) {
        if (!$assertionsDisabled && !(node instanceof XMLSourceNode)) {
            throw new AssertionError();
        }
        XmlModel xmlModel = ((XMLSourceNode)node).getModel(this.project);
        xmlModel.getDomModel().setXmlDeclarationInfo(new XmlDeclarationInfo(XmlDeclarationInfo.VERSION_1_0, IdeUtil.getIdeIanaEncoding(), null));
        try {
            xmlModel.startTransaction("New XML Schema");
            Document document = xmlModel.getDocument();
            Element element = document.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:schema");
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", TARGET_NAMESPACE);
            element.setAttributeNS(null, "targetNamespace", TARGET_NAMESPACE);
            element.setAttributeNS(null, "elementFormDefault", "qualified");
            Element element2 = document.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:element");
            element2.setAttributeNS(null, "name", XmlSchemaArb.getString(60));
            Element element3 = document.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:annotation");
            Element element4 = document.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:documentation");
            Text text = document.createTextNode(XmlSchemaArb.getString(61));
            element4.appendChild(text);
            element3.appendChild(element4);
            element2.appendChild(element3);
            element.appendChild(element2);
            document.appendChild(element);
        }
        finally {
            try {
                xmlModel.commitTransaction();
            }
            catch (XmlCommitException xmlCommitException) {
                xmlModel.rollbackTransaction();
            }
            CommandProcessor.getInstance().flush((Object)node);
        }
    }
}

