/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.xquery.editor.language;

import oracle.bali.xml.editor.renderer.XMLStyles;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.language.BlockRenderer;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.jdevimpl.xml.xquery.XQueryNode;
import oracle.jdevimpl.xml.xquery.editor.language.XQueryBlockRenderer;
import oracle.jdevimpl.xml.xquery.editor.language.XQueryLanguageSupport;
import oracle.jdevimpl.xml.xquery.editor.language.XQueryStyles;
import oracle.jdevimpl.xml.xquery.resource.XQueryArb;

public class XQueryLanguageModule
extends LanguageModule {
    public LanguageSupport createLanguageSupport() {
        return new XQueryLanguageSupport();
    }

    public BlockRenderer createBlockRenderer(TextBuffer textBuffer) {
        return new XQueryBlockRenderer(textBuffer);
    }

    public String getContentSample() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(: List all titles containing chapters or sections on XML :)\n");
        stringBuffer.append("<results>\n");
        stringBuffer.append("  {\n");
        stringBuffer.append("    for $t in doc(\"books.xml\")//(chapter | section)/title\n");
        stringBuffer.append("    where contains($t/text(), \"XML\")\n");
        stringBuffer.append("    return $t\n");
        stringBuffer.append("  }\n");
        stringBuffer.append("</results>\n");
        return stringBuffer.toString();
    }

    public String getPresentationName() {
        return XQueryArb.getString(1);
    }

    public String[] getStyleNames() {
        return XQueryStyles.STYLE_NAMES;
    }

    public String[] getSupportedFileTypes() {
        return XQueryNode.EXTENSIONS;
    }

    public void registerStyles(StyleRegistry styleRegistry) {
        new XMLStyles(styleRegistry);
        new XQueryStyles(styleRegistry);
    }
}

