/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.xquery.lexer;

import oracle.bali.xml.dom.buffer.lexer.XMLLexer;
import oracle.bali.xml.dom.buffer.lexer.XMLTokens;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.parser.AbstractLexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.util.KeywordTable;
import oracle.jdevimpl.xml.xquery.lexer.XQueryTokens;

public class XQueryLexer
extends AbstractLexer
implements XMLTokens,
XQueryTokens {
    private int lastToken;
    private int startOffset;
    private int endOffset;
    private boolean useLastToken;
    private XMLLexer xmlLexer;
    private static boolean[] NCNAME_CHARS;
    private static KeywordTable keywordTable;

    void $init$() {
        this.xmlLexer = new XMLLexer();
    }

    static {
        XQueryLexer.initialize();
    }

    public XQueryLexer() {
        this.$init$();
        this.lastToken = -1;
        this.startOffset = -1;
        this.endOffset = -1;
    }

    public void setTextBuffer(ReadTextBuffer readTextBuffer) {
        super.setTextBuffer(readTextBuffer);
        this.xmlLexer.setTextBuffer(readTextBuffer);
    }

    public void setPosition(int n) {
        super.setPosition(n);
        this.useLastToken = false;
    }

    public void backup() {
        this.useLastToken = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int lex(LexerToken lexerToken) {
        block42: {
            if (this.useLastToken) {
                this.useLastToken = false;
                return this.fillLexerToken(lexerToken);
            }
            this.lastToken = 0;
            try {
                block28: while (true) {
                    char c = this.textBuffer.getChar(this.currentPos++);
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            continue block28;
                        }
                    }
                    this.startOffset = this.currentPos - 1;
                    switch (c) {
                        case '(': {
                            if (this.textBuffer.getChar(this.currentPos) == ':') {
                                ++this.currentPos;
                                this.lastToken = 40;
                                this.skipComment();
                                break block28;
                            }
                            this.lastToken = 57;
                            break block28;
                        }
                        case '$': {
                            if (!XQueryLexer.isNCNameStart(this.textBuffer.getChar(this.currentPos))) break block28;
                            this.lastToken = 41;
                            this.skipQName();
                            break block28;
                        }
                        case '\"': {
                            this.lastToken = 30;
                            this.skipStringLiteralQuote();
                            break block28;
                        }
                        case '\'': {
                            this.lastToken = 30;
                            this.skipStringLiteralApostrophe();
                            break block28;
                        }
                        case ':': {
                            if (this.textBuffer.getChar(this.currentPos) != '=') break block28;
                            ++this.currentPos;
                            this.lastToken = 45;
                            break block28;
                        }
                        case ',': {
                            this.lastToken = 46;
                            break block28;
                        }
                        case '=': {
                            this.lastToken = 48;
                            break block28;
                        }
                        case '>': {
                            if (this.textBuffer.getChar(this.currentPos) == '>') {
                                ++this.currentPos;
                                this.lastToken = 49;
                                break block28;
                            }
                            this.lastToken = 52;
                            break block28;
                        }
                        case '@': {
                            this.lastToken = 50;
                            break block28;
                        }
                        case '{': {
                            this.lastToken = 53;
                            break block28;
                        }
                        case '[': {
                            this.lastToken = 54;
                            break block28;
                        }
                        case '-': {
                            this.lastToken = 58;
                            break block28;
                        }
                        case '+': {
                            this.lastToken = 61;
                            break block28;
                        }
                        case '}': {
                            this.lastToken = 63;
                            break block28;
                        }
                        case ']': {
                            this.lastToken = 64;
                            break block28;
                        }
                        case ')': {
                            this.lastToken = 66;
                            break block28;
                        }
                        case '|': {
                            this.lastToken = 68;
                            break block28;
                        }
                        case ';': {
                            this.lastToken = 67;
                            break block28;
                        }
                        case '.': {
                            c = this.textBuffer.getChar(this.currentPos);
                            if (c == '.') {
                                ++this.currentPos;
                                this.lastToken = 65;
                                break block28;
                            }
                            if (XQueryLexer.isDigit(c)) {
                                this.handleNumericLiteral();
                                break block28;
                            }
                            this.lastToken = 42;
                            break block28;
                        }
                        case '/': {
                            c = this.textBuffer.getChar(this.currentPos);
                            if (c == '/') {
                                ++this.currentPos;
                                this.lastToken = 47;
                                break block28;
                            }
                            this.lastToken = 60;
                            break block28;
                        }
                        case '<': {
                            c = this.textBuffer.getChar(this.currentPos);
                            if (c == '=') {
                                this.lastToken = 55;
                                ++this.currentPos;
                                break block28;
                            }
                            if (c == '<') {
                                this.lastToken = 49;
                                break block28;
                            }
                            if (Character.isWhitespace(c)) {
                                this.lastToken = 56;
                                break block28;
                            }
                            this.lastToken = 28;
                            this.skipXml();
                            break block28;
                        }
                        default: {
                            int n;
                            if (XQueryLexer.isDigit(c)) {
                                this.handleNumericLiteral();
                                break block28;
                            }
                            if (!XQueryLexer.isNCNameStart(c)) {
                                this.lastToken = 0;
                                continue block28;
                            }
                            this.lastToken = 43;
                            int n2 = KeywordTable.computeInsensitivePartialHash((char)c, (int)0);
                            while (true) {
                                if (!XQueryLexer.isQNamePart(c = this.textBuffer.getChar(this.currentPos))) {
                                    n = keywordTable.lookupKeyword(this.textBuffer, this.startOffset, this.currentPos, n2);
                                    if (n == -1) break block28;
                                    break;
                                }
                                n2 = KeywordTable.computeInsensitivePartialHash((char)c, (int)n2);
                                ++this.currentPos;
                            }
                            this.lastToken = n;
                            break block28;
                        }
                    }
                    break;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.currentPos = this.textBuffer.getLength();
                if (this.lastToken != 0) break block42;
                this.startOffset = this.currentPos;
            }
        }
        this.endOffset = this.currentPos;
        this.useLastToken = false;
        return this.fillLexerToken(lexerToken);
    }

    private int fillLexerToken(LexerToken lexerToken) {
        AbstractLexer.DefaultLexerToken defaultLexerToken = (AbstractLexer.DefaultLexerToken)lexerToken;
        defaultLexerToken.setToken(this.lastToken);
        defaultLexerToken.setStartOffset(this.startOffset);
        defaultLexerToken.setEndOffset(this.endOffset);
        return this.lastToken;
    }

    private void skipComment() {
        char c;
        while ((c = this.textBuffer.getChar(this.currentPos++)) != ':' || this.textBuffer.getChar(this.currentPos) != ')') {
        }
        ++this.currentPos;
    }

    private void skipQName() {
        this.skipNCName();
        if (this.textBuffer.getChar(this.currentPos) == ':') {
            this.skipNCName();
        }
    }

    private void skipNCName() {
        char c;
        while ((c = this.textBuffer.getChar(this.currentPos)) < '\u0100' && NCNAME_CHARS[c]) {
            ++this.currentPos;
        }
        if (c > '\u0100') {
            while (XQueryLexer.isNCNamePart(c = this.textBuffer.getChar(this.currentPos))) {
                ++this.currentPos;
            }
        }
    }

    private void skipStringLiteralQuote() {
        while (true) {
            char c = this.textBuffer.getChar(this.currentPos++);
            switch (c) {
                case '\"': {
                    if (this.textBuffer.getChar(this.currentPos) == '\"') {
                        ++this.currentPos;
                        break;
                    }
                    return;
                }
            }
        }
    }

    private void skipStringLiteralApostrophe() {
        while (true) {
            char c = this.textBuffer.getChar(this.currentPos++);
            switch (c) {
                case '\'': {
                    if (this.textBuffer.getChar(this.currentPos) == '\'') {
                        ++this.currentPos;
                        break;
                    }
                    return;
                }
            }
        }
    }

    private void handleNumericLiteral() {
        this.lastToken = 31;
        block4: while (true) {
            this.skipDigits();
            char c = this.textBuffer.getChar(this.currentPos);
            switch (c) {
                case '.': {
                    this.lastToken = 32;
                    ++this.currentPos;
                    break;
                }
                case 'E': 
                case 'e': {
                    this.lastToken = 33;
                    ++this.currentPos;
                    c = this.textBuffer.getChar(this.currentPos);
                    if (c != '+' && c != '-') continue block4;
                    ++this.currentPos;
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }

    private void skipDigits() {
        char c;
        while (XQueryLexer.isDigit(c = this.textBuffer.getChar(this.currentPos))) {
            ++this.currentPos;
        }
        return;
    }

    private void skipXml() {
        char c = this.textBuffer.getChar(this.currentPos);
        if (c == '!') {
            if (this.textBuffer.getChar(this.currentPos + 1) == '-' && this.textBuffer.getChar(this.currentPos + 2) == '-') {
                this.currentPos += 3;
                this.skipXmlComment();
            } else if (this.textBuffer.getChar(this.currentPos + 1) == '[' && this.textBuffer.getChar(this.currentPos + 2) == 'C' && this.textBuffer.getChar(this.currentPos + 3) == 'D' && this.textBuffer.getChar(this.currentPos + 4) == 'A' && this.textBuffer.getChar(this.currentPos + 5) == 'T' && this.textBuffer.getChar(this.currentPos + 6) == 'A' && this.textBuffer.getChar(this.currentPos + 7) == '[') {
                this.currentPos += 8;
                this.skipCDATASection();
            }
        } else if (c == '?') {
            ++this.currentPos;
            this.skipProcessingInstruction();
        } else {
            this.skipXmlElement();
        }
    }

    private void skipXmlComment() {
        char c;
        while ((c = this.textBuffer.getChar(this.currentPos++)) != '-' || this.textBuffer.getChar(this.currentPos) != '-' || this.textBuffer.getChar(this.currentPos + 1) != '>') {
        }
        this.currentPos += 2;
    }

    private void skipCDATASection() {
        char c;
        while ((c = this.textBuffer.getChar(this.currentPos++)) != ']' || this.textBuffer.getChar(this.currentPos) != ']' || this.textBuffer.getChar(this.currentPos + 1) != '>') {
        }
        this.currentPos += 2;
    }

    private void skipProcessingInstruction() {
        char c;
        while ((c = this.textBuffer.getChar(this.currentPos++)) != '?' || this.textBuffer.getChar(this.currentPos) != '>') {
        }
        ++this.currentPos;
    }

    private void skipXmlElement() {
        String string = this.skipXmlElementName();
        this.skipToXmlEndTag(string);
    }

    private String skipXmlElementName() {
        char c = '\u0000';
        StringBuffer stringBuffer = new StringBuffer();
        block5: while (true) {
            char c2 = this.textBuffer.getChar(this.currentPos++);
            switch (c2) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': 
                case '/': 
                case '=': 
                case '>': 
                case '?': {
                    if (c != '\u0000') continue block5;
                    --this.currentPos;
                    return stringBuffer.toString();
                }
                case '<': {
                    --this.currentPos;
                    return stringBuffer.toString();
                }
                case '\"': 
                case '\'': {
                    if (c == '\u0000') {
                        c = c2;
                        break;
                    }
                    if (c != c2) continue block5;
                    c = '\u0000';
                    break;
                }
                default: {
                    stringBuffer.append(c2);
                }
            }
        }
    }

    private void skipToXmlEndTag(String string) {
        boolean bl = true;
        char c = '\u0000';
        boolean bl2 = false;
        block6: while (true) {
            char c2 = this.textBuffer.getChar(this.currentPos++);
            switch (c2) {
                case '/': {
                    if (c != '\u0000' || !bl || (c2 = this.textBuffer.getChar(this.currentPos)) != '>') continue block6;
                    ++this.currentPos;
                    return;
                }
                case '>': {
                    if (c != '\u0000') continue block6;
                    if (bl) {
                        bl = false;
                    }
                    if (!bl2) continue block6;
                    return;
                }
                case '<': {
                    if (c != '\u0000' || (c2 = this.textBuffer.getChar(this.currentPos)) != '/') continue block6;
                    ++this.currentPos;
                    String string2 = this.skipXmlElementName();
                    if (!string2.equals(string)) continue block6;
                    bl2 = true;
                    break;
                }
                case '\"': 
                case '\'': {
                    if (c == '\u0000') {
                        c = c2;
                        break;
                    }
                    if (c != c2) continue block6;
                    c = '\u0000';
                    break;
                }
            }
        }
    }

    private static void initialize() {
        NCNAME_CHARS = new boolean[256];
        int n = 0;
        while (n < 256) {
            XQueryLexer.NCNAME_CHARS[n] = XQueryLexer.isNCNamePart((char)n);
            ++n;
        }
        keywordTable = new KeywordTable(83);
        keywordTable.addKeyword("ancestor-or-self", 70);
        keywordTable.addKeyword("ancestor", 71);
        keywordTable.addKeyword("and", 72);
        keywordTable.addKeyword("as", 73);
        keywordTable.addKeyword("ascending", 74);
        keywordTable.addKeyword("at", 75);
        keywordTable.addKeyword("attribute", 76);
        keywordTable.addKeyword("base-uri", 77);
        keywordTable.addKeyword("by", 78);
        keywordTable.addKeyword("case", 79);
        keywordTable.addKeyword("cast", 80);
        keywordTable.addKeyword("castable", 81);
        keywordTable.addKeyword("child", 82);
        keywordTable.addKeyword("collation", 83);
        keywordTable.addKeyword("comment", 84);
        keywordTable.addKeyword("declare", 85);
        keywordTable.addKeyword("default", 86);
        keywordTable.addKeyword("descendant-or-self", 87);
        keywordTable.addKeyword("descendant", 88);
        keywordTable.addKeyword("descending", 89);
        keywordTable.addKeyword("div", 90);
        keywordTable.addKeyword("document-node", 91);
        keywordTable.addKeyword("document", 92);
        keywordTable.addKeyword("element", 93);
        keywordTable.addKeyword("else", 94);
        keywordTable.addKeyword("empty", 95);
        keywordTable.addKeyword("encoding", 96);
        keywordTable.addKeyword("eq", 97);
        keywordTable.addKeyword("every", 98);
        keywordTable.addKeyword("except", 99);
        keywordTable.addKeyword("external", 100);
        keywordTable.addKeyword("following-sibling", 101);
        keywordTable.addKeyword("following", 102);
        keywordTable.addKeyword("for", 103);
        keywordTable.addKeyword("function", 104);
        keywordTable.addKeyword("ge", 105);
        keywordTable.addKeyword("greatest", 106);
        keywordTable.addKeyword("gt", 107);
        keywordTable.addKeyword("idiv", 108);
        keywordTable.addKeyword("if", 109);
        keywordTable.addKeyword("import", 110);
        keywordTable.addKeyword("in", 111);
        keywordTable.addKeyword("instance", 112);
        keywordTable.addKeyword("intersect", 113);
        keywordTable.addKeyword("item", 114);
        keywordTable.addKeyword("lax", 115);
        keywordTable.addKeyword("le", 116);
        keywordTable.addKeyword("least", 117);
        keywordTable.addKeyword("let", 118);
        keywordTable.addKeyword("lt", 119);
        keywordTable.addKeyword("mod", 120);
        keywordTable.addKeyword("module", 121);
        keywordTable.addKeyword("namespace", 122);
        keywordTable.addKeyword("ne", 123);
        keywordTable.addKeyword("node", 124);
        keywordTable.addKeyword("of", 125);
        keywordTable.addKeyword("order", 126);
        keywordTable.addKeyword("ordered", 127);
        keywordTable.addKeyword("ordering", 128);
        keywordTable.addKeyword("parent", 129);
        keywordTable.addKeyword("preceding-sibling", 130);
        keywordTable.addKeyword("preceding", 131);
        keywordTable.addKeyword("processing-instruction", 132);
        keywordTable.addKeyword("return", 133);
        keywordTable.addKeyword("satisfies", 134);
        keywordTable.addKeyword("schema-attribute", 135);
        keywordTable.addKeyword("schema-element", 136);
        keywordTable.addKeyword("self", 137);
        keywordTable.addKeyword("some", 138);
        keywordTable.addKeyword("stable", 139);
        keywordTable.addKeyword("strict", 140);
        keywordTable.addKeyword("strip", 141);
        keywordTable.addKeyword("text", 142);
        keywordTable.addKeyword("then", 143);
        keywordTable.addKeyword("to", 144);
        keywordTable.addKeyword("typeswitch", 145);
        keywordTable.addKeyword("union", 146);
        keywordTable.addKeyword("unordered", 147);
        keywordTable.addKeyword("validate", 148);
        keywordTable.addKeyword("version", 149);
        keywordTable.addKeyword("where", 150);
        keywordTable.addKeyword("xmlspace", 151);
        keywordTable.addKeyword("xquery", 152);
    }

    private static boolean isNCNameStart(char c) {
        return Character.isLetter(c) || c == '_';
    }

    private static boolean isNCNamePart(char c) {
        return Character.isLetterOrDigit(c) || c == '.' || c == '-' || c == '_';
    }

    private static boolean isDigit(char c) {
        return '0' <= c && c <= '9';
    }

    private static boolean isQNamePart(char c) {
        return c == ':' || XQueryLexer.isNCNamePart(c);
    }
}

