/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.xquery.lexer;

import oracle.bali.xml.dom.buffer.lexer.XMLLexer;
import oracle.bali.xml.dom.buffer.lexer.XMLTokens;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.parser.AbstractLexer;
import oracle.javatools.parser.LexerToken;
import oracle.jdevimpl.xml.xquery.lexer.XQueryTokens;

public class XQueryXMLLexer
extends AbstractLexer
implements XMLTokens,
XQueryTokens {
    private int lastToken;
    private int startOffset;
    private int endOffset;
    private XMLLexer xmlLexer;
    private boolean useLastToken;

    void $init$() {
        this.xmlLexer = new XMLLexer();
    }

    public XQueryXMLLexer() {
        this.$init$();
        this.lastToken = -1;
        this.startOffset = -1;
        this.endOffset = -1;
    }

    public void setPosition(int n) {
        super.setPosition(n);
        this.useLastToken = false;
    }

    public void backup() {
        this.useLastToken = true;
    }

    public void setTextBuffer(ReadTextBuffer readTextBuffer) {
        super.setTextBuffer(readTextBuffer);
        this.xmlLexer.setTextBuffer(readTextBuffer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int lex(LexerToken lexerToken) {
        int n;
        block17: {
            if (this.useLastToken) {
                this.useLastToken = false;
                return this.fillLexerToken(lexerToken);
            }
            int n2 = -1;
            n = -1;
            this.lastToken = 0;
            try {
                block9: while (true) {
                    char c = this.textBuffer.getChar(this.currentPos++);
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            if (n2 == -1) {
                                n2 = this.currentPos - 1;
                            }
                            n = this.currentPos;
                            continue block9;
                        }
                    }
                    this.startOffset = this.currentPos - 1;
                    switch (c) {
                        case '{': {
                            if (n2 != -1) {
                                this.lastToken = 16;
                                --this.currentPos;
                                this.startOffset = n2;
                                break block9;
                            }
                            c = this.textBuffer.getChar(this.currentPos);
                            if (c == '{') {
                                ++this.currentPos;
                                break block9;
                            }
                            this.lastToken = 29;
                            this.skipXQuery();
                            break block9;
                        }
                        case '<': {
                            if (n2 == -1) {
                                this.xmlLexer.setPosition(this.currentPos - 1);
                                this.lastToken = this.xmlLexer.lex(lexerToken);
                                this.currentPos = lexerToken.getEndOffset() + 1;
                                return this.lastToken;
                            }
                            this.lastToken = 16;
                            --this.currentPos;
                            this.startOffset = n2;
                            break block9;
                        }
                        default: {
                            if (n2 == -1) {
                                n2 = this.currentPos - 1;
                            }
                            n = this.currentPos;
                            break;
                        }
                    }
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.currentPos = this.textBuffer.getLength();
                if (this.lastToken != 0) break block17;
                if (n2 != -1) {
                    this.lastToken = 16;
                    this.startOffset = n2;
                }
                this.startOffset = this.currentPos;
            }
        }
        this.endOffset = n == -1 ? this.currentPos : n;
        this.useLastToken = false;
        return this.fillLexerToken(lexerToken);
    }

    private int fillLexerToken(LexerToken lexerToken) {
        AbstractLexer.DefaultLexerToken defaultLexerToken = (AbstractLexer.DefaultLexerToken)lexerToken;
        defaultLexerToken.setToken(this.lastToken);
        defaultLexerToken.setStartOffset(this.startOffset);
        defaultLexerToken.setEndOffset(this.endOffset);
        return this.lastToken;
    }

    private void skipXQuery() {
        int n = 1;
        while (true) {
            char c;
            if ((c = this.textBuffer.getChar(this.currentPos++)) == '{') {
                c = this.textBuffer.getChar(this.currentPos);
                if (c == '{') {
                    ++this.currentPos;
                } else {
                    ++n;
                }
            }
            if (c != '}') continue;
            c = this.textBuffer.getChar(this.currentPos);
            if (c == '}') {
                ++this.currentPos;
                continue;
            }
            if (--n == 0) break;
        }
    }
}

