/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.xquery.runner;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xqxp.datamodel.XMLItem;
import oracle.xml.xqxp.datamodel.XMLSequence;
import oracle.xquery.Configuration;
import oracle.xquery.PreparedXQuery;
import oracle.xquery.XQException;
import oracle.xquery.XQueryContext;

public class XQueryRunner {
    public static void main(String[] stringArray) {
        try {
            FileReader fileReader = new FileReader(stringArray[0]);
            XQueryContext xQueryContext = new XQueryContext();
            File file = new File(stringArray[0]).getAbsoluteFile().getParentFile();
            Configuration configuration = new Configuration();
            configuration.setBaseURI(file.toURI().toString());
            PreparedXQuery preparedXQuery = xQueryContext.prepareXQuery((Reader)fileReader, configuration);
            XMLSequence xMLSequence = preparedXQuery.executeQuery();
            while (xMLSequence.next()) {
                XMLItem xMLItem = xMLSequence.getCurrentItem();
                String string = XQueryRunner.getOutputString(xMLItem);
                if (string == null) continue;
                System.out.println(string);
            }
        }
        catch (XQException xQException) {
            System.err.println(xQException.getLocalizedMessage());
            System.exit(1);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static String getOutputString(XMLItem xMLItem) {
        XMLNode xMLNode;
        if (xMLItem.instanceOfType(99) && (xMLNode = xMLItem.getNode()) != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                xMLNode.print((OutputStream)byteArrayOutputStream);
                String string = new String(byteArrayOutputStream.toByteArray());
                return string;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return xMLItem.getLexicalValue();
    }
}

