/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.xquery.runner;

import java.awt.Window;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import oracle.ide.Ide;
import oracle.ide.log.LogPage;
import oracle.ide.log.StyledMessage;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFileSystem;
import oracle.ide.runner.RunProcess;
import oracle.ide.util.TextBufferStreamFactory;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.runner.JRunProcess;
import oracle.jdeveloper.runner.JStarter;
import oracle.jdevimpl.xml.xquery.runner.XQueryRunner;
import oracle.xml.xqxp.datamodel.XMLSequence;
import oracle.xquery.Configuration;
import oracle.xquery.PreparedXQuery;
import oracle.xquery.XQException;
import oracle.xquery.XQueryContext;

public class XQueryStarter
extends JStarter {
    private Node target;
    private Thread xqueryThread;
    private LogPage logPage;
    private static final boolean PREVIEW_MODE = Boolean.getBoolean("xquery.preview.mode");

    public XQueryStarter(JRunProcess jRunProcess, Node node) {
        super(jRunProcess, new String[]{XQueryRunner.class.getName(), URLFileSystem.getPlatformPathName((URL)node.getURL())});
        this.target = node;
    }

    public boolean start() {
        if (PREVIEW_MODE) {
            this.logPage = this.runProcess.getLogPage();
            this.xqueryThread = new 1("XQuery");
            this.xqueryThread.start();
            return true;
        }
        return super.start();
    }

    public int waitForProcess() {
        if (PREVIEW_MODE) {
            try {
                this.xqueryThread.join();
            }
            catch (InterruptedException interruptedException) {
                this.terminate();
            }
            Integer n = this.getExitCode();
            return n != null ? n : -1;
        }
        return super.waitForProcess();
    }

    public File getStartDirectory() {
        URL uRL;
        File file = super.getStartDirectory();
        if (file == null && (uRL = URLFileSystem.getParent((URL)this.target.getURL())) != null) {
            file = new File(uRL.getPath());
        }
        return file;
    }

    protected String getClassPath() {
        StringBuffer stringBuffer = new StringBuffer();
        File file = new File(Ide.getOracleHomeDirectory(), "lib");
        File file2 = new File(file, "xquery.jar");
        stringBuffer.append(file2);
        stringBuffer.append(File.pathSeparator);
        File file3 = new File(file, "xmlparserv2.jar");
        stringBuffer.append(file3);
        stringBuffer.append(File.pathSeparator);
        File file4 = new File(Ide.getLibDirectory(), "jdev.jar");
        stringBuffer.append(file4);
        return stringBuffer.toString();
    }

    protected void addJavaOptions(List list) {
        super.addJavaOptions(list);
        list.add("-Xverify:none");
    }

    private void runXQuery() {
        try {
            Reader reader = this.getReader();
            XQueryContext xQueryContext = new XQueryContext();
            Configuration configuration = new Configuration();
            configuration.setBaseURI(URLFileSystem.getParent((URL)this.target.getURL()).toString());
            PreparedXQuery preparedXQuery = xQueryContext.prepareXQuery(reader, configuration);
            XMLSequence xMLSequence = preparedXQuery.executeQuery();
            while (xMLSequence.next()) {
                String string = XQueryRunner.getOutputString(xMLSequence.getCurrentItem());
                if (string == null) continue;
                StyledMessage styledMessage = new StyledMessage((AttributeSet)RunProcess.getSystemOutAttributeSet(), string + "\n");
                this.logPage.log((Object)styledMessage);
            }
        }
        catch (XQException xQException) {
            StyledMessage styledMessage = new StyledMessage((AttributeSet)RunProcess.getSystemErrAttributeSet(), xQException.getLocalizedMessage() + "\n");
            this.logPage.log((Object)styledMessage);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
        }
    }

    private Reader getReader() throws FileNotFoundException {
        InputStreamReader inputStreamReader = null;
        if (this.target instanceof TextNode) {
            TextNode textNode = (TextNode)this.target;
            TextBuffer textBuffer = textNode.acquireTextBuffer();
            try {
                InputStream inputStream = TextBufferStreamFactory.getInputStream((TextBuffer)textBuffer);
                inputStreamReader = new InputStreamReader(inputStream);
            }
            finally {
                textNode.releaseTextBuffer();
            }
        }
        if (inputStreamReader == null) {
            URL uRL = this.target.getURL();
            String string = URLFileSystem.getPlatformPathName((URL)uRL);
            inputStreamReader = new FileReader(string);
        }
        return inputStreamReader;
    }

    static void mav$runXQuery(XQueryStarter xQueryStarter) {
        xQueryStarter.runXQuery();
    }

    static RunProcess ra$runProcess(XQueryStarter xQueryStarter) {
        return xQueryStarter.runProcess;
    }

    public final class oracle.jdevimpl.xml.xquery.runner.XQueryStarter$1
    extends Thread {
        public void run() {
            XQueryStarter.mav$runXQuery(XQueryStarter.this);
            SwingUtilities.invokeLater(new 1());
        }

        public oracle.jdevimpl.xml.xquery.runner.XQueryStarter$1(String string) {
            super(string);
        }

        public final class 1
        implements Runnable {
            public void run() {
                XQueryStarter.ra$runProcess(XQueryStarter.this).finished();
                XQueryStarter.this.finished();
            }
        }
    }
}

