/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.StringTokenizer;

public class IdeClassLoader
extends URLClassLoader {
    private static final String ORACLE = "oracle.";
    private static final String IDECLASSLOADER = IdeClassLoader.class.getName();

    public IdeClassLoader(ClassLoader classLoader) {
        super(IdeClassLoader.getClassPath(), classLoader);
    }

    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(string);
        if (clazz == null) {
            if (string.startsWith(ORACLE) && !string.equals(IDECLASSLOADER)) {
                try {
                    clazz = this.findClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (clazz == null) {
                clazz = super.loadClass(string, false);
            }
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    private static URL[] getClassPath() {
        String string = System.getProperty("jdev.class.path");
        BitSet bitSet = IdeClassLoader.getEncodedChars();
        ArrayList<URL> arrayList = new ArrayList<URL>();
        if (string != null) {
            String string2 = null;
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    arrayList.add(IdeClassLoader.getURLFromPath(string2, bitSet));
                }
            }
            catch (Throwable throwable) {
                System.err.println("Error processing class path entry: " + string2);
                throwable.printStackTrace();
                System.exit(1);
            }
        }
        System.setProperty("java.class.path", string);
        return arrayList.toArray(new URL[arrayList.size()]);
    }

    private static BitSet getEncodedChars() {
        BitSet bitSet = new BitSet(256);
        bitSet.set(61);
        bitSet.set(59);
        bitSet.set(63);
        bitSet.set(47);
        bitSet.set(35);
        bitSet.set(32);
        bitSet.set(60);
        bitSet.set(62);
        bitSet.set(37);
        bitSet.set(34);
        bitSet.set(123);
        bitSet.set(125);
        bitSet.set(124);
        bitSet.set(92);
        bitSet.set(94);
        bitSet.set(91);
        bitSet.set(93);
        bitSet.set(96);
        int n = 0;
        while (n < 32) {
            bitSet.set(n);
            ++n;
        }
        bitSet.set(127);
        return bitSet;
    }

    private static URL getURLFromPath(String string, BitSet bitSet) throws MalformedURLException, IOException {
        File file = new File(string);
        string = IdeClassLoader.encodePath(file.getCanonicalFile().getAbsolutePath(), bitSet);
        String string2 = "/";
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (!string.endsWith("/") && file.isDirectory()) {
            string = string + "/";
        }
        return new URL("file", "", string);
    }

    private static String encodePath(String string, BitSet bitSet) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == File.separatorChar) {
                stringBuffer.append('/');
            } else if (c <= '\u007f') {
                if (bitSet.get(c)) {
                    IdeClassLoader.escape(stringBuffer, c);
                } else {
                    stringBuffer.append(c);
                }
            } else if (c > '\u07ff') {
                IdeClassLoader.escape(stringBuffer, (char)(0xE0 | c >> 12 & 0xF));
                IdeClassLoader.escape(stringBuffer, (char)(0x80 | c >> 6 & 0x3F));
                IdeClassLoader.escape(stringBuffer, (char)(0x80 | c >> 0 & 0x3F));
            } else {
                IdeClassLoader.escape(stringBuffer, (char)(0xC0 | c >> 6 & 0x1F));
                IdeClassLoader.escape(stringBuffer, (char)(0x80 | c >> 0 & 0x3F));
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private static void escape(StringBuffer stringBuffer, char c) {
        stringBuffer.append('%');
        stringBuffer.append(Character.forDigit(c >> 4 & 0xF, 16));
        stringBuffer.append(Character.forDigit(c & 0xF, 16));
    }
}

