/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.db;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import oracle.dbtools.raptor.DBDevExtensionResource;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.util.Debug;
import oracle.ide.log.LogManager;
import oracle.jdbc.OraclePreparedStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBUtil {
    public static final Object NULL_VALUE = new Object();
    private static Connections conns = new Connections();
    private static DBUtil _dbUtilInstance;
    private static final String MODULE = "begin dbms_application_info.set_module(?,?); end;";
    private static final String ACTION = "begin dbms_application_info.set_action(?); end;";
    private static final String ERR_SQL = " declare  l_theCursor     integer default dbms_sql.open_cursor;  l_status        integer default -1 ;  insqlsix        VARCHAR2(6);  begin    insqlsix:=upper(substr(ltrim(?),1,6));   if ((insqlsix  in ( 'INSERT', 'UPDATE', 'DELETE', 'SELECT') )     OR(substr(insqlsix,1,5)='MERGE')      OR(substr(insqlsix,1,4)='WITH') OR (substr(insqlsix,1,1)='(')) then      begin      l_status := -2;      dbms_sql.parse(  l_theCursor, ?, dbms_sql.native );      exception           when others then             l_status := dbms_sql.last_error_position;      end;      dbms_sql.close_cursor( l_theCursor );    end if;     ? := l_status;   end;";
    private static final String PRDNAME;
    private ArrayList _internalBinds = new ArrayList();
    private boolean _raiseError;

    public static synchronized DBUtil getInstance() {
        if (_dbUtilInstance == null) {
            _dbUtilInstance = new DBUtil();
        }
        _dbUtilInstance.setRaiseError(true);
        return _dbUtilInstance;
    }

    public void setDBAction(String conn, String action) {
        this._internalBinds.clear();
        this._internalBinds.add(action == null ? "" : action);
        this.execute(conn, ACTION, this._internalBinds);
    }

    public void setDBModuleAction(String conn, String action) {
        this._internalBinds.clear();
        this._internalBinds.add(PRDNAME);
        this._internalBinds.add(action == null ? "" : action);
        this.execute(conn, MODULE, this._internalBinds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeReturnOneCol(String conn, String query, HashMap binds) {
        String ret = null;
        CallableStatement statement = null;
        ResultSet rset = null;
        try {
            Connection connection = conns.getConnection(conn);
            statement = connection.prepareCall(query);
            this.bind((PreparedStatement)statement, binds);
            rset = statement.executeQuery();
            if (rset.next()) {
                ret = rset.getString(1);
            }
        }
        catch (Exception e) {
            if (this._raiseError) {
                ExceptionHandler.handleException(e);
            } else {
                System.err.println(e);
            }
        }
        finally {
            try {
                rset.close();
            }
            catch (Exception e) {}
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeReturnOneCol(String conn, String query, ArrayList binds) {
        String ret = null;
        CallableStatement statement = null;
        ResultSet rset = null;
        try {
            Connection connection = conns.getConnection(conn);
            statement = connection.prepareCall(query);
            this.bind((PreparedStatement)statement, binds);
            rset = statement.executeQuery();
            rset.next();
            ret = rset.getString(1);
        }
        catch (Exception e) {
            if (this._raiseError) {
                ExceptionHandler.handleException(e);
            } else {
                System.err.println(e);
            }
        }
        finally {
            try {
                rset.close();
            }
            catch (Exception e) {}
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String conn, String query, ArrayList binds) {
        int ret = 0;
        Statement statement = null;
        try {
            Connection connection = conns.getConnection(conn);
            statement = connection.prepareCall(query);
            this.bind((PreparedStatement)statement, binds);
            ret = statement.executeUpdate();
        }
        catch (Exception e) {
            if (this._raiseError) {
                ExceptionHandler.handleException(e);
            } else {
                System.err.println(e);
            }
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String conn, String query, HashMap binds) {
        int ret = 0;
        Statement statement = null;
        try {
            Connection connection = conns.getConnection(conn);
            statement = connection.prepareCall(query);
            this.bind((PreparedStatement)statement, binds);
            ret = statement.executeUpdate();
        }
        catch (Exception e) {
            if (this._raiseError) {
                ExceptionHandler.handleException(e);
            } else {
                System.err.println(e);
            }
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String conn, String query, ArrayList binds) {
        boolean ret = false;
        Statement statement = null;
        try {
            Connection connection = conns.getConnection(conn);
            statement = connection.prepareCall(query);
            if (binds != null) {
                this.bind((PreparedStatement)statement, binds);
            }
            ret = statement.execute();
            ret = true;
        }
        catch (Exception e) {
            if (this._raiseError) {
                ExceptionHandler.handleException(e);
            } else {
                System.err.println(e);
            }
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String connectionName, String sql, HashMap<String, Object> binds) {
        boolean ret = true;
        Statement statement = null;
        try {
            Connection connection = conns.getConnection(connectionName);
            statement = connection.prepareCall(sql);
            if (binds != null) {
                this.bind((PreparedStatement)statement, binds);
            }
            ret = statement.execute();
            ret = true;
        }
        catch (Exception e) {
            ret = false;
            if (this._raiseError) {
                ExceptionHandler.handleException(e);
            } else {
                System.err.println(e);
            }
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
        return ret;
    }

    public ResultSet executeQuery(String conn, String query, HashMap binds) {
        ResultSet rset = null;
        PreparedStatement statement = null;
        try {
            Connection connection = conns.getConnection(conn);
            statement = connection.prepareCall(query);
            if (binds != null) {
                this.bind(statement, binds);
            }
            rset = statement.executeQuery();
        }
        catch (Exception e) {
            if (this._raiseError) {
                ExceptionHandler.handleException(e);
            }
            System.err.println(e);
        }
        return rset;
    }

    public HashMap getObjectBinds(String query, DBObject dbObject) {
        HashMap<String, String> binds = new HashMap<String, String>();
        if (query.indexOf(":OBJECT_NAME") > 0) {
            binds.put("OBJECT_NAME", dbObject.getObjectName());
        }
        if (query.indexOf(":OBJECT_OWNER") > 0) {
            binds.put("OBJECT_OWNER", dbObject.getSchemaName());
        }
        if (query.indexOf(":OBJECT_ID") > 0) {
            binds.put("OBJECT_ID", dbObject.getObjectId());
        }
        if (query.indexOf(":OBJECT_TYPE") > 0) {
            binds.put("OBJECT_TYPE", dbObject.getObjectType());
        }
        return binds;
    }

    public ResultSet executeQuery(String conn, String query, DBObject dbObject) {
        return this.executeQuery(conn, query, this.getObjectBinds(query, dbObject));
    }

    public ResultSet executeQuery(String conn, String query, ArrayList binds) {
        ResultSet rset = null;
        CallableStatement statement = null;
        try {
            Connection connection = conns.getConnection(conn);
            statement = connection.prepareCall(query);
            if (binds != null) {
                this.bind((PreparedStatement)statement, binds);
            }
            rset = statement.executeQuery();
        }
        catch (Exception e) {
            if (this._raiseError) {
                ExceptionHandler.handleException(e);
            }
            System.err.println(e);
        }
        return rset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<HashMap> executeReturnArrayList(String conn, String sql, HashMap binds) {
        ArrayList<HashMap> ret = new ArrayList<HashMap>();
        ResultSet rs = this.executeQuery(conn, sql, binds);
        try {
            HashMap<String, Object> row = new HashMap<String, Object>();
            while (rs.next()) {
                for (int i = 0; i < rs.getMetaData().getColumnCount(); ++i) {
                    row.put(rs.getMetaData().getColumnName(i + 1), rs.getObject(i + 1));
                }
            }
        }
        catch (SQLException e) {
            if (this._raiseError) {
                ExceptionHandler.handleException(e);
            } else {
                System.err.println(e);
            }
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception e) {}
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, Object> executeReturnHashMap(String conn, String sql, HashMap binds) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ResultSet rs = this.executeQuery(conn, sql, binds);
        try {
            while (rs != null && rs.next()) {
                for (int i = 0; i < rs.getMetaData().getColumnCount(); ++i) {
                    ret.put(i + "." + rs.getMetaData().getColumnName(i + 1), rs.getObject(i + 1));
                }
            }
        }
        catch (SQLException e) {
            if (this._raiseError) {
                ExceptionHandler.handleException(e);
            } else {
                System.err.println(e);
            }
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception e) {}
        }
        return ret;
    }

    public void bind(PreparedStatement stmt, HashMap map) throws SQLException {
        OraclePreparedStatement ostmt = (OraclePreparedStatement)stmt;
        String bindName2 = null;
        Object bindValue = null;
        for (String bindName2 : map.keySet()) {
            bindValue = map.get(bindName2);
            Debug.debug(bindName2);
            if (bindValue == NULL_VALUE) {
                ostmt.setNullAtName(bindName2, 12);
                continue;
            }
            if (bindValue instanceof String) {
                ostmt.setStringAtName(bindName2, (String)bindValue);
                continue;
            }
            if (bindValue instanceof BigDecimal) {
                ostmt.setBigDecimalAtName(bindName2, (BigDecimal)bindValue);
                continue;
            }
            ostmt.setObjectAtName(bindName2, bindValue);
        }
    }

    public void bind(PreparedStatement stmt, ArrayList binds) throws SQLException {
        Object bind = null;
        int n = binds.size();
        for (int i = 0; i < n; ++i) {
            bind = binds.get(i);
            Debug.debug(bind);
            if (bind == NULL_VALUE || bind instanceof String && ((String)bind).equals("")) {
                stmt.setNull(i + 1, 12);
                continue;
            }
            if (bind instanceof String) {
                stmt.setString(i + 1, bind);
                continue;
            }
            if (bind instanceof BigDecimal) {
                stmt.setBigDecimal(i + 1, bind);
                continue;
            }
            if (!(bind instanceof Date)) continue;
            stmt.setDate(i + 1, bind);
        }
    }

    public String getDBMSOUTPUT(String conn) {
        return this.getDBMSOUTPUT(conns.getConnection(conn));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDBMSOUTPUT(Connection conn) {
        StringBuilder sb = new StringBuilder();
        CallableStatement stmt = null;
        try {
            stmt = conn.prepareCall("declare     l_line varchar2(255);     l_done number;     l_buffer long; begin   loop     exit when length(l_buffer)+255 > :maxbytes OR l_done = 1;     dbms_output.get_line( l_line, l_done );     l_buffer := l_buffer || l_line || chr(10);   end loop;  :done := l_done;  :buffer := l_buffer; end;");
            stmt.registerOutParameter(2, 4);
            stmt.registerOutParameter(3, 12);
            do {
                stmt.setInt(1, 1000);
                stmt.executeUpdate();
                sb.append(stmt.getString(3));
            } while (stmt.getInt(2) != 1);
        }
        catch (SQLException e) {
            System.err.print("Could not get DBMS_OUTPUT" + e.getMessage());
        }
        finally {
            try {
                stmt.close();
            }
            catch (SQLException e) {}
        }
        return sb.toString();
    }

    public void handleException(Exception e) {
        String err = e.getMessage();
        LogManager.getLogManager().getMsgPage().log((Object)err);
    }

    public void close(Statement stmt) {
        try {
            stmt.close();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public static boolean checkVersion(String conn, float maxver, float minver) {
        boolean ret = false;
        int minor = 0;
        int major = 0;
        float dbVersion = 0.0f;
        try {
            minor = Connections.getInstance().getConnection(conn).getMetaData().getDatabaseMinorVersion();
            major = Connections.getInstance().getConnection(conn).getMetaData().getDatabaseMajorVersion();
            dbVersion = Float.parseFloat(major + "." + minor);
        }
        catch (SQLException e) {
            Debug.error("could_not_detect_db_version");
        }
        if ((double)dbVersion == 0.0 || ((double)minver == 0.0 || minver != 0.0f && minver <= dbVersion) && ((double)maxver == 0.0 || maxver != 0.0f && maxver >= dbVersion)) {
            ret = true;
        }
        return ret;
    }

    public static boolean checkVersion(DBObject dbObject, float maxver, float minver) {
        boolean ret = false;
        int minor = 0;
        int major = 0;
        float dbVersion = 0.0f;
        try {
            minor = dbObject.getDatabase().getConnection().getMetaData().getDatabaseMinorVersion();
            major = dbObject.getDatabase().getConnection().getMetaData().getDatabaseMajorVersion();
            dbVersion = Float.parseFloat(major + "." + minor);
        }
        catch (Exception e) {
            Debug.error("could_not_detect_db_version");
        }
        if ((double)dbVersion == 0.0 || ((double)minver == 0.0 || minver != 0.0f && minver <= dbVersion) && ((double)maxver == 0.0 || maxver != 0.0f && maxver >= dbVersion)) {
            ret = true;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getErrorOffset(Connection conn, String sql) {
        int ret = 0;
        CallableStatement stmt = null;
        try {
            stmt = conn.prepareCall(ERR_SQL);
            stmt.setString(1, sql);
            stmt.setString(2, sql);
            stmt.registerOutParameter(3, 4);
            stmt.execute();
            ret = stmt.getInt(3);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {}
            }
        }
        return ret;
    }

    public static String enquote(String s) {
        boolean quote = false;
        for (int i = 0; i < s.length(); ++i) {
            if ((s.charAt(i) >= 'A' || s.charAt(i) >= '0' && s.charAt(i) <= '9') && (s.charAt(i) <= 'Z' || s.charAt(i) == '_')) continue;
            quote = true;
        }
        if (quote) {
            return "\"" + s + "\"";
        }
        return s;
    }

    public void setRaiseError(boolean b) {
        this._raiseError = b;
    }

    public void bind(String sql, PreparedStatement stmt, HashMap bindMap) throws SQLException {
        HashMap binds = new HashMap();
        Iterator iter = bindMap.keySet().iterator();
        String bindName = null;
        Object bindValue = null;
        while (iter.hasNext()) {
            bindName = (String)iter.next();
            bindValue = bindMap.get(bindName);
            if (sql.indexOf(":" + bindName) <= 0) continue;
            binds.put(bindName, bindMap.get(bindName));
        }
        this.bind(stmt, binds);
    }

    static {
        PRDNAME = DBDevExtensionResource.getBundle("oracle.dbtools.raptor.DBDevExtensionResource").getString("EXTENSION_NAME");
    }
}

