/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.db;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import oracle.dbtools.raptor.utils.NLSUtils;
import oracle.javatools.editor.BasicEditorPane;
import oracle.jdbc.OracleResultSet;
import oracle.sql.Datum;

public class ResultSetFormatter {
    private static final int MAX_ROWS_IN_A_SELECT = 5000;
    private static BasicEditorPane textPanelArea = new BasicEditorPane();
    private static Font font = textPanelArea.getFont();
    private static FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(font);
    private static final String spaceStr = " ";
    private static final int spacePixelWidth = fm.stringWidth(" ");

    public int rset2sqlplus(ResultSet rset, BufferedOutputStream out) throws IOException, SQLException {
        int i;
        int cnt = 0;
        ResultSetMetaData rmeta = rset.getMetaData();
        int colCnt = rmeta.getColumnCount();
        int[] colsizes = new int[colCnt + 1];
        StringBuffer header = new StringBuffer();
        StringBuffer headerLine = new StringBuffer();
        for (int i2 = 1; i2 < colCnt + 1; ++i2) {
            int j;
            colsizes[i2] = rmeta.getColumnType(i2) == 91 || rmeta.getColumnType(i2) == 92 || rmeta.getColumnType(i2) == 93 ? 25 : (rmeta.getColumnDisplaySize(i2) < rmeta.getColumnName(i2).length() ? rmeta.getColumnName(i2).length() : rmeta.getColumnDisplaySize(i2));
            header.append(rmeta.getColumnName(i2));
            int jj = colsizes[i2] - rmeta.getColumnName(i2).length();
            for (j = 0; j < jj; ++j) {
                header.append(spaceStr);
            }
            jj = colsizes[i2];
            for (j = 0; j < jj; ++j) {
                headerLine.append("-");
            }
            header.append(spaceStr);
            headerLine.append(spaceStr);
        }
        out.write(header.toString().getBytes("UTF-8"));
        out.write(10);
        out.write(headerLine.toString().getBytes("UTF-8"));
        out.write(10);
        Object temp = null;
        ArrayList<StringBuffer> cacheRow = new ArrayList<StringBuffer>();
        for (i = 0; i < colCnt + 1; ++i) {
            cacheRow.add(new StringBuffer());
        }
        while (rset.next() && cnt < 5000) {
            ++cnt;
            for (i = 1; i < colCnt + 1; ++i) {
                Datum o = ((OracleResultSet)rset).getOracleObject(i);
                if (o != null) {
                    cacheRow.set(i, new StringBuffer(NLSUtils.getValue(rset.getStatement().getConnection(), o).toString().replace("\r\n", "\n")));
                    continue;
                }
                cacheRow.set(i, new StringBuffer());
            }
            boolean multiline = false;
            boolean stopit = false;
            while (!stopit) {
                stopit = true;
                for (int i3 = 1; i3 < colCnt + 1; ++i3) {
                    StringBuffer nextChunk = (StringBuffer)cacheRow.get(i3);
                    int ival = nextChunk.indexOf("\n");
                    if (ival != -1) {
                        multiline = true;
                        StringBuffer store = nextChunk;
                        nextChunk = new StringBuffer(nextChunk.substring(0, ival));
                        store = store.length() - 1 > ival ? new StringBuffer(store.substring(ival + 1)) : new StringBuffer("");
                        cacheRow.set(i3, store);
                        stopit = false;
                    } else {
                        cacheRow.set(i3, new StringBuffer(""));
                    }
                    int pixelWidth = fm.stringWidth(nextChunk.toString());
                    if (pixelWidth < colsizes[i3] * spacePixelWidth) {
                        int pixelsRequired = colsizes[i3] * spacePixelWidth - pixelWidth;
                        int spacesRequired = pixelsRequired / spacePixelWidth;
                        for (int j = 0; j < spacesRequired; ++j) {
                            nextChunk.append(spaceStr);
                        }
                    }
                    nextChunk.append(spaceStr);
                    byte[] barray = nextChunk.toString().getBytes("UTF-8");
                    out.write(barray);
                }
                out.write(10);
            }
            if (!multiline) continue;
            out.write(10);
        }
        if (cnt == 5000 && rset.next()) {
            this.logMaxReached(out);
        }
        return cnt;
    }

    public int rset2csv(ResultSet rset, BufferedOutputStream out) throws IOException, SQLException {
        int cnt = 0;
        ResultSetMetaData rmeta = rset.getMetaData();
        int colCnt = rmeta.getColumnCount();
        while (rset.next() && cnt < 5000) {
            ++cnt;
            for (int i = 0; i < colCnt; ++i) {
                if (rset.getString(i + 1) != null) {
                    out.write(34);
                    out.write(NLSUtils.getValue(rset.getStatement().getConnection(), rset.getObject(i + 1)).toString().getBytes("UTF-8"));
                    out.write(34);
                }
                if (i == colCnt) continue;
                out.write(44);
            }
            out.write(10);
        }
        if (cnt == 5000 && rset.next()) {
            this.logMaxReached(out);
        }
        return cnt;
    }

    public int rset2xml(ResultSet rset, BufferedOutputStream out) throws IOException, SQLException {
        int cnt = 0;
        ResultSetMetaData rmeta = rset.getMetaData();
        int colCnt = rset.getMetaData().getColumnCount();
        out.write("<results>".getBytes());
        while (rset.next() && cnt < 5000) {
            ++cnt;
            for (int i = 0; i < colCnt; ++i) {
                out.write("<![CDATA[".getBytes());
                if (rset.getBytes(i + 1) != null) {
                    out.write(NLSUtils.getValue(rset.getStatement().getConnection(), rset.getObject(i + 1)).toString().getBytes("UTF-8"));
                }
                out.write("]]>".getBytes());
            }
        }
        out.write("</results>".getBytes());
        if (cnt == 5000 && rset.next()) {
            this.logMaxReached(out);
        }
        return cnt;
    }

    public int rset2html(ResultSet rset, BufferedOutputStream out) throws IOException, SQLException {
        int cnt = 0;
        ResultSetMetaData rmeta = rset.getMetaData();
        int colCnt = rset.getMetaData().getColumnCount();
        out.write("<html>\n<body>\n<table>\n".getBytes());
        while (rset.next() && cnt < 5000) {
            out.write("<tr>\n".getBytes());
            ++cnt;
            for (int i = 0; i < colCnt; ++i) {
                out.write("<td>".getBytes());
                if (rset.getBytes(i + 1) != null) {
                    out.write(NLSUtils.getValue(rset.getStatement().getConnection(), rset.getObject(i + 1)).toString().getBytes("UTF-8"));
                }
                out.write("</td>".getBytes());
            }
            out.write("</tr>\n".getBytes());
        }
        out.write("</table></body></html>".getBytes());
        if (cnt == 5000 && rset.next()) {
            this.logMaxReached(out);
        }
        return cnt;
    }

    public void logMaxReached(BufferedOutputStream out) throws IOException {
        out.write("Only 5000 rows currently supported in a script results".getBytes());
    }
}

