/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.editors.IDBEditor;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.NLSUtils;
import oracle.ide.Ide;
import oracle.ide.config.ClientSetting;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.cm.dt.ConnectionNode;
import oracle.jdeveloper.cm.dt.DatabaseConnectionNode;

public class ConnectionListener
extends NodeListener {
    private ConnectionNode _cn = (ConnectionNode)Ide.getSystem().getChild(ConnectionNode.class);
    private Connections _conns;
    private static final String INIT = "begin dbms_application_info.set_module(?,?); end;";

    public ConnectionListener() {
        ConnectionNode.addNodeListenerForType(DatabaseConnectionNode.class, (NodeListener)this);
    }

    public void nodeOpened(NodeEvent e) {
        DatabaseConnectionNode node = (DatabaseConnectionNode)e.getNode();
        try {
            int dbVer = Connections.getInstance().getConnection(node.getConnectionName()).getMetaData().getDatabaseMajorVersion();
            if (dbVer < 9) {
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)"Database Versions 9.x and above are supported.", (String)"Unsupported Database Version", (String)"f1_nonsupporteddb_html");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        NLSUtils.populateNLS((OracleDatabase)Connections.getInstance().getDatabase(node.getConnectionName()));
        this.attachDBConfigPropertyListener(node);
        node.notifyObservers((Object)this, new UpdateMessage(UpdateMessage.ATTRIBUTE_CHANGED, (Object)this));
    }

    public void nodeClosed(NodeEvent e) {
        DatabaseConnectionNode node = (DatabaseConnectionNode)e.getNode();
        node.notifyObservers((Object)this, new UpdateMessage(UpdateMessage.ATTRIBUTE_CHANGED, (Object)this));
    }

    public void nodeWillClose(NodeEvent e) {
        List editors = EditorManager.getEditorManager().getAllEditors();
        ArrayList<Editor> closeEditors = new ArrayList<Editor>();
        for (Editor ed : editors) {
            if (!(ed instanceof IDBEditor) || !((IDBEditor)ed).getDatabase().getConnectionName().equals(((DatabaseConnectionNode)e.getNode()).getConnectionName())) continue;
            closeEditors.add(ed);
        }
        EditorManager.getEditorManager().closeEditors(closeEditors);
    }

    public void attachDBConfigPropertyListener(DatabaseConnectionNode node) {
        ClientSetting ideSettings = ClientSetting.findOrCreate((String)"oracle.sqldeveloper");
        DBConfig cfg = (DBConfig)ideSettings.getData("DBConfig");
        if (cfg == null) {
            cfg = new DBConfig();
            ideSettings.putData("DBConfig", (Copyable)cfg);
        }
        final Connection conn = Connections.getInstance().getConnection(node.getConnectionName());
        cfg.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("Autocommit".equals(evt.getPropertyName())) {
                    try {
                        conn.setAutoCommit((Boolean)evt.getNewValue());
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }
}

