/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.ColumnTreeNode;
import oracle.dbtools.raptor.ConnectionListener;
import oracle.dbtools.raptor.DBTypeDisplay;
import oracle.dbtools.raptor.RaptorFileSystemHelper;
import oracle.dbtools.raptor.RaptorWizardFactory;
import oracle.dbtools.raptor.RelationFilter;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.ExportPanel;
import oracle.dbtools.raptor.dialogs.BasicObjectModifier;
import oracle.dbtools.raptor.dialogs.CreateDialogArb;
import oracle.dbtools.raptor.dialogs.conn.ConnectionPrompt;
import oracle.dbtools.raptor.dialogs.conn.DatabaseInfo;
import oracle.dbtools.raptor.dialogs.conn.RaptorConnectionStore;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.ClientSetting;
import oracle.ide.controller.Command;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.navigator.NavigatorConstants;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.panels.Navigable;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.OracleDatabaseFactory;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.cm.ConnectInfoPrompter;
import oracle.jdeveloper.cm.ConnectionManager;
import oracle.jdeveloper.cm.ConnectionStore;
import oracle.jdeveloper.cm.WritableConnectionStore;
import oracle.jdeveloper.cm.ds.db.DBTypeDisplayRegistry;
import oracle.jdeveloper.cm.ds.db.DBUtil;
import oracle.jdeveloper.cm.dt.CmUtil;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.DatabaseConnectionNode;
import oracle.jdeveloper.cm.dt.JdbcConnectionFactory;
import oracle.jdeveloper.cm.dt.browser.CBBaseFolder;
import oracle.jdeveloper.cm.dt.browser.CBBaseNode;
import oracle.jdeveloper.cm.dt.browser.jdbc.IndexNode;
import oracle.jdeveloper.cm.dt.browser.jdbc.OCBBaseFolder;
import oracle.jdeveloper.cm.dt.browser.jdbc.ObjectFolder;
import oracle.jdeveloper.cm.dt.browser.jdbc.PlSqlBaseNode;
import oracle.jdeveloper.cm.dt.browser.jdbc.SchemaFolder;
import oracle.jdeveloper.cm.dt.browser.jdbc.TableNode;
import oracle.jdeveloper.cm.dt.browser.jdbc.ViewNode;
import oracle.jdeveloper.cm.dt.config.BaseConnectionOptions;
import oracle.jdeveloper.cm.dt.wizard.DBWizardFactory;
import oracle.jdeveloper.cm.dt.wizard.DBWizardFactoryRegistry;
import oracle.jdevimpl.cm.dt.browser.jdbc.ConnectionNodeFilter;
import oracle.jdevimpl.cm.dt.browser.jdbc.OtherSchemas;

class RaptorDBAddin
implements Addin {
    private static final String CLEAR_FILTER_CMD = ClearFilterCommand.class.getName();
    private static final int CLEAR_FILTER_CMD_ID = Ide.findOrCreateCmdID((String)CLEAR_FILTER_CMD);

    public void initialize() {
        ConnectionManager cm = ConnectionManager.getInstance();
        cm.setConnectionStore((ConnectionStore)new RaptorConnectionStore((WritableConnectionStore)cm.getConnectionStore()));
        NavigatorManager mgr = NavigatorManager.getConnectionNavigatorManager();
        if (mgr != null) {
            int id;
            IdeAction toolbarAction;
            mgr.addContextMenuListener((ContextMenuListener)new L(), null);
            mgr.registerFilter(TableNode.class, RelationFilter.class, null);
            mgr.registerFilter(ViewNode.class, RelationFilter.class, null);
            mgr.registerFilter(DatabaseConnectionNode.class, HideJavaFilter.class, null);
            mgr.registerFilter(SchemaFolder.class, HideJavaFilter.class, null);
            mgr.addContextMenuListener((ContextMenuListener)new NavHelpListener(), ObjectFolder.class);
            mgr.addContextMenuListener((ContextMenuListener)BasicObjectModifier.getInstance(), CBBaseNode.class);
            mgr.addContextMenuListener((ContextMenuListener)BasicObjectModifier.getInstance(), PlSqlBaseNode.class);
            mgr.addContextMenuListener((ContextMenuListener)BasicObjectModifier.getInstance(), SchemaFolder.class);
            mgr.addContextMenuListener((ContextMenuListener)BasicObjectModifier.getInstance(), OtherSchemas.class);
            mgr.addContextMenuListener((ContextMenuListener)BasicObjectModifier.getInstance(), ColumnTreeNode.class);
            mgr.addContextMenuListener((ContextMenuListener)BasicObjectModifier.getInstance(), DatabaseConnectionNode.class);
            DBWizardFactoryRegistry.registerDBWizardFactory(OracleDatabase.class, (DBWizardFactory)new RaptorWizardFactory());
            URLFileSystemHelper helper = URLFileSystem.findHelper((String)"jdev.cm");
            if (helper != null) {
                URLFileSystem.registerHelper((String)"jdev.cm", (URLFileSystemHelper)new RaptorFileSystemHelper(helper));
            }
            DBUtil.addDBTypeTypeRegistry((DBTypeDisplayRegistry)new DBTypeDisplay());
            ExportPanel.initMenu();
            new ConnectionListener();
            ConnectionPrompt p = new ConnectionPrompt();
            JdbcConnectionFactory.getInstance().setPrompter((ConnectInfoPrompter)p);
            ClientSetting ideSettings = ClientSetting.findOrCreate((String)"oracle.sqldeveloper");
            DBConfig cfg = (DBConfig)ideSettings.getData("DBConfig");
            if (cfg == null) {
                cfg = new DBConfig();
                ideSettings.putData("DBConfig", (Copyable)cfg);
            }
            cfg.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if ("Autocommit".equals(evt.getPropertyName())) {
                        OracleDatabaseFactory.setDefaultAutocommit((boolean)((Boolean)evt.getNewValue()));
                    }
                }
            });
            OracleDatabaseFactory.setDefaultAutocommit((boolean)cfg.isAutocommit());
            BaseConnectionOptions opts = (BaseConnectionOptions)ideSettings.getData("DatabaseOptions");
            if (opts == null) {
                opts = new BaseConnectionOptions();
                ideSettings.putData("DatabaseOptions", (Copyable)opts);
            }
            ClientSetting.registerUI((Navigable)new Navigable(ConnectionArb.getString((int)374), DatabaseInfo.class));
            IdeAction viewAction = IdeAction.find((int)66);
            if (viewAction != null) {
                String label = CreateDialogArb.getString(571);
                viewAction.putValue("Name", (Object)StringUtils.stripMnemonic((String)label));
                viewAction.putValue("MnemonicKey", (Object)new Integer(StringUtils.getMnemonicKeyCode((String)label)));
            }
            if ((toolbarAction = IdeAction.find((int)(id = Ide.findCmdID((String)"ConnectionNavigator.TOGGLE_TOOLBAR_CMD_ID").intValue()))) != null) {
                String label = CreateDialogArb.getString(572);
                toolbarAction.putValue("Name", (Object)StringUtils.stripMnemonic((String)label));
                toolbarAction.putValue("MnemonicKey", (Object)new Integer(StringUtils.getMnemonicKeyCode((String)label)));
            }
        }
    }

    private static Element getElement(Context ctx) {
        Element element = null;
        Element[] sel = ctx.getSelection();
        if (sel != null && sel.length == 1) {
            element = sel[0];
        }
        return element;
    }

    public static final class HideJavaFilter
    extends ConnectionNodeFilter {
        public Iterator getChildren() {
            return new FilterIterator(super.getChildren());
        }

        private static final class FilterIterator
        implements Iterator {
            private Iterator _iter;
            private Element _next;

            FilterIterator(Iterator iter) {
                this._iter = iter;
            }

            public boolean hasNext() {
                return this._next != null || this.advance();
            }

            public Object next() {
                if (this._next == null) {
                    throw new NoSuchElementException();
                }
                Element o = this._next;
                this.advance();
                return o;
            }

            private boolean advance() {
                boolean hasNext = false;
                if (this._iter != null) {
                    if (this._iter.hasNext()) {
                        this._next = (Element)this._iter.next();
                        URL url = ((Locatable)this._next).getURL();
                        hasNext = "JAVA".equals(CmUtil.getDbObjectType((URL)url)) ? this.advance() : true;
                    } else {
                        this._iter = null;
                    }
                } else {
                    this._next = null;
                }
                return hasNext;
            }

            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        }
    }

    private static final class NavHelpListener
    implements ContextMenuListener,
    Controller {
        public static final int HELP_COMMAND_NAME = Ide.findOrCreateCmdID((String)"oracle.dbtools.raptor.RaptorDBAddin.HELP");
        private static final IdeAction actionHelp = IdeAction.get((int)HELP_COMMAND_NAME, (String)StringUtils.stripMnemonic((String)CreateDialogArb.getString(528)), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)CreateDialogArb.getString(528))));
        static JMenuItem MENU_HELP = null;
        private static String HELP_PREFIX = "f1_raptorconnectionnav_";

        private NavHelpListener() {
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }

        public void menuWillHide(ContextMenu contextMenu) {
        }

        public void menuWillShow(ContextMenu contextMenu) {
            if (MENU_HELP == null) {
                actionHelp.addController((Controller)this);
                MENU_HELP = contextMenu.createMenuItem((ToggleAction)actionHelp);
            }
            contextMenu.add((Component)MENU_HELP);
        }

        public boolean handleEvent(IdeAction action, Context context) {
            if (action.equals(actionHelp)) {
                Node node = context.getNode();
                if (node instanceof OCBBaseFolder) {
                    OCBBaseFolder folder = (OCBBaseFolder)node;
                    String type = folder.getObjectType().replaceAll(" ", "_");
                    HelpInfo helpInfo = new HelpInfo(HELP_PREFIX + type);
                    HelpSystem.getHelpSystem().showHelp(helpInfo);
                }
                return true;
            }
            return false;
        }

        public boolean update(IdeAction action, Context context) {
            return false;
        }
    }

    private static final class L
    implements ContextMenuListener,
    Controller {
        private JMenuItem m_clearMenu;

        private L() {
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }

        public void menuWillHide(ContextMenu contextMenu) {
        }

        public void menuWillShow(ContextMenu contextMenu) {
            Context ctx = contextMenu.getContext();
            if (ctx.getView() instanceof NavigatorWindow) {
                URL url;
                Element elem = RaptorDBAddin.getElement(ctx);
                if (elem instanceof Locatable && CmUtil.isCMUrl((URL)(url = ((Locatable)elem).getURL()))) {
                    contextMenu.remove((Component)NavigatorConstants.New);
                    if (ctx.getNode() instanceof IndexNode) {
                        contextMenu.removeAll();
                    }
                }
                if (elem instanceof CBBaseFolder) {
                    if (this.m_clearMenu == null) {
                        IdeAction action = IdeAction.get((int)CLEAR_FILTER_CMD_ID, (String)CLEAR_FILTER_CMD, (String)StringUtils.stripMnemonic((String)CreateDialogArb.getString(570)), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)CreateDialogArb.getString(570))), null, null, null, (boolean)false);
                        action.addController((Controller)this);
                        this.m_clearMenu = contextMenu.createMenuItem((ToggleAction)action);
                    }
                    contextMenu.add((Component)this.m_clearMenu, JDeveloperMenuConstants.SECTION_CONNECTION_WINDOW_FILTER_CTXT);
                }
            }
        }

        public boolean handleEvent(IdeAction IdeAction2, Context Context2) {
            return false;
        }

        public boolean update(IdeAction action, Context ctx) {
            boolean handled = false;
            if (action.getCommandId() == CLEAR_FILTER_CMD_ID) {
                boolean enabled = false;
                Element elem = RaptorDBAddin.getElement(ctx);
                if (elem instanceof OCBBaseFolder) {
                    enabled = ((OCBBaseFolder)elem).isFiltered();
                }
                action.setEnabled(enabled);
                handled = true;
            }
            return handled;
        }
    }

    public static class ClearFilterCommand
    extends Command {
        public ClearFilterCommand() {
            super(CLEAR_FILTER_CMD_ID, 1);
        }

        public int doit() throws Exception {
            Element element;
            int result = 1;
            Context ctx = this.getContext();
            if (ctx != null && (element = RaptorDBAddin.getElement(ctx)) instanceof OCBBaseFolder) {
                result = 0;
                ((OCBBaseFolder)element).setFilter(null);
                IdeAction refresh = IdeAction.find((int)51);
                if (refresh != null) {
                    refresh.performAction(ctx);
                }
            }
            return result;
        }
    }
}

