/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor;

import java.net.URL;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.net.URLFileSystemHelperDecorator;
import oracle.jdeveloper.cm.ds.db.DBUtil;
import oracle.jdeveloper.cm.dt.CmUtil;

public class RaptorFileSystemHelper
extends URLFileSystemHelperDecorator {
    public RaptorFileSystemHelper(URLFileSystemHelper helper) {
        super(helper);
    }

    public String getPlatformPathName(URL url) {
        String type = CmUtil.getDbObjectType((URL)url);
        if (type != null) {
            String connName = CmUtil.getConnName((URL)url);
            String label = null;
            if ("SCHEMA".equals(type)) {
                label = CmUtil.getSchema((URL)url);
            } else if (CmUtil.isFolder((URL)url)) {
                label = DBUtil.getDisplayName((String)type);
            } else {
                label = type;
                String schema = CmUtil.getSchema((URL)url);
                if (schema != null) {
                    label = label + " " + schema;
                    String objName = CmUtil.getName((URL)url);
                    if (objName != null) {
                        label = label + "." + objName;
                    }
                }
            }
            label = label + "@" + connName;
            return label;
        }
        return super.getPlatformPathName(url);
    }

    public String toDisplayString(URL url) {
        String type = CmUtil.getDbObjectType((URL)url);
        if (CmUtil.isFolder((URL)url)) {
            return DBUtil.getDisplayName((String)type);
        }
        return this.getPlatformPathName(url);
    }
}

