/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import oracle.dbtools.raptor.controls.ResultSetTable;

public class ColumnAutoSize
extends MouseAdapter {
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            JTableHeader header = (JTableHeader)e.getSource();
            TableColumn tableColumn = this.getResizingColumn(header, e.getPoint());
            if (tableColumn == null) {
                return;
            }
            int col = header.getColumnModel().getColumnIndex(tableColumn.getIdentifier());
            JTable table = header.getTable();
            int rowCount = table.getRowCount();
            int width = (int)header.getDefaultRenderer().getTableCellRendererComponent(table, tableColumn.getIdentifier(), false, false, -1, col).getPreferredSize().getWidth();
            for (int row = 0; row < rowCount; ++row) {
                int preferedWidth = (int)table.getCellRenderer(row, col).getTableCellRendererComponent(table, table.getValueAt(row, col), false, false, row, col).getPreferredSize().getWidth();
                width = Math.max(width, preferedWidth);
            }
            tableColumn.setPreferredWidth(width + table.getIntercellSpacing().width);
            header.setResizingColumn(null);
            table.getParent().validate();
            if (table instanceof ResultSetTable) {
                ((ResultSetTable)table).savePersistentSettings();
            }
        }
    }

    private TableColumn getResizingColumn(JTableHeader header, Point p) {
        return this.getResizingColumn(header, p, header.columnAtPoint(p));
    }

    private TableColumn getResizingColumn(JTableHeader header, Point p, int column) {
        int columnIndex;
        if (column == -1) {
            return null;
        }
        Rectangle r = header.getHeaderRect(column);
        r.grow(-3, 0);
        if (r.contains(p)) {
            return null;
        }
        int midPoint = r.x + r.width / 2;
        if (header.getComponentOrientation().isLeftToRight()) {
            columnIndex = p.x < midPoint ? column - 1 : column;
        } else {
            int n = columnIndex = p.x < midPoint ? column : column - 1;
        }
        if (columnIndex == -1) {
            return null;
        }
        return header.getColumnModel().getColumn(columnIndex);
    }
}

