/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.DBConnectionComboBox;
import oracle.ide.Ide;
import oracle.ide.config.ClientSetting;
import oracle.ide.config.IdeSettings;
import oracle.ide.controls.GridBagConstraints2;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.Assert;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.DynamicPropertySet;
import oracle.javatools.util.DynamicPropertySetImpl;
import oracle.jdeveloper.cm.CMUtils;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.ConnectionManager;
import oracle.jdeveloper.cm.ConnectionType;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.ConnectionEditor;

public class ConnectionSelectorUI
extends JPanel
implements ActionListener,
ItemListener {
    public static boolean SELECTOR_ACTIVE = false;
    private String[] _types;
    private boolean _oracleOnly;
    private BorderLayout mainLayout = new BorderLayout();
    private JPanel subPanel = new JPanel();
    private GridBagLayout subLayout = new GridBagLayout();
    private JWrappedLabel connectionPrompt = new JWrappedLabel();
    private JLabel connectionLabel = new JLabel();
    protected JComboBox connectionsCombo = null;
    protected JButton newButton = new JButton();
    private JButton editButton = new JButton();
    private GridBagLayout detailsLayout = new GridBagLayout();
    private JPanel detailsPanel = new JPanel();
    private JLabel usernameLabel = new JLabel();
    private JLabel usernameField = new JLabel();
    private JLabel driverLabel = new JLabel();
    private JLabel driverField = new JLabel();
    private JLabel urlLabel = new JLabel();
    private JLabel urlField = new JLabel();
    private DBConnectionComboBox _dbConn = new DBConnectionComboBox();
    public static final String CONN_PANEL_SETTINGS_KEY = "ConnectionPanelSettings";
    public static final String LAST_CONNECTION_KEY = "lastConnection";

    protected ConnectionSelectorUI() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
    }

    public ConnectionSelectorUI(String type, boolean oracleOnly) {
        this();
        String[] stringArray;
        if (type == null) {
            if (oracleOnly) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "JDBC";
            } else {
                String[] stringArray3 = new String[4];
                stringArray3[0] = "JDBC";
                stringArray3[1] = "OTHER_JDBC";
                stringArray3[2] = "JDBC_ODBC";
                stringArray = stringArray3;
                stringArray3[3] = "ORACLE_LITE";
            }
        } else {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = type;
        }
        String[] types = stringArray;
        this.setConnectionInfo(types, oracleOnly);
    }

    public ConnectionSelectorUI(String connClassName) {
        this();
        String[] connTypes = null;
        try {
            connTypes = ConnectionManager.getInstance().getConnectionTypeNamesForClass(connClassName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setConnectionInfo(connTypes, false);
    }

    public ConnectionSelectorUI(String[] types) {
        this();
        this.setConnectionInfo(types, false);
    }

    public Component getDefaultFocusComponent() {
        if (this.connectionsCombo.getItemCount() < 1) {
            return this.newButton;
        }
        return this.connectionsCombo;
    }

    public JComboBox getConnCombo() {
        return this.connectionsCombo;
    }

    private void setConnectionInfo(String[] types, boolean oracleOnly) {
        this._types = types;
        this._oracleOnly = oracleOnly;
        if (types != null) {
            boolean isDB = false;
            ConnectionManager mgr = ConnectionManager.getInstance();
            for (int i = 0; i < types.length; ++i) {
                ConnectionType type = mgr.getConnectionType(types[i]);
                if (!"CLASS_DATABASE".equals(type.getConnectionClassName())) continue;
                isDB = true;
                break;
            }
            this.driverLabel.setVisible(isDB);
            this.driverField.setVisible(isDB);
        }
    }

    public static String getConnection(String title, String prompt, String connName, String connClassName, boolean oracleOnly) {
        SELECTOR_ACTIVE = true;
        final ConnectionSelectorUI panel = new ConnectionSelectorUI();
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_sql_view_connect_html");
        final JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)panel, (Component)panel.getDefaultFocusComponent(), (String)title);
        panel.connectionsCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean sel = panel.connectionsCombo.getSelectedIndex() != -1;
                dlg.setOKButtonEnabled(sel);
            }
        });
        dlg.setOKButtonEnabled(true);
        panel.setConnectionPrompt(prompt);
        String[] connTypes = null;
        try {
            connTypes = ConnectionManager.getInstance().getConnectionTypeNamesForClass(connClassName);
        }
        catch (Exception e) {
            // empty catch block
        }
        panel.setConnectionInfo(connTypes, oracleOnly);
        if (connName != null) {
            panel.setConnectionName(connName);
        }
        String ret = WizardLauncher.runDialog((JDialog)dlg) ? panel.getConnectionName() : null;
        SELECTOR_ACTIVE = true;
        return ret;
    }

    private void jbInit() throws Exception {
        this.connectionsCombo = this._dbConn.getJComboBox();
        this.connectionPrompt.setText(ConnectionArb.getString((int)106));
        this.connectionPrompt.setBorder(BorderFactory.createEmptyBorder(0, 0, 15, 0));
        ResourceUtils.resLabel((JLabel)this.connectionLabel, (Component)this.connectionsCombo, (String)ConnectionArb.getString((int)105));
        ResourceUtils.resButton((AbstractButton)this.newButton, (String)ConnectionArb.getString((int)100));
        ResourceUtils.resButton((AbstractButton)this.editButton, (String)ConnectionArb.getString((int)101));
        this.editButton.setEnabled(false);
        this.usernameLabel.setText(ConnectionArb.getString((int)103));
        this.usernameLabel.setEnabled(false);
        this.driverLabel.setText(ConnectionArb.getString((int)102));
        this.driverLabel.setEnabled(false);
        this.urlLabel.setText(ConnectionArb.getString((int)104));
        this.urlLabel.setEnabled(false);
        this.detailsPanel.setBorder(BorderFactory.createEtchedBorder());
        this.detailsPanel.setLayout(this.detailsLayout);
        this.detailsPanel.add((Component)this.usernameLabel, new GridBagConstraints2(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.detailsPanel.add((Component)this.usernameField, new GridBagConstraints2(1, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.detailsPanel.add((Component)this.driverLabel, new GridBagConstraints2(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.detailsPanel.add((Component)this.driverField, new GridBagConstraints2(1, 1, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.detailsPanel.add((Component)this.urlLabel, new GridBagConstraints2(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.detailsPanel.add((Component)this.urlField, new GridBagConstraints2(1, 2, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.subPanel.setLayout(this.subLayout);
        this.subPanel.add((Component)this.connectionLabel, new GridBagConstraints2(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.subPanel.add((Component)this.connectionsCombo, new GridBagConstraints2(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.subPanel.add((Component)this.newButton, new GridBagConstraints2(2, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.subPanel.add((Component)this.detailsPanel, new GridBagConstraints2(0, 1, 2, 2, 1.0, 1.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.subPanel.add((Component)this.editButton, new GridBagConstraints2(2, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.setLayout(this.mainLayout);
        this.add((Component)this.connectionPrompt, "North");
        this.add((Component)this.subPanel, "Center");
        this.addListeners();
        this._enableButtons();
        ItemEvent dummy = new ItemEvent(this.connectionsCombo, 701, new Integer(0), 1);
        this.itemStateChanged(dummy);
    }

    private void addListeners() {
        this.connectionsCombo.addItemListener(this);
        this.newButton.addActionListener(this);
        this.editButton.addActionListener(this);
    }

    private void removeListeners() {
        this.connectionsCombo.removeItemListener(this);
        this.newButton.removeActionListener(this);
        this.editButton.removeActionListener(this);
    }

    public String getConnectionName() {
        return this._dbConn.getCurrentConnectionName();
    }

    public void setConnectionName(String name) {
        this._dbConn.setCurrentConnection(name);
    }

    public void itemStateChanged(ItemEvent e) {
        try {
            ConnectionManager mgr = ConnectionManager.getInstance();
            String name = this._dbConn.getCurrentConnectionName();
            if (name != null) {
                ConnectionDescriptor desc = mgr.getConnectionDescriptor(name);
                boolean validDesc = desc != null;
                this.editButton.setEnabled(validDesc);
                this.usernameLabel.setEnabled(validDesc);
                this.usernameField.setText(validDesc ? desc.getProperty("user") : null);
                this.driverLabel.setEnabled(validDesc);
                this.driverField.setText(validDesc ? desc.getProperty("JdbcDriver") : null);
                this.urlLabel.setEnabled(validDesc);
                this.urlField.setText(validDesc ? CMUtils.getUrl((String)"JDBC", (ConnectionDescriptor)desc) : null);
            }
        }
        catch (Exception ex) {
            Assert.printStackTrace((Throwable)ex);
            this.usernameLabel.setEnabled(false);
            this.usernameField.setText(null);
            this.driverLabel.setEnabled(false);
            this.driverField.setText(null);
            this.urlLabel.setEnabled(false);
            this.urlField.setText(null);
            this.editButton.setEnabled(false);
        }
    }

    public void actionPerformed(ActionEvent e) {
        boolean isEdit = e.getSource() == this.editButton;
        int action = isEdit ? 2 : 1;
        this.editButton.setEnabled(false);
        this.newButton.setEnabled(false);
        ConnectionEditor dlg = new ConnectionEditor();
        if (dlg == null) {
            this._enableButtons();
            return;
        }
        if (dlg.runConnectionEditor(this.getConnectionName(), action, this._types)) {
            ConnectionDescriptor cd = dlg.getConnectionDescriptor();
            String name = cd != null ? cd.getConnectionName() : null;
        }
        this._enableButtons();
    }

    public void setConnectionPrompt(String prompt) {
        if (prompt == null) {
            this.remove((Component)this.connectionPrompt);
        } else {
            this.connectionPrompt.setText(prompt);
            this.add((Component)this.connectionPrompt, "North");
        }
        this.validate();
    }

    public void enableActiveComponents(boolean enable) {
        this.usernameLabel.setEnabled(enable);
        this.usernameField.setEnabled(enable);
        this.driverLabel.setEnabled(enable);
        this.driverField.setEnabled(enable);
        this.urlLabel.setEnabled(enable);
        this.urlField.setEnabled(enable);
        this.connectionLabel.setEnabled(enable);
        this.connectionsCombo.setEnabled(enable);
        if (enable) {
            this._enableButtons();
        } else {
            this.newButton.setEnabled(false);
            this.editButton.setEnabled(false);
        }
    }

    protected void _enableButtons() {
        this.newButton.setEnabled(true);
        this.editButton.setEnabled(true);
    }

    public void loadSettings() {
        String prevConn = null;
        IdeSettings settings = Ide.getSettings();
        DynamicPropertySet connectionPanelSettings = (DynamicPropertySet)settings.getData(CONN_PANEL_SETTINGS_KEY);
        if (connectionPanelSettings != null) {
            prevConn = (String)connectionPanelSettings.getProperty(LAST_CONNECTION_KEY);
            this.connectionsCombo.setSelectedItem(prevConn);
        }
    }

    public void saveSettings() {
        String newConn = (String)this.connectionsCombo.getSelectedItem();
        if (ModelUtil.hasLength((String)newConn)) {
            IdeSettings settings = Ide.getSettings();
            DynamicPropertySet connectionPanelSettings = (DynamicPropertySet)settings.getData(CONN_PANEL_SETTINGS_KEY);
            if (connectionPanelSettings == null) {
                connectionPanelSettings = new DynamicPropertySetImpl();
                ClientSetting.findOrCreate((String)"oracle.onlinedb").putData(CONN_PANEL_SETTINGS_KEY, (Copyable)connectionPanelSettings);
            }
            connectionPanelSettings.setProperty(LAST_CONNECTION_KEY, (Object)newConn);
        }
    }
}

