/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.sql.Clob;
import java.sql.Connection;
import javax.accessibility.AccessibleContext;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import oracle.dbtools.raptor.models.ResultSetTableModel;
import oracle.dbtools.raptor.utils.NLSUtils;
import oracle.javatools.clipboard.ClipboardStack;
import oracle.sql.Datum;
import oracle.sql.OPAQUE;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

public class CopyableResultSetTableAdapter {
    protected final JTable _table;
    protected String _nullValue = "(null)";

    public CopyableResultSetTableAdapter(JTable table) {
        this._table = table;
    }

    public void setNullString(String s) {
        this._nullValue = s;
    }

    public String getNullString() {
        return this._nullValue;
    }

    public boolean canCopy() {
        return CopyableResultSetTableAdapter.isSelectionSizeOk(this._table.getSelectedRowCount(), this._table.getSelectedRows()) && (this._table.getRowSelectionAllowed() || CopyableResultSetTableAdapter.isSelectionSizeOk(this._table.getSelectedColumnCount(), this._table.getSelectedColumns()));
    }

    public boolean copyToClipboard() {
        int numRows = this._table.getSelectedRowCount();
        int[] rows = this._table.getSelectedRows();
        int numCols = this._table.getColumnCount();
        int[] cols = null;
        rows = this._table.getSelectedRows();
        cols = this._table.getSelectedColumns();
        Connection conn = null;
        if (this._table.getModel() instanceof ResultSetTableModel) {
            conn = ((ResultSetTableModel)this._table.getModel()).getConn();
        }
        StringBuilder sbf = new StringBuilder(numRows * numCols * 10);
        for (int row : rows) {
            if (rows.length > 1 && sbf.length() > 0) {
                sbf.append("\n");
            }
            for (int i = 0; i < this._table.getColumnCount(); ++i) {
                String s;
                if (!this._table.isCellSelected(row, i)) continue;
                Object o = this._table.getValueAt(row, i);
                if (o instanceof JLabel) {
                    AccessibleContext actx;
                    JLabel lbl = (JLabel)o;
                    s = lbl.getText();
                    if (!(s != null && s.length() != 0 || (s = (actx = lbl.getAccessibleContext()).getAccessibleName()) != null && s.length() != 0)) {
                        s = actx.getAccessibleDescription();
                    }
                } else {
                    s = conn != null ? (String)(o != null ? NLSUtils.getValue(conn, o) : this._nullValue) : (o != null ? this.getValue(o) : this._nullValue);
                }
                sbf.append(s);
                if (i >= numCols - 1) continue;
                sbf.append("\t");
            }
        }
        StringSelection stsel = new StringSelection(sbf.toString());
        Clipboard system = Toolkit.getDefaultToolkit().getSystemClipboard();
        ClipboardStack.pushCurrentClipboard();
        system.setContents(stsel, stsel);
        return true;
    }

    public static boolean isSelectionSizeOk(int num, int[] rows) {
        if (rows == null || rows.length == 0) {
            return false;
        }
        int rowSize = rows[rows.length - 1] - rows[0];
        return num - 1 == rowSize && num == rows.length;
    }

    protected static int[] _getColumnList(JTable tbl) {
        if (tbl == null) {
            return new int[0];
        }
        int size = tbl.getColumnCount();
        int[] result = new int[size];
        for (int i = 0; i < size; ++i) {
            result[i] = i;
        }
        return result;
    }

    protected String getValue(Object obj) {
        TableModel tm = this._table.getModel();
        ResultSetTableModel rsTm = null;
        String retVal = this._nullValue;
        if (tm instanceof ResultSetTableModel) {
            rsTm = (ResultSetTableModel)tm;
        }
        try {
            retVal = obj instanceof Clob ? ((Clob)obj).getSubString(1L, (int)((Clob)obj).length()) : (obj instanceof OPAQUE ? ((OPAQUE)obj).getSQLTypeName().trim() : (obj instanceof TIMESTAMPTZ && rsTm != null ? ((TIMESTAMPTZ)obj).stringValue(rsTm.getConn()) : (obj instanceof TIMESTAMPLTZ && rsTm != null ? ((TIMESTAMPLTZ)obj).stringValue(rsTm.getConn()) : (obj instanceof Datum ? ((Datum)obj).stringValue() : obj.toString()))));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retVal;
    }
}

