/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import oracle.dbtools.raptor.controls.DBConnectionComboBox;
import oracle.dbtools.raptor.utils.SpringUtilities;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.controls.tree.CustomJTree;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Schema;
import oracle.javatools.db.ora.OracleDatabase;

public class DBObjectSelector
extends JPanel {
    private DBConnectionComboBox _dbComboBox;
    private String[] _types;
    private JMutableTreeNode _myObjects;
    private JMutableTreeNode _otherUsers;
    private OracleDatabase _db;
    private CustomJTree _tree;
    private DefaultTreeModel _model;
    private DefaultMutableTreeNode _root;
    private JScrollPane _sp;

    public DBObjectSelector() {
        this.setLayout(new SpringLayout());
        this.add(new JLabel(Translate.translate("Connection:")));
        this._dbComboBox = new DBConnectionComboBox();
        this._dbComboBox.getJComboBox().setSelectedIndex(-1);
        this.add(this._dbComboBox.getJComboBox());
        this.add(new JLabel(Translate.translate("Objects:")));
        this._sp = new JScrollPane();
        this._sp.setMinimumSize(new Dimension(200, 200));
        this.add(this._sp);
        this._dbComboBox.getJComboBox().addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    DBObjectSelector.this._db = (OracleDatabase)DBObjectSelector.this._dbComboBox.getCurrentDatabase();
                }
                DBObjectSelector.this.initTree();
            }
        });
        SpringUtilities.makeCompactGrid(this, 4, 1, 0, 0, 0, 2);
    }

    public CustomJTree getTree() {
        return this._tree;
    }

    public OracleDatabase getDatabase() {
        return this._db;
    }

    private void initTree() {
        if (this._root == null) {
            this._root = this.createCheck("All", "SCHEMA_EXPORT", false);
        } else {
            this._root.removeAllChildren();
        }
        this._myObjects = this.createCheck("All My Objects", "MY", false);
        this._myObjects.add((MutableTreeNode)new JMutableTreeNode("Loading...."));
        this._otherUsers = this.createCheck("Other Users", "OTHERS", false);
        this._root.add((MutableTreeNode)this._myObjects);
        this._root.add((MutableTreeNode)this._otherUsers);
        this._otherUsers.add((MutableTreeNode)new JMutableTreeNode("Loading...."));
        this._model = new DefaultTreeModel(this._root);
        this._tree = new CustomJTree((TreeModel)this._model);
        this._tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                try {
                    DBObjectSelector.this.populateChildren((JMutableTreeNode)event.getPath().getLastPathComponent(), event.getSource());
                    ((JMutableTreeNode)event.getPath().getLastPathComponent()).sortChildren();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }
        });
        this._sp.setViewportView((Component)this._tree);
    }

    private void populateTypes() {
        this._types = this._db.listObjectTypes();
    }

    private void buildTree() throws DBException {
        if (this._db != null) {
            this.populateTypes();
            Schema[] schemas = null;
            try {
                schemas = this._db.listSchemas();
            }
            catch (DBException e) {
                e.printStackTrace();
            }
        }
    }

    private JMutableTreeNode createCheck(String name, String type, boolean enabled) {
        JTreeCellData s = new JTreeCellData(name);
        s.setCheckBoxEnabled(enabled);
        s.setTextEnabled(true);
        s.setHasCheckBox(enabled);
        s.setUserObject((Object)type);
        return new JMutableTreeNode(s);
    }

    private JMutableTreeNode createCheck(String name, String type) {
        return this.createCheck(name, type, true);
    }

    private void addTypes(JMutableTreeNode node) {
        JMutableTreeNode typeNode = null;
        if (this._db != null) {
            for (String type : this._db.listObjectTypes()) {
                if (type.equals("RECYCLEBIN") || type.equals("DIRECTORY")) continue;
                typeNode = this.createCheck(type, "OBJECT_TYPE");
                typeNode.add((MutableTreeNode)new JMutableTreeNode("Loading...."));
                ((DefaultTreeModel)this._tree.getModel()).insertNodeInto((MutableTreeNode)typeNode, (MutableTreeNode)node, node.getChildCount());
            }
        }
    }

    public Schema getSchema(JMutableTreeNode node) throws DBException {
        Schema schema = null;
        for (TreeNode n : node.getPath()) {
            JMutableTreeNode tn = (JMutableTreeNode)n;
            if (((JTreeCellData)tn.getUserObject()).getUserObject() == null) continue;
            String temp = (String)((JTreeCellData)tn.getUserObject()).getUserObject();
            if (temp.equals("MY")) {
                schema = this._db.getDefaultSchema();
                continue;
            }
            if (!temp.equals("SCHEMA")) continue;
            schema = this._db.getSchema(((JTreeCellData)tn.getUserObject()).getText());
        }
        return schema;
    }

    public String getType(JMutableTreeNode node) throws DBException {
        String ret = null;
        for (int i = node.getPath().length - 1; ret == null && i > -1; --i) {
            JMutableTreeNode tn = (JMutableTreeNode)node.getPath()[i];
            if (((JTreeCellData)tn.getUserObject()).getUserObject() == null) continue;
            String temp = (String)((JTreeCellData)tn.getUserObject()).getUserObject();
            if (temp.equals("OBJECT_TYPE")) {
                ret = ((JTreeCellData)tn.getUserObject()).getText();
                continue;
            }
            if (!temp.equals("SCHEMA") && !temp.equals("MY")) continue;
            ret = "SCHEMA";
        }
        return ret;
    }

    protected void populateChildren(JMutableTreeNode node, Object source) throws Exception {
        JMutableTreeNode o = (JMutableTreeNode)((DefaultTreeModel)this._tree.getModel()).getChild(node, 0);
        String nodeText = ((JTreeCellData)o.getUserObject()).getText();
        if (nodeText != null && nodeText.equals("Loading....")) {
            ((DefaultTreeModel)this._tree.getModel()).removeNodeFromParent((MutableTreeNode)o);
            String type = (String)((JTreeCellData)node.getUserObject()).getUserObject();
            String parentType = (String)((JTreeCellData)node.getUserObject()).getUserObject();
            Schema schema = this.getSchema(node);
            if (this._db == null) {
                try {
                    this._db = (OracleDatabase)this._dbComboBox.getCurrentDatabase();
                    this.buildTree();
                }
                catch (DBException e) {
                    e.printStackTrace();
                }
            }
            if (type.equals("MY")) {
                this.addTypes(node);
            } else if (type.equals("OTHERS")) {
                for (Schema s : this._db.listSchemas()) {
                    JMutableTreeNode subNode = this.createCheck(s.toString(), "SCHEMA");
                    ((DefaultTreeModel)this._tree.getModel()).insertNodeInto((MutableTreeNode)subNode, (MutableTreeNode)node, node.getChildCount());
                    this.addTypes(subNode);
                }
            } else {
                type = this.getType(node);
                String[] objects = this._db.listObjects(type, schema);
                if (objects.length > 0) {
                    for (int ii = 0; ii < objects.length; ++ii) {
                        JMutableTreeNode subNode = this.createCheck(objects[ii], type);
                        ((DefaultTreeModel)this._tree.getModel()).insertNodeInto((MutableTreeNode)subNode, (MutableTreeNode)node, node.getChildCount());
                    }
                }
            }
            this._tree.expandPath(this._tree.getSelectionPath());
        }
    }

    public void reset() {
        this.initTree();
    }
}

