/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.tree.TreeSelectionModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.DBObjectSelector;
import oracle.dbtools.raptor.metadata.MetaData;
import oracle.dbtools.raptor.metadata.MetaDataOptionsPanel;
import oracle.dbtools.raptor.utils.Translate;
import oracle.dbtools.raptor.utils.UIUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.db.DBException;
import oracle.jdeveloper.cm.dt.ConnectionArb;

public class ExportPanel
extends JPanel
implements ActionListener {
    public static final String EXPORT_NAME = "raptor.export";
    public static final int EXPORT_ACTION = Ide.findOrCreateCmdID((String)"raptor.export");
    private DBObjectSelector _objectSelector;
    private MetaData _meta = new MetaData();
    private MetaDataOptionsPanel _options;
    private static ExportPanel INSTANCE;

    private ExportPanel() {
        super(new BorderLayout());
        this._objectSelector = new DBObjectSelector();
        this.add((Component)this._objectSelector, "Center");
    }

    public void launch() {
        this._objectSelector = new DBObjectSelector();
        this._objectSelector.setMinimumSize(new Dimension(200, 400));
        this._objectSelector.setPreferredSize(new Dimension(200, 400));
        this._options = new MetaDataOptionsPanel();
        HelpSystem.getHelpSystem().registerTopic((JComponent)this._options, "f1_idedexportobjects_html");
        HelpSystem.getHelpSystem().registerTopic((JComponent)this._objectSelector, "f1_idedexportobjects_html");
        JPanel[] _panels = new JPanel[]{this._options, this._objectSelector};
        String[] _titles = new String[]{"Options", "Objects"};
        UIUtils.showPanelAsTabbedDialog(_panels, _titles, "Export", this);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("apply")) {
            try {
                this.export();
                if (e.getSource() instanceof JEWTDialog) {
                    JEWTDialog dlg = (JEWTDialog)e.getSource();
                    dlg.closeDialog(true);
                }
            }
            catch (DBException e1) {
                e1.printStackTrace();
            }
        }
    }

    private void export() throws DBException {
        if (this._objectSelector.getTree() == null || this._objectSelector.getTree().getSelectionModel().getSelectionCount() == 0) {
            MessageDialog.error((Component)this, (Object)"Nothing Selected to Export", (String)"Export", (String)"f1_exportddl_html");
            return;
        }
        if (this._options.getFileName() != null && this._options.getFileName().length() < 1) {
            MessageDialog.error((Component)this, (Object)"No File Specified", (String)"Export", (String)"f1_exportddl_html");
            return;
        }
        TreeSelectionModel model = this._objectSelector.getTree().getSelectionModel();
        int i = model.getSelectionCount();
        JMutableTreeNode root = (JMutableTreeNode)this._objectSelector.getTree().getModel().getRoot();
        Enumeration en = root.breadthFirstEnumeration();
        this._meta.reset();
        while (en.hasMoreElements()) {
            String name;
            JMutableTreeNode node = (JMutableTreeNode)en.nextElement();
            JTreeCellData cell = (JTreeCellData)node.getUserObject();
            boolean selected = cell.getCheckBoxState() == TriStateBoolean.TRUE;
            if (!selected || (name = cell.getText()).equals("Loading....") || this._objectSelector.getSchema(node) == null) continue;
            String schema = this._objectSelector.getSchema(node).getName();
            String type = this._objectSelector.getType(node);
            String s = (String)cell.getUserObject();
            if (s != null && s.equals("OBJECT_TYPE")) {
                this._meta.addObject(schema, type);
                continue;
            }
            this._meta.addObject(schema, type, name);
        }
        try {
            if (this._meta.getQueuedCount() > 0) {
                this._meta.setOutputStream(new FileOutputStream(this._options.getFileName()));
                this._meta.setConnection(this._objectSelector.getDatabase().getConnection());
                this._meta.setAlter(this._options.getAlter());
                this._meta.setByte(this._options.getByte());
                this._meta.setPretty(this._options.getPretty());
                this._meta.setSegments(this._options.getSegments());
                this._meta.setTerminator(this._options.getTerminator());
                this._meta.printDDL();
                this._meta.closeOutputStream();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void initMenu() {
        IdeAction action = IdeAction.get((int)EXPORT_ACTION, null, (String)Translate.translate("Export"), (String)IdeMainWindow.ACTION_CATEGORY_TOOLS, (Integer)new Integer(69), (ArrayResourceBundle)ConnectionArb.getInstance(), (int)301, null, (boolean)true);
        action.setEnabled(true);
        action.addController(ExportController.INSTANCE);
        Menubar menubar = Ide.getMenubar();
        JMenuItem firstActionMenu = menubar.createMenuItem((ToggleAction)action, 1.0f);
        menubar.add((Component)firstActionMenu, MenuManager.getJMenu((String)"Tools"));
    }

    private static ExportPanel getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ExportPanel();
        }
        return INSTANCE;
    }

    private static class ExportController
    implements Controller {
        private static Controller INSTANCE = new ExportController();

        private ExportController() {
        }

        public boolean handleEvent(IdeAction action, Context ctx) {
            if (action.getCommandId() == EXPORT_ACTION) {
                ExportPanel.getInstance().launch();
                return true;
            }
            return false;
        }

        public boolean update(IdeAction action, Context ctx) {
            if (action.getCommandId() == EXPORT_ACTION) {
                action.setEnabled(true);
                return true;
            }
            return false;
        }
    }
}

