/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.raptor.dialogs.export.ExportFormatPanel;
import oracle.dbtools.raptor.format.ResultsFormatter;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFilter;

public class FilePanel
extends JPanel
implements ActionListener {
    private static URL _lastUrl;
    private JTextField _fileName;
    private Component _parent;
    private JButton _browse;
    private String _defaultName = "";

    public FilePanel(Component parent) {
        this._parent = parent;
        this.setLayout(new BorderLayout());
        this._fileName = new JTextField(this._defaultName);
        this.add((Component)this._fileName, "Center");
        this._browse = new JButton("Browse...");
        this._browse.addActionListener(this);
        this.add((Component)this._browse, "East");
        int width = Double.valueOf(this.getPreferredSize().getWidth()).intValue();
        Dimension _size = new Dimension(width + 150, Double.valueOf(this.getPreferredSize().getHeight()).intValue());
        this.setSize(_size);
        this.setPreferredSize(_size);
        this.setMaximumSize(_size);
    }

    public void prompt() {
        URLChooser saveDialog = new URLChooser();
        saveDialog.setDefaultTitle("Choose File");
        saveDialog.clearChooseableURLFilters();
        if (this._parent instanceof ExportFormatPanel) {
            String _format = ((ExportFormatPanel)this._parent).getFormat();
            DefaultURLFilter all = new DefaultURLFilter(Translate.translate("All Files"), "");
            saveDialog.setURLFilter((URLFilter)all);
            if (_format.equals("CSV")) {
                saveDialog.setURLFilter(ResultsFormatter.CSV_FILTER);
            } else if (_format.equals("INSERT")) {
                saveDialog.setURLFilter(ResultsFormatter.SQL_FILTER);
            } else if (_format.equals("XML")) {
                saveDialog.setURLFilter(ResultsFormatter.XML_FILTER);
            } else if (_format.equals("LOADER")) {
                saveDialog.setURLFilter(ResultsFormatter.LDR_FILTER);
            } else if (_format.equals("TEXT")) {
                saveDialog.setURLFilter(ResultsFormatter.TXT_FILTER);
            }
        } else {
            saveDialog.setURLFilter(ResultsFormatter.SQL_FILTER);
        }
        if (_lastUrl == null) {
            try {
                String s = System.getProperty("user.home");
                File homeDir = new File(s);
                saveDialog.setSelectedURL(homeDir.toURL());
            }
            catch (MalformedURLException e) {}
        } else {
            saveDialog.setSelectedURL(_lastUrl);
        }
        File f = new File(saveDialog.getSelectedURL().getFile());
        if (f.isDirectory()) {
            try {
                saveDialog.setSelectedURL(new URL(saveDialog.getSelectedURL() + File.separator + this._defaultName));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (saveDialog.showSaveDialog(this._parent) == 0) {
            _lastUrl = saveDialog.getSelectedURL();
            this._fileName.setText(saveDialog.getSelectedURL().getFile());
        }
    }

    public void setDefaultFileName(String fileName) {
        this._defaultName = fileName;
        this._fileName.setText(fileName);
    }

    public String getFileName() {
        return this._fileName.getText();
    }

    public void actionPerformed(ActionEvent e) {
        this.prompt();
    }
}

