/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.celleditor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import oracle.dbtools.raptor.controls.celleditor.BFileEditPanel;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.util.ResourceUtils;

public class BFileInsertPanel
extends JPanel {
    static final String SELECT_DIR = Translate.translate("Select Directory..");
    static final String SELECT_FILE = Translate.translate("Select File..");
    List dirList = new ArrayList();
    JLabel dirLabel = new JLabel();
    JComboBox dirCombo = new JComboBox();
    JLabel fileLabel = new JLabel();
    JComboBox fileCombo = new JComboBox();
    JButton dirButton = new JButton();
    String dir = null;
    String file = null;

    public BFileInsertPanel(List dirList, String dir, String file) {
        this.dir = dir;
        this.file = file;
        this.setLayout(new GridBagLayout());
        this.createGUI();
        this.addListeners();
        this.fillDirCombo(dirList);
    }

    private void fillDirCombo(List dirList) {
        this.dirList = dirList;
        this.dirCombo.removeAllItems();
        if (dirList != null) {
            for (Object o : dirList) {
                this.dirCombo.addItem(o);
            }
        }
        this.dirCombo.addItem(SELECT_DIR);
        this.dirCombo.setSelectedIndex(this.dirCombo.getItemCount() - 1);
        if (this.dir != null) {
            this.dirCombo.setSelectedItem(this.dir);
        }
    }

    private void fillFileCombo(String[] fileList) {
        this.fileCombo.removeAllItems();
        if (fileList != null) {
            for (String s : fileList) {
                File file = new File(s);
                if (file.isDirectory()) continue;
                this.fileCombo.addItem(file.getName());
            }
        }
        this.fileCombo.addItem(SELECT_FILE);
        this.fileCombo.setSelectedIndex(this.fileCombo.getItemCount() - 1);
        if (this.file != null) {
            this.fileCombo.setSelectedItem(this.file);
        }
    }

    private void addListeners() {
        this.dirCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Object obj = e.getItem();
                if (e.getStateChange() == 1 && obj != null && !obj.equals(SELECT_DIR)) {
                    BFileEditPanel.DbDirectory dbdir = (BFileEditPanel.DbDirectory)obj;
                    File file = new File(dbdir.getPath());
                    if (file.exists()) {
                        BFileInsertPanel.this.fillFileCombo(file.list());
                    } else {
                        BFileInsertPanel.this.fillFileCombo(new String[0]);
                    }
                }
            }
        });
        this.fileCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
            }
        });
        this.dirButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
            }
        });
    }

    private void createGUI() {
        this.dirCombo.setRenderer(new MyComboBoxRenderer());
        ResourceUtils.resLabel((JLabel)this.dirLabel, (Component)this.dirCombo, (String)Translate.translate("&Directory :"));
        this.add((Component)this.dirLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)this.dirCombo, new GridBagConstraints(1, 0, 2, 1, 0.5, 0.0, 17, 1, new Insets(0, 5, 5, 0), 0, 0));
        ResourceUtils.resButton((AbstractButton)this.dirButton, (String)Translate.translate("&Browse"));
        ResourceUtils.resLabel((JLabel)this.fileLabel, (Component)this.fileCombo, (String)Translate.translate("&File :"));
        this.add((Component)this.fileLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.fileCombo.setEditable(true);
        this.add((Component)this.fileCombo, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
    }

    public static void main(String[] args) {
        BFileInsertPanel bd = new BFileInsertPanel(new ArrayList(), null, null);
        JFrame frm = new JFrame("Test");
        frm.setLayout(new GridBagLayout());
        frm.setDefaultCloseOperation(3);
        frm.getContentPane().setLayout(new GridLayout(1, 1));
        frm.getContentPane().add(bd);
        frm.setSize(bd.getPreferredSize());
        frm.setVisible(true);
    }

    public String getDir() {
        Object obj = this.dirCombo.getSelectedItem();
        if (obj != null && obj instanceof BFileEditPanel.DbDirectory) {
            return ((BFileEditPanel.DbDirectory)obj).getName();
        }
        return null;
    }

    public String getFile() {
        Object obj = this.fileCombo.getSelectedItem();
        if (obj != null && !obj.equals(SELECT_FILE)) {
            return obj.toString();
        }
        return null;
    }

    class MyComboBoxRenderer
    extends BasicComboBoxRenderer {
        MyComboBoxRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
                if (-1 < index) {
                    if (value instanceof BFileEditPanel.DbDirectory) {
                        BFileEditPanel.DbDirectory dbDir = (BFileEditPanel.DbDirectory)value;
                        list.setToolTipText("Owner=" + dbDir.getOwner() + ", Path=" + dbDir.getPath());
                    } else {
                        list.setToolTipText(value.toString());
                    }
                }
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setFont(list.getFont());
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }
}

