/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.cellrenderers;

import java.awt.Component;
import java.util.HashMap;
import java.util.Stack;
import javax.swing.JTable;
import oracle.dbtools.raptor.controls.cellrenderers.ICellRenderer;

public class CellRenderingFactory {
    private static HashMap<Class, Stack<ICellRenderer>> renderers = new HashMap();

    public static void registerCellRenderer(Class cls, ICellRenderer renderer) {
        if (renderers.get(cls) == null) {
            renderers.put(cls, new Stack());
        }
        renderers.get(cls).push(renderer);
    }

    public static String getText(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String ret = null;
        if (value != null && renderers.get(value.getClass()) != null) {
            for (ICellRenderer renderer : renderers.get(value.getClass())) {
                try {
                    ret = renderer.getText(table, value, isSelected, hasFocus, row, column);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return ret;
    }

    public static Component getComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component ret = null;
        if (value != null && renderers.get(value.getClass()) != null) {
            for (ICellRenderer renderer : renderers.get(value.getClass())) {
                try {
                    ret = renderer.getComponent(table, value, isSelected, hasFocus, row, column);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return ret;
    }
}

