/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.cellrenderers;

import java.awt.Component;
import java.sql.Date;
import java.text.MessageFormat;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import oracle.dbtools.raptor.controls.cellrenderers.CellRenderingFactory;
import oracle.dbtools.raptor.models.ResultSetTableModel;
import oracle.dbtools.raptor.query.Column;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.dbtools.raptor.utils.Translate;

public class DefaultCellRenderer
extends DefaultTableCellRenderer {
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component ret = CellRenderingFactory.getComponent(table, value, isSelected, hasFocus, row, column);
        if (ret != null) {
            return ret;
        }
        String rendererValue = CellRenderingFactory.getText(table, value, isSelected, hasFocus, row, column);
        JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        TableModel tm = table.getModel();
        ResultSetTableModel rsTm = null;
        int type = 0;
        HashMap columns = null;
        Column col = null;
        if (tm instanceof ResultSetTableModel) {
            String colName = table.getTableHeader().getColumnModel().getColumn(column).getHeaderValue().toString();
            rsTm = (ResultSetTableModel)tm;
            type = rsTm.getType(column);
            if (rsTm.getQuery() != null) {
                columns = rsTm.getQuery().getColValues();
            }
            if (rsTm != null && rsTm.getQuery() != null) {
                for (int i = 0; i < rsTm.getQuery().getCols().size(); ++i) {
                    if (!colName.equals(Translate.translate(rsTm.getQuery().getCols().get(i).getName()))) continue;
                    col = rsTm.getQuery().getCols().get(i);
                }
            }
        }
        switch (type) {
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                label.setHorizontalAlignment(4);
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                label.setAlignmentX(0.0f);
                break;
            }
            default: {
                label.setAlignmentX(0.0f);
            }
        }
        if (rendererValue != null) {
            this.setText(rendererValue);
        } else {
            String val = DataTypesUtil.stringValue(value, rsTm.getConn());
            this.setText(val == null ? "" : val);
        }
        if (col != null && value != null) {
            label.setAlignmentX(col.getAlign());
            label.setAlignmentY(col.getVAlign());
            if (!col.getFormat().equals("")) {
                try {
                    if (value instanceof Date) {
                        this.setValue(MessageFormat.format(col.getFormat(), (Date)value));
                    } else {
                        this.setValue(MessageFormat.format(col.getFormat(), value));
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return label;
    }
}

