/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.multidisplay;

import java.awt.Point;
import java.sql.Connection;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import oracle.dbtools.raptor.controls.multidisplay.IMultiDisplay;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultiDisplayAdapter
implements IMultiDisplay {
    protected Query _query;
    protected String _connName;
    protected Connection _conn;
    protected JScrollPane _sp;
    private HashMap<String, Object> _bindMap;
    protected boolean _dirty = false;

    @Override
    public JComponent getScrollableUI() {
        if (this._sp == null) {
            this._sp = new JScrollPane(this.getUI());
        }
        return this._sp;
    }

    @Override
    public void setBindMap(HashMap<String, Object> binds) {
        if (this._bindMap == null) {
            this._bindMap = new HashMap();
        }
        for (String name : binds.keySet()) {
            Object o1 = this._bindMap == null ? null : this._bindMap.get(name);
            Object o2 = binds.get(name);
            if (this._bindMap != null && ModelUtil.areEqual((Object)this._bindMap.get(name), (Object)binds.get(name))) continue;
            this._dirty = true;
            this._bindMap.putAll(binds);
        }
    }

    @Override
    public HashMap<String, Object> getBindMap() {
        return this._bindMap;
    }

    @Override
    public void refresh() {
        this.refresh(false);
    }

    @Override
    public void populateToolBar(Toolbar toolbar) {
    }

    @Override
    public boolean update(IdeAction action, Context ctx) {
        return false;
    }

    @Override
    public void setQuery(Query query) {
        this._query = query;
    }

    @Override
    public Query getQuery() {
        this._dirty = true;
        return this._query;
    }

    @Override
    public void setConn(Connection conn) {
        if (!ModelUtil.areEqual((Object)this._conn, (Object)conn)) {
            this._conn = conn;
            this._dirty = true;
        }
    }

    @Override
    public void setConnName(String conn) {
        if (!ModelUtil.areEqual((Object)this._connName, (Object)conn)) {
            this._connName = conn;
            this._dirty = true;
        }
    }

    public String getConnName() {
        return this._connName;
    }

    public Connection getConnection() {
        return this._conn == null ? Connections.getInstance().getConnection(this._connName) : this._conn;
    }

    @Override
    public HashMap<String, Object> getBinds(Point p) {
        return null;
    }

    public void setDirty(boolean dirty) {
        this._dirty = dirty;
    }

    public boolean isDirty() {
        return this._dirty;
    }
}

