/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.multidisplay;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.ArrayList;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.CustomTabbedPane;
import oracle.dbtools.raptor.controls.multidisplay.MultiDisplayModel;
import oracle.dbtools.raptor.controls.multidisplay.MultiDisplayPanel;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.utils.SimpleIdeCore;
import oracle.dbtools.raptor.utils.UIUtils;
import oracle.jdbc.driver.OracleDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiDisplayTest {
    private static Connection CONN;

    public static void main(String[] args) throws Exception {
        DriverManager.registerDriver((Driver)new OracleDriver());
        String url = "jdbc:oracle:thin:@localhost:1521:xe";
        CONN = DriverManager.getConnection(url, "klrice", "klrice");
        CONN.setAutoCommit(false);
        SimpleIdeCore.initIde();
        ArrayList<MultiDisplayModel> models = new ArrayList<MultiDisplayModel>();
        models.add(MultiDisplayTest.createSingleModel("select * from all_objects where object_name like 'A%'"));
        models.add(MultiDisplayTest.createSingleModel("select * from all_objects where object_name like 'B%'"));
        models.add(MultiDisplayTest.createDoubleModel("select * from all_objects where object_name like 'C%'", "select * from all_objects where object_name like 'D%'", "select * from all_objects where object_name like 'E%'", "select * from all_objects where object_name like 'F%'"));
        models.add(MultiDisplayTest.createChildModel("select object_name name,ao.*from all_objects ao where object_name like 'C%'", "select * from all_objects where object_name = :NAME"));
        MultiDisplayTest.showModels(models);
    }

    public static void showModels(ArrayList<MultiDisplayModel> models) throws Exception {
        JPanel[] panels = new MultiDisplayPanel[models.size()];
        String[] tabs = new String[models.size()];
        int i = 0;
        for (MultiDisplayModel model : models) {
            tabs[i] = "Test:" + i;
            panels[i] = new MultiDisplayPanel(model);
            ++i;
        }
        UIUtils.showPanelAsTabbedDialog(panels, tabs, "Test", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JEWTDialog dialog = (JEWTDialog)e.getSource();
                CustomTabbedPane c = (CustomTabbedPane)dialog.getContent();
                MultiDisplayPanel panel = (MultiDisplayPanel)c.getActivePanel();
                UIUtils.makeTitledBorder(panel, "T:" + System.currentTimeMillis());
                panel.update(true);
            }
        });
        System.exit(0);
    }

    public static MultiDisplayModel createSingleModel(String sql) {
        MultiDisplayModel model = new MultiDisplayModel();
        Query query = new Query();
        query.setSql(sql);
        ArrayList<Query> queries = new ArrayList<Query>();
        queries.add(query);
        model.setQueries(queries);
        model.setConnection(CONN);
        return model;
    }

    public static MultiDisplayModel createDoubleModel(String sql, String sql2, String sql3, String sql4) {
        MultiDisplayModel model = new MultiDisplayModel();
        Query query = new Query();
        query.setSql(sql);
        ArrayList<Query> mainQ = new ArrayList<Query>();
        mainQ.add(query);
        model.setQueries(mainQ);
        query = new Query();
        query.setSql(sql2);
        model.addDualQuery("Bottom1:" + System.currentTimeMillis(), null, query);
        query = new Query();
        query.setSql(sql3);
        model.addDualQuery("Bottom2:" + System.currentTimeMillis(), null, query);
        query = new Query();
        query.setSql(sql4);
        model.addDualQuery("Bottom3:" + System.currentTimeMillis(), null, query);
        model.setConnection(CONN);
        return model;
    }

    public static MultiDisplayModel createChildModel(String sql, String sql2) {
        MultiDisplayModel model = new MultiDisplayModel();
        Query query = new Query();
        query.setSql(sql);
        ArrayList<Query> queries = new ArrayList<Query>();
        queries.add(query);
        model.setQueries(queries);
        query = new Query();
        query.setSql(sql2);
        model.addSubQuery("Sub1:" + System.currentTimeMillis(), null, query);
        Query query2 = new Query();
        query2.setSql("select :NAME from dual");
        model.addSubQuery("Sub2:" + System.currentTimeMillis(), null, query2);
        model.setConnection(CONN);
        return model;
    }
}

