/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.Child;
import oracle.dbtools.raptor.controls.PropertyPanel;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.dialogs.actions.ActionHelpProvider;
import oracle.dbtools.raptor.dialogs.actions.ActionPromptPanel;
import oracle.dbtools.raptor.dialogs.actions.ActionSql;
import oracle.dbtools.raptor.dialogs.actions.ActionSqlPanel;
import oracle.dbtools.raptor.dialogs.actions.ObjectAction;
import oracle.dbtools.raptor.dialogs.actions.XMLBasedObjectAction;
import oracle.dbtools.raptor.utils.CMHelper;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.Log;
import oracle.dbtools.raptor.utils.Translate;
import oracle.dbtools.raptor.utils.UIUtils;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.Assert;
import oracle.javatools.db.SchemaObject;
import oracle.jdeveloper.cm.dt.CmUtil;
import oracle.jdeveloper.cm.dt.ConnectionBrowsable;
import oracle.jdeveloper.cm.dt.browser.CBBaseFolder;
import oracle.jdeveloper.cm.dt.browser.jdbc.OCBBaseNode;
import oracle.jdeveloper.cm.dt.ui.DBObjectOnePageDialog;
import oracle.jdevimpl.cm.dt.browser.jdbc.JdbcBrowser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicObjectModifier
implements ContextMenuListener,
Controller,
ActionListener {
    private ActionHelpProvider _helpProvider = new ActionHelpProvider(this);
    protected PropertyPanel _panel;
    protected DBObjectOnePageDialog _one;
    protected SchemaObject _schemaObject;
    protected String _title;
    private DBObject _dbObject = null;
    private ObjectAction _currAction;
    private Node _currNode;
    private boolean devMode = false;
    private DBUtil _dbUtil = new DBUtil();
    private static BasicObjectModifier _basicObjectModifier = null;
    private ActionPromptPanel _actionPanel;
    private ActionSqlPanel _actionSqlPanel;
    private XMLBasedObjectAction _xmlActions;

    private BasicObjectModifier() {
        try {
            this._xmlActions = XMLBasedObjectAction.getInstance();
            this._xmlActions.setController(this);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e);
        }
    }

    public static synchronized BasicObjectModifier getInstance() {
        if (_basicObjectModifier == null) {
            _basicObjectModifier = new BasicObjectModifier();
        }
        return _basicObjectModifier;
    }

    public void init() {
        this._actionPanel = new ActionPromptPanel();
        this._actionSqlPanel = new ActionSqlPanel(this);
    }

    public ObjectAction getCurrentAction() {
        return this._currAction;
    }

    public ArrayList<JComponent> getPrompts() {
        return this._actionPanel.getTextValues();
    }

    public HashMap<String, Object> getDictionary() {
        return this._actionPanel.getDictionary();
    }

    public ActionPromptPanel getPromptPanel() {
        return this._actionPanel;
    }

    public ActionSqlPanel getSqlPanel() {
        return this._actionSqlPanel;
    }

    public void launch(Node node, IdeAction action) {
        this._dbObject = new DBObject(node);
        this._currAction = this._xmlActions.findCurrentAction(action);
        if (this._currAction == null) {
            return;
        }
        if (this._currAction.getClassName() != null && !this._currAction.getClassName().equals("")) {
            try {
                this.getClass();
                AbstractMenuAction actionClass = (AbstractMenuAction)Class.forName(this._currAction.getClassName()).newInstance();
                actionClass.setArgs(this._currAction.getClassArgs());
                actionClass.setDBObject(this._dbObject);
                actionClass.launch();
            }
            catch (Exception e) {
                e.printStackTrace();
                ExceptionHandler.handleException(e);
            }
        } else {
            this.invokeActionPanel(this);
        }
    }

    public void invokeActionPanel(ActionListener l) {
        if (this._actionPanel == null) {
            this._actionPanel = new ActionPromptPanel();
        }
        if (this._actionSqlPanel == null) {
            this._actionSqlPanel = new ActionSqlPanel(this);
        }
        this._actionSqlPanel.update();
        this._actionPanel.init(this._currAction, this._dbObject);
        UIUtils.showPanelAsTabbedDialog(new JPanel[]{this._actionPanel, this._actionSqlPanel}, new String[]{"Define", "SQL"}, this._currAction.getTitle(), l, this._helpProvider);
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Assert.startTiming((String)this.getClass().getName(), (String)".menuWillShow", (boolean)false);
        Context context = contextMenu.getContext();
        Node node = context.getNode();
        if (node != null) {
            this._dbObject = new DBObject(node);
            this._currNode = node;
            if (this._dbObject.getObjectType().equals("SYNONYM")) {
                contextMenu.removeAll();
            }
            if (this._dbObject.getObjectType().equals("RECYCLEBIN")) {
                contextMenu.removeAll();
            }
            Assert.print((String)("Finding Context Menu for:" + this._dbObject.getObjectType() + "\n"));
            this._xmlActions.addToMenu(contextMenu, this._dbObject);
            Assert.endTiming((String)this.getClass().getName(), (String)".menuWillShow", (String)this.getClass().getName(), (boolean)false);
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        context.getNode();
        this.launch(context.getNode(), action);
        return true;
    }

    public boolean update(IdeAction action, Context context) {
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.processAction(e)) {
            this.postProcessAction();
        }
    }

    public final boolean processAction(ActionEvent e) {
        ActionSql actionSql = new ActionSql(this._currAction.getSql(), this.getDictionary());
        actionSql.processSql(this.getPrompts(), this._currAction.getValues());
        String sql = actionSql.manualSubs(actionSql.getSql(), this.getDictionary());
        DBUtil.getInstance().setRaiseError(true);
        boolean processed = false;
        if (DBUtil.getInstance().execute(this._dbObject.getDatabase().getConnectionName(), sql, actionSql.getBinds())) {
            Log.log(actionSql.getSql());
            ((JEWTDialog)e.getSource()).closeDialog(false);
            this.processConfirm();
            processed = true;
        }
        return processed;
    }

    private void postProcessAction() {
        CBBaseFolder folder;
        URL url;
        JdbcBrowser browser;
        if (this._currAction.isRemoveFromParent()) {
            browser = this.getJdbcBrowser();
            url = this._currNode.getURL();
            folder = browser.getNodeByType(CmUtil.getSchema((URL)url), CmUtil.getDbObjectType((URL)url));
            folder.remove((Element)this._currNode);
            UpdateMessage.fireChildRemoved((Subject)folder, (Element)this._currNode);
        }
        if (this._currAction.getReloadParent()) {
            browser = this.getJdbcBrowser();
            url = this._currNode.getURL();
            folder = browser.getNodeByType(CmUtil.getSchema((URL)url), CmUtil.getDbObjectType((URL)url));
            folder.refresh();
            UpdateMessage.fireStructureChanged((Subject)folder);
        }
        if (this._currAction.getReload()) {
            Node elem;
            Object object = elem = this._currNode instanceof Child ? ((Child)this._currNode).getOwningElement() : this._currNode;
            if (elem instanceof OCBBaseNode) {
                ((OCBBaseNode)elem).refresh();
                UpdateMessage.fireStructureChanged((Subject)((OCBBaseNode)elem));
            }
        }
    }

    public void processConfirm() {
        if (this._panel == null) {
            this._panel = new PropertyPanel();
        }
        this._panel.removeAll();
        ActionSql confirmSql = new ActionSql();
        String title = this._currAction.getConfirmTitle();
        title = title == null ? Translate.translate("Success ") : confirmSql.manualSubs(title, this.getDictionary());
        String confirm = this._currAction.getTitle() + " Succeeded";
        if (this._currAction.getConfirm() != null && !this._currAction.getConfirm().equals("")) {
            confirm = confirmSql.manualSubs(this._currAction.getConfirm(), this.getDictionary());
            confirm = confirmSql.processPrompts(confirm, this.getPrompts(), this._currAction.getValues());
            if (this._currAction.getConfirmSql() != null && !this._currAction.getConfirmSql().equals("")) {
                confirmSql.setSql(this._currAction.getConfirmSql());
                confirmSql.setDict(this.getDictionary());
                confirmSql.processSql();
                HashMap<String, Object> results = this._dbUtil.executeReturnHashMap(this._dbObject.getDatabase().getConnectionName(), confirmSql.getSql(), confirmSql.getBinds());
                confirm = confirmSql.manualSubs(confirm, results);
            }
        }
        this._panel.addSingleComp(confirm);
        UIUtils.showPanelAsDialog(this._panel, title, null, 1);
    }

    private JdbcBrowser getJdbcBrowser() {
        return JdbcBrowser.getBrowser((ConnectionBrowsable)CMHelper.getConnectionNode(this._dbObject.getDatabase().getConnectionName()));
    }
}

