/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs;

import java.lang.ref.WeakReference;
import oracle.ide.Context;
import oracle.ide.wizard.Wizard;
import oracle.javatools.db.Database;
import oracle.jdeveloper.cm.ds.db.DBUtil;
import oracle.jdeveloper.cm.dt.CmUtil;
import oracle.jdeveloper.cm.dt.ConnectionNode;
import oracle.jdeveloper.cm.dt.DatabaseConnectionNode;
import oracle.jdeveloper.cm.dt.browser.ConnectionBrowser;
import oracle.jdeveloper.cm.dt.wizard.DBWizardFactory;
import oracle.jdeveloper.cm.dt.wizard.DBWizardFactoryRegistry;
import oracle.jdevimpl.cm.dt.browser.jdbc.JdbcBrowser;

public abstract class DBWizard
extends Wizard {
    private ContextCache _lastContext = new ContextCache();

    public abstract String getDBObjectType();

    public boolean isAvailable(Context context) {
        boolean result = false;
        ConnectionNode node = CmUtil.getConnectionNode((Context)context);
        if (node instanceof DatabaseConnectionNode && node.isOpen()) {
            Boolean available = this._lastContext.isAvailable(context);
            if (available != null) {
                result = available;
            } else {
                ConnectionBrowser browser = node.getConnectionBrowser();
                if (browser instanceof JdbcBrowser) {
                    Database db = ((JdbcBrowser)browser).getDatabase();
                    DBWizardFactory factory = DBWizardFactoryRegistry.getDBWizardFactory((Database)db);
                    result = factory != null && factory.canCreateDBObject(context, db, this.getDBObjectType());
                }
                this._lastContext.setAvailable(context, result);
            }
        }
        return result;
    }

    public boolean invoke(Context context) {
        boolean result = false;
        ConnectionNode node = CmUtil.getConnectionNode((Context)context);
        if (node != null) {
            node.ensureOpen();
            ConnectionBrowser browser = node.getConnectionBrowser();
            if (browser instanceof JdbcBrowser) {
                Database db = ((JdbcBrowser)browser).getDatabase();
                DBWizardFactory factory = DBWizardFactoryRegistry.getDBWizardFactory((Database)db);
                if (factory != null) {
                    result = factory.createDBObject(context, db, this.getDBObjectType());
                } else {
                    DBWizardFactoryRegistry.showUnsupportedDBError((String)DBUtil.getDisplayName((String)this.getDBObjectType()), (String)node.getShortLabel());
                }
            }
        }
        return result;
    }

    private static class ContextCache {
        private WeakReference _ref;
        private Boolean _available;

        private ContextCache() {
        }

        Boolean isAvailable(Context ctx) {
            Context oldContext;
            Context context = oldContext = this._ref != null ? (Context)this._ref.get() : null;
            if (oldContext != null && oldContext.equals((Object)ctx)) {
                return this._available;
            }
            return null;
        }

        void setAvailable(Context ctx, boolean available) {
            this._ref = new WeakReference<Context>(ctx);
            this._available = available;
        }
    }
}

