/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.cm.dt.ConnectionArb;

public class SQLErrorDialog
extends JPanel
implements ActionListener {
    private BorderLayout layMain = new BorderLayout();
    private JMultiLineLabel lblMsg = new JMultiLineLabel();
    private JButton btnBack = new JButton();
    private JButton btnForward = new JButton();
    private JPanel pnlBottom = new JPanel();
    private GridBagLayout layBottom = new GridBagLayout();
    private JPanel pnlButtons = new JPanel();
    private GridLayout layButtons = new GridLayout();
    private Component glue = Box.createGlue();
    private String _sql;
    private int _errOffset;
    protected List _errs;
    private int _idx;
    private static final String BACK_CMD = "BACK";
    private static final String FWD_CMD = "FWD";

    protected SQLErrorDialog() {
    }

    public void setSql(String sql) {
        this._sql = sql;
    }

    public void setOffset(int offset) {
        this._errOffset = offset;
    }

    private void setError(SQLException error) {
        ArrayList<SQLException> errs = new ArrayList<SQLException>();
        while (error != null) {
            errs.add(error);
            error = error.getNextException();
        }
        this.setErrors(errs);
    }

    public static void showErrorDialog(Component parent, String title, SQLException error, String sql, int offset) {
        SQLErrorDialog panel = new SQLErrorDialog();
        panel.setSql(sql);
        panel.setOffset(offset);
        panel.setError(error);
        panel.runErrorDialog(parent, title, null);
    }

    public static void showErrorDialog(Component parent, String title, SQLException error) {
        SQLErrorDialog panel = new SQLErrorDialog();
        panel.setError(error);
        panel.runErrorDialog(parent, title, null);
    }

    protected void runErrorDialog(Component parent, String title, String helpTopic) {
        MessageDialog.error((Component)parent, (Object)this, (String)title, (String)helpTopic);
    }

    protected boolean runConfirmDialog(Component parent, String title, String helpTopic) {
        return MessageDialog.confirm((Component)parent, (Object)this, (String)title, (String)helpTopic, (boolean)false, (String)"OK", (String)"Cancel");
    }

    public void actionPerformed(ActionEvent ev) {
        String cmd = ev.getActionCommand();
        if (BACK_CMD.equals(cmd)) {
            --this._idx;
            this._update();
        } else if (FWD_CMD.equals(cmd)) {
            ++this._idx;
            this._update();
        }
    }

    protected void setErrors(List errs) {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this._errs = errs;
        this._idx = this._errs.size() > 0 ? 0 : -1;
        this.pnlBottom.setVisible(this._errs.size() > 1);
        this._update();
    }

    private void _update() {
        this.btnBack.setEnabled(this._idx > 0);
        this.btnForward.setEnabled(this._idx < this._errs.size() - 1);
        Exception err = this._idx != -1 ? (Exception)this._errs.get(this._idx) : null;
        this.updateExceptionComponent(err);
    }

    protected void updateExceptionComponent(Exception e) {
        SQLException err = (SQLException)e;
        String errMsg = err.getLocalizedMessage();
        if (errMsg != null && !errMsg.endsWith("\n")) {
            errMsg = errMsg + '\n';
        }
        String msg = null;
        if (this._sql != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(ConnectionArb.format((int)515, (Object)errMsg, (Object)Integer.toString(err.getErrorCode())));
            sb.setLength(sb.indexOf("Vendor") - 1);
            sb.append("\n");
            if (this._errOffset > 0) {
                String[] lines = this._sql.substring(0, this._errOffset).split("\n");
                int col = lines[lines.length - 1].length();
                int line = lines.length;
                sb.append("Error at Line:" + line + " Column:" + col);
            }
            msg = sb.toString();
        } else {
            msg = err != null ? ConnectionArb.format((int)515, (Object)errMsg, (Object)Integer.toString(err.getErrorCode())) : ConnectionArb.getString((int)516);
        }
        this.lblMsg.setText(msg);
        this.lblMsg.setMaximumRows(3);
    }

    protected Component getExceptionComponent() {
        this.lblMsg.setPreferredAspectRatio(5.0f);
        return this.lblMsg;
    }

    private void jbInit() {
        this.setLayout(this.layMain);
        ResourceUtils.resButton((AbstractButton)this.btnBack, (String)ConnectionArb.getString((int)517));
        this.btnBack.setActionCommand(BACK_CMD);
        this.btnBack.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this.btnForward, (String)ConnectionArb.getString((int)518));
        this.btnForward.setActionCommand(FWD_CMD);
        this.btnForward.addActionListener(this);
        this.pnlBottom.setLayout(this.layBottom);
        this.pnlBottom.setBorder(BorderFactory.createEmptyBorder(15, 0, 0, 0));
        this.pnlButtons.setLayout(this.layButtons);
        this.layButtons.setColumns(2);
        this.layButtons.setHgap(5);
        this.add(this.getExceptionComponent(), "Center");
        this.pnlButtons.add((Component)this.btnBack, null);
        this.pnlButtons.add((Component)this.btnForward, null);
        this.pnlBottom.add(this.glue, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlBottom.add((Component)this.pnlButtons, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.pnlBottom, "South");
    }
}

