/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.text.Document;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.controls.PropertyPanel;
import oracle.dbtools.raptor.controls.RadioGroupPanel;
import oracle.dbtools.raptor.dialogs.actions.ActionSql;
import oracle.dbtools.raptor.dialogs.actions.ObjectAction;
import oracle.dbtools.raptor.models.SQLComboxModel;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.LineHighlightPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionPromptPanel
extends PropertyPanel {
    private HashMap<String, Object> _dict = new HashMap();
    private ArrayList<JComponent> _textValues = new ArrayList();
    private ObjectAction _action;
    private DBObject _dbObject;
    private FocusListener _focusListener = new FocusListener(){

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            if (!(e.getSource() instanceof JComboBox)) {
                ActionPromptPanel.this.processReloadablePrompts((JComponent)e.getSource());
            }
        }
    };
    private ItemListener _comboListener = new ItemListener(){

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                ActionPromptPanel.this.processReloadablePrompts((JComponent)e.getSource());
            }
        }
    };

    public void evalDefaults() {
        ActionSql actionSql = new ActionSql();
        actionSql.setDict(this._dict);
        for (int i = 0; i < this._action.getPrompts().size(); ++i) {
            if (this._action.getDefaults().get(i) == null) continue;
            String def = null;
            if (this._action.getDefaults().get(i).toLowerCase().indexOf("static:") == 0) {
                def = actionSql.manualSubs(this._action.getDefaults().get(i).substring(7), this._dict);
            } else if (this._action.getDefaults().get(i) != null && !this._action.getDefaults().get(i).equals("")) {
                actionSql.setSql(this._action.getDefaults().get(i));
                actionSql.processSql(this.getTextValues(), this._action.getValues());
                def = DBUtil.getInstance().executeReturnOneCol(this._dbObject.getDatabase().getConnectionName(), actionSql.getSql(), actionSql.getBinds());
            } else {
                def = "";
            }
            if (this._textValues.get(i) instanceof RadioGroupPanel) {
                ((RadioGroupPanel)this._textValues.get(i)).setSelectedValue(def);
                continue;
            }
            if (this._textValues.get(i) instanceof JTextField) {
                ((JTextField)this._textValues.get(i)).setText(def);
                continue;
            }
            if (this._textValues.get(i) instanceof JComboBox) {
                ((JComboBox)this._textValues.get(i)).setSelectedItem(def);
                continue;
            }
            if (!(this._textValues.get(i) instanceof JScrollPane)) continue;
            ((BasicEditorPane)((JViewport)((JScrollPane)this._textValues.get(i)).getComponent(0)).getComponent(0)).setText(def);
        }
    }

    public void init(ObjectAction action, DBObject dbObject) {
        this._action = action;
        this._dbObject = dbObject;
        this._textValues.clear();
        this.removeAll();
        this._dict = this._dbObject.getDictionary();
        if (dbObject.getDatabase() != null) {
            this.addComp("Connection", new JLabel(dbObject.getDatabase().getConnectionName()));
        }
        if (dbObject.getSchemaName() != null && !dbObject.getSchemaName().equals("")) {
            this.addComp("Schema", new JLabel(dbObject.getSchemaName()));
        }
        if (dbObject.getObjectName() != null && !dbObject.getObjectName().equals("")) {
            this.addComp("Object Name", new JLabel(dbObject.getObjectName()));
        }
        JComponent promptValue = null;
        String promptType = null;
        String promptValues = null;
        if (action.getPrompts() == null || action.getPrompts().size() == 0) {
            this.addSingleComp(Translate.translate("Confirm Action") + action.getTitle());
        } else {
            for (int i = 0; i < action.getPrompts().size(); ++i) {
                promptType = action.getPromptTypes().get(i) == null ? "" : action.getPromptTypes().get(i);
                promptValues = action.getValues().get(i) == null ? "" : action.getValues().get(i);
                promptValue = null;
                if (promptType.equalsIgnoreCase("confirm")) {
                    this.addSingleComp(action.getPrompts().get(i));
                    promptValue = new JLabel("");
                } else if (promptType.equalsIgnoreCase("radio")) {
                    RadioGroupPanel radio = new RadioGroupPanel(action.getValues().get(i));
                    promptValue = radio;
                } else if (promptType.equalsIgnoreCase("codearea")) {
                    BasicEditorPane taSql = EditorFactory.createIdeEditorPane();
                    taSql.setPreferredSize(new Dimension(300, 200));
                    taSql.setText("");
                    taSql.setDocument((Document)new BasicDocument("foo.plsql"));
                    taSql.installPlugin((EditorPlugin)new LineHighlightPlugin());
                    taSql.setText("");
                    taSql.setEditable(true);
                    JScrollPane sp = new JScrollPane((Component)taSql, 22, 32);
                    sp.setPreferredSize(taSql.getPreferredSize());
                    sp.setSize(sp.getPreferredSize());
                    promptValue = sp;
                } else if (promptType.equalsIgnoreCase("check")) {
                    promptValue = new JCheckBox();
                    ((JCheckBox)promptValue).addItemListener(this._comboListener);
                } else if (promptValues.toUpperCase().indexOf("STATIC:") == 0) {
                    promptValue = new JComboBox<String>(action.getValues().get(i).substring(7).split(":"));
                    ((JComboBox)promptValue).addItemListener(this._comboListener);
                } else if (promptValues.toUpperCase().indexOf("SELECT") == 0) {
                    String sql = action.getValues().get(i);
                    ActionSql actionSql = new ActionSql(action.getValues().get(i), this._dict);
                    actionSql.processSql(this.getTextValues(), this._action.getValues());
                    promptValue = new JComboBox(new SQLComboxModel(dbObject.getDatabase().getConnectionName(), actionSql.getSql(), actionSql.getBinds()));
                    ((JComboBox)promptValue).addItemListener(this._comboListener);
                } else {
                    promptValue = new JTextField(25);
                }
                promptValue.addFocusListener(this._focusListener);
                if (promptValue != null) {
                    this._textValues.add(promptValue);
                }
                if (promptType.equalsIgnoreCase("confirm")) continue;
                this.addComp(action.getPrompts().get(i), this._textValues.get(i));
            }
        }
        this.evalDefaults();
        this.setSize(this.getPreferredSize());
        this.setBackground(UIManager.getColor("EWTDialog.background"));
    }

    public void processReloadablePrompts(JComponent item) {
        int idx = -1;
        for (int ii = 0; ii < this._textValues.size(); ++ii) {
            if (!item.equals(this._textValues.get(ii))) continue;
            idx = ii;
        }
        for (int i = 0; i < this._action.getPrompts().size(); ++i) {
            if (this._action.getValues().get(i).toUpperCase().trim().indexOf("SELECT") != 0 || this._action.getReloadPrompts().get(i) == null || this._action.getReloadPrompts().get(i).indexOf(idx + "") <= 0) continue;
            ActionSql actionSql = new ActionSql(this._action.getValues().get(i), this._dict);
            actionSql.processSql(this.getTextValues(), this._action.getValues());
            ((JComboBox)this._textValues.get(i)).setModel(new SQLComboxModel(this._dbObject.getDatabase().getConnectionName(), actionSql.getSql(), actionSql.getBinds()));
        }
    }

    public void update() {
    }

    public ArrayList<JComponent> getTextValues() {
        return this._textValues;
    }

    public HashMap<String, Object> getDictionary() {
        return this._dict;
    }
}

