/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.text.JTextComponent;
import oracle.dbtools.raptor.controls.RadioGroupPanel;
import oracle.javatools.editor.BasicEditorPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionSql {
    private HashMap<String, Object> _dict;
    private String _origSql;
    private String _cleanedSql;
    private HashMap<String, Object> _binds;

    public ActionSql() {
    }

    public ActionSql(String sql, HashMap dict) {
        this._origSql = sql;
        this._dict = dict;
    }

    public String manualSubs(String s, HashMap<String, Object> subs) {
        String ret = s;
        for (String val : subs.keySet()) {
            if (ret.toUpperCase().indexOf(val.toUpperCase()) <= 0) continue;
            ret = this.subHashMark(ret, val, subs.get(val));
        }
        return ret;
    }

    public String directSubstuitions(String s) {
        return this.manualSubs(s, this._dict);
    }

    private void findNamedBinds() {
        Iterator<String> iter = this._dict.keySet().iterator();
        String val = null;
        while (iter.hasNext()) {
            val = iter.next();
            if (this._cleanedSql.toLowerCase().indexOf(":" + val.toLowerCase()) <= 0) continue;
            this._binds.put(val, this._dict.get(val));
        }
    }

    public String processPrompts(String s, ArrayList<JComponent> prompts, ArrayList<String> defaultValues) {
        String ret = s;
        String value = null;
        for (int i = 0; i < prompts.size(); ++i) {
            if (prompts.get(i) == null) {
                value = "";
            } else if (prompts.get(i) instanceof JTextComponent) {
                value = ((JTextComponent)prompts.get(i)).getText();
            } else if (prompts.get(i) instanceof RadioGroupPanel) {
                value = ((RadioGroupPanel)prompts.get(i)).getSelectedValue();
            } else if (prompts.get(i) instanceof JComboBox) {
                value = ((JComboBox)prompts.get(i)).getSelectedItem() != null ? ((JComboBox)prompts.get(i)).getSelectedItem().toString() : "";
            } else if (prompts.get(i) instanceof JCheckBox) {
                value = ((JCheckBox)prompts.get(i)).isSelected() && defaultValues.size() > i && defaultValues.get(i) != null ? defaultValues.get(i) : "";
            } else if (prompts.get(i) instanceof JScrollPane && ((JViewport)((JScrollPane)prompts.get(i)).getComponent(0)).getComponent(0) instanceof BasicEditorPane) {
                value = ((BasicEditorPane)((JViewport)((JScrollPane)prompts.get(i)).getComponent(0)).getComponent(0)).getText();
            }
            if (ret.indexOf(":" + i) > 0) {
                this._binds.put("" + i, value);
            }
            ret = this.subHashMark(ret, i + "", value);
        }
        return ret;
    }

    private String subHashMark(String s, String name, Object value) {
        if (value == null) {
            value = "";
        }
        String ret = s;
        StringBuilder sb = new StringBuilder();
        String subVal = null;
        if (value.toString().indexOf(36) > 0) {
            for (int i = 0; i < value.toString().length(); ++i) {
                if (value.toString().charAt(i) == '$') {
                    sb.append("\\" + value.toString().charAt(i));
                    continue;
                }
                sb.append(value.toString().charAt(i));
            }
            subVal = sb.toString();
        } else {
            subVal = value.toString();
        }
        try {
            ret = ret.replaceAll("((?i)#" + name + "#)", subVal);
            ret = ret.replaceAll("((?i)#\"" + name + "\"#)", "\"" + subVal + "\"");
            ret = ret.replaceAll("((?i)#," + name + "#)", subVal == "" ? "" : "," + subVal);
            ret = ret.replaceAll("((?i)#,\"" + name + "\"#)", subVal == "" ? "" : ",\"" + subVal + "\"");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public void processSql() {
        this.processSql(null, null);
    }

    public void processSql(ArrayList<JComponent> prompts, ArrayList<String> defaultValues) {
        this._binds = new HashMap();
        this._cleanedSql = this.directSubstuitions(this._origSql);
        this.findNamedBinds();
        if (prompts != null) {
            this._cleanedSql = this.processPrompts(this._cleanedSql, prompts, defaultValues);
        }
    }

    public void setSql(String sql) {
        this._origSql = sql;
    }

    public void setDict(HashMap<String, Object> dict) {
        this._dict = dict;
    }

    public String getSql() {
        return this._cleanedSql;
    }

    public String getOrigSql() {
        return this._origSql;
    }

    public HashMap<String, Object> getBinds() {
        return this._binds;
    }

    public HashMap<String, Object> getDict() {
        return this._dict;
    }
}

