/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.actions;

import java.awt.Component;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.runner.Runner;
import oracle.ide.runner.StarterFactory;
import oracle.javatools.data.HashStructure;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.cm.dt.DatabaseConnectionNode;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdeveloper.runner.RunConfigurations;
import oracle.jdevimpl.cm.dt.runner.PlSqlStarterFactory;
import oracle.jdevimpl.runner.debug.DebugConfiguration;
import oracle.jdevimpl.runner.debug.DebuggingProcess;

public class RemoteDebug
extends AbstractMenuAction {
    private static boolean init = false;

    public void launch() {
        try {
            this.getDBObject().getDatabase().getConnection();
        }
        catch (Exception e) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)"Could not connect", (String)"Connection Error", null);
            return;
        }
        if (!init) {
            Runner.getRunner().registerStarterFactory(DatabaseConnectionNode.class, (StarterFactory)new PlSqlStarterFactory());
            init = true;
        }
        URL debugProject = null;
        try {
            String baseProject = Ide.getDefaultProject().getURL().toString();
            debugProject = new URL(baseProject.substring(0, baseProject.lastIndexOf("/")) + "/RemoteDebug.jpr");
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        Project activeProject = new Project();
        activeProject.setURL(debugProject);
        HashStructure hash = HashStructure.newInstance();
        hash.putString("remoteProtocol", "jpdaListen");
        Context context = Context.newIdeContext((Node)activeProject);
        context.setWorkspace(Ide.getActiveWorkspace());
        context.setProject(activeProject);
        DebuggingProcess jrunProcess = new DebuggingProcess(context);
        RunConfiguration run = jrunProcess.getRunConfiguration();
        HashStructure customProjectProperties = activeProject.getUserPropertiesOnly();
        HashStructure customRunConfigurations = customProjectProperties.getOrCreateHashStructure(RunConfigurations.DATA_KEY);
        jrunProcess.setLabelOverride("Remote Debug session");
        run.getProperties().putHashStructure(DebugConfiguration.class.getName(), hash);
        run.setRemoteDebuggingProfiling(true);
        run.setConnectionName(this.getDBObject().getDatabase().getConnectionName());
        run.setRunActiveFile(false);
        run.getProperties().putBoolean("remoteDebuggingProfiling", true);
        jrunProcess.start();
        try {
            activeProject.save();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public void setArgs(String args) {
    }
}

