/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.conn;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.PropertyPanel;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.util.IdeUtil;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.ConnectionManager;
import oracle.jdevimpl.cm.dt.config.ConnectionOptions;

public class ConnectionRename
extends AbstractMenuAction {
    private static final long serialVersionUID = 1L;
    private JEWTDialog dlg;
    private JTextField gName = null;
    private String oName;

    public void ShowPanel(String name) {
        this.oName = name;
        PropertyPanel panel = new PropertyPanel();
        String title = Translate.translate("Rename Connection");
        JLabel mess = new JLabel(Translate.translate("Warning: Renaming a connection will close all open editors/viewers."));
        panel.addSingleComp(mess);
        String lName = new String(Translate.translate("*Name"));
        this.gName = new JTextField();
        this.gName.setColumns(30);
        this.gName.setEditable(true);
        this.gName.setBorder(new LineBorder(Color.black, 1));
        this.gName.setText(name);
        panel.addComp(lName, this.gName);
        this.dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)panel, null, (String)title, (int)10);
        this.dlg.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConnectionRename.this.renameConnection(ConnectionRename.this.oName, ConnectionRename.this.gName.getText());
                ConnectionRename.this.dlg.dispose();
            }
        });
        Dimension dim = panel.getPreferredSize();
        int h = (int)dim.getHeight() + 100;
        int w = (int)dim.getWidth() + 100;
        this.dlg.setSize(w, h);
        this.dlg.setPreferredSize(w, h);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.dlg);
        this.dlg.setVisible(true);
    }

    void renameConnection(String oldName, String newName) {
        ConnectionManager mgr = ConnectionManager.getInstance();
        try {
            ConnectionDescriptor desc = mgr.getConnectionDescriptor(oldName);
            ConnectionOptions opts = (ConnectionOptions)Ide.getSettings().getData("ConnectionOptions");
            if (opts != null) {
                opts.renameConnection(oldName, newName);
            }
            mgr.removeConnectionDescriptor(oldName);
            mgr.putConnectionDescriptor(newName, desc);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void launch() {
        this.ShowPanel(this.getDBObject().getObjectName());
    }

    public void setArgs(String args) {
    }
}

