/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.export;

import java.awt.Component;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.SpringUtilities;
import oracle.ide.controls.tree.CustomJTree;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.controls.tree.TreeCellCheckedListener;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.TriStateBoolean;

public class ColumnPanel
extends JPanel {
    private CustomJTree _tree;
    private DefaultTreeModel _model;
    private DefaultMutableTreeNode _root;
    private String _sql;
    private String _conn;
    private ArrayList _bindList = null;
    private HashMap _bindMap = null;

    public ColumnPanel(String conn, String sql) {
        this.showPanel(conn, sql);
    }

    public ColumnPanel(String conn, String sql, ArrayList bind) {
        this._bindList = bind;
        this.showPanel(conn, sql);
    }

    public ColumnPanel(String conn, String sql, HashMap bind) {
        this._bindMap = bind;
        this.showPanel(conn, sql);
    }

    public void showPanel(String conn, String sql) {
        this._sql = sql;
        this.setLayout(new SpringLayout());
        this._conn = conn;
        this._root = this.createCheck("All", true, true);
        this._model = new DefaultTreeModel(this._root);
        this._tree = new CustomJTree((TreeModel)this._model);
        this._tree.setSize(200, 200);
        this.addColumnsToTree();
        this.add(new JLabel("Columns"));
        this.add(new JScrollPane((Component)this._tree));
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_exporttablecolumnselect_html");
        SpringUtilities.makeCompactGrid(this, 2, 1, 0, 0, 2, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addColumnsToTree() {
        PreparedStatement stmt = null;
        ResultSet rset = null;
        try {
            stmt = Connections.getInstance().getConnection(this._conn).prepareStatement(this._sql);
            rset = this._bindList != null ? DBUtil.getInstance().executeQuery(this._conn, this._sql, this._bindList) : (this._bindMap != null ? DBUtil.getInstance().executeQuery(this._conn, this._sql, this._bindMap) : stmt.executeQuery());
            boolean allowed = true;
            for (int i = 1; i < rset.getMetaData().getColumnCount() + 1; ++i) {
                int colType = rset.getMetaData().getColumnType(i);
                switch (colType) {
                    case 2004: 
                    case 2005: {
                        allowed = false;
                        break;
                    }
                    default: {
                        allowed = true;
                    }
                }
                this._root.add((MutableTreeNode)this.createCheck(rset.getMetaData().getColumnName(i), false, allowed));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (rset != null) {
                    rset.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public String getSelectedColumns() {
        String ret = null;
        TriStateBoolean tri = ((JTreeCellData)this._root.getUserObject()).getCheckBoxState();
        if (!((JTreeCellData)this._root.getUserObject()).getCheckBoxState().isTriState()) {
            ret = " * ";
        } else {
            for (int i = 0; i < this._root.getChildCount(); ++i) {
                String colName = ((JTreeCellData)((JMutableTreeNode)this._root.getChildAt(i)).getUserObject()).getText();
                tri = ((JTreeCellData)((JMutableTreeNode)this._root.getChildAt(i)).getUserObject()).getCheckBoxState();
                if (ret == null && tri == TriStateBoolean.TRUE) {
                    ret = "\"" + colName + "\"";
                    continue;
                }
                if (tri != TriStateBoolean.TRUE) continue;
                ret = ret + ",\"" + colName + "\"";
            }
        }
        return ret;
    }

    private JMutableTreeNode createCheck(String name, boolean checked, boolean enabled) {
        JTreeCellData s = new JTreeCellData(name);
        s.setCheckBoxEnabled(enabled);
        s.setTextEnabled(true);
        s.setHasCheckBox(enabled);
        if (enabled) {
            s.setCheckBoxState(checked ? TriStateBoolean.TRUE : TriStateBoolean.FALSE);
        }
        return new JMutableTreeNode(s);
    }

    public void addTreeCellCheckedListener(TreeCellCheckedListener listener) {
        this._tree.addTreeCellCheckedListener(listener);
    }

    public int getColCount() {
        return this._root.getChildCount();
    }
}

