/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.export;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import oracle.dbtools.raptor.controls.FilePanel;
import oracle.dbtools.raptor.controls.RadioGroupPanel;
import oracle.dbtools.raptor.utils.SpringUtilities;
import oracle.ide.help.HelpSystem;

public class ExportFormatPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private String _format;
    private RadioGroupPanel _formatGroup;
    private RadioGroupPanel _outputGroup;
    private JTextField _tableName;
    private FilePanel _file;
    private String _type;

    public ExportFormatPanel(String format) {
        this._format = format;
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_exporttableformat_html");
        this.setLayout(new SpringLayout());
        this._formatGroup = new RadioGroupPanel("STATIC:INSERT:XML:LOADER:CSV:TXT");
        this._formatGroup.addActionListener(this);
        this._formatGroup.setSelectedValue(this._format);
        this._outputGroup = new RadioGroupPanel("STATIC:File:Clipboard");
        this._tableName = new JTextField();
        this._tableName.setMaximumSize(new Dimension(20, 1));
        this._file = new FilePanel(this);
        this.setTableFocus(this._format);
        this.add(new JLabel("Format"));
        this.add(this._formatGroup);
        this.add(new JLabel("Output"));
        this.add(this._outputGroup);
        this.add(new JLabel("Table"));
        this.add(this._tableName);
        this.add(new JLabel("File"));
        this.add(this._file);
        SpringUtilities.makeCompactGrid(this, 4, 2, 0, 0, 2, 2);
    }

    public String getFormat() {
        return this._formatGroup.getSelectedValue();
    }

    public void setFileName(String s) {
        this._file.setDefaultFileName(s);
    }

    public String getFileName() {
        return this._file.getFileName();
    }

    public String getDestination() {
        return this._outputGroup.getSelectedValue();
    }

    public void setDefaultName(String name) {
        this._tableName.setText(name);
    }

    public String getDefaultName() {
        return this._tableName.getText();
    }

    public void setTableFocus(String format) {
        String fileName = this._file.getFileName().lastIndexOf(46) > -1 ? this._file.getFileName().substring(0, this._file.getFileName().lastIndexOf(46)) : this._tableName.getText();
        if (format.equals("CSV")) {
            this._type = "csv";
            this._file.setDefaultFileName(fileName + "." + this._type);
            this._tableName.setEnabled(false);
            this._tableName.setFocusable(false);
        } else if (format.equals("INSERT")) {
            this._type = "sql";
            this._file.setDefaultFileName(fileName + "." + this._type);
            this._tableName.setEnabled(true);
            this._tableName.setFocusable(true);
        } else if (format.equals("XML")) {
            this._type = "xml";
            this._file.setDefaultFileName(fileName + "." + this._type);
            this._tableName.setEnabled(false);
            this._tableName.setFocusable(false);
        } else if (format.equals("LOADER")) {
            this._type = "ldr";
            this._file.setDefaultFileName(fileName + "." + this._type);
            this._tableName.setEnabled(true);
            this._tableName.setFocusable(true);
        } else if (format.equals("TXT")) {
            this._type = "txt";
            this._file.setDefaultFileName(fileName + "." + this._type);
            this._tableName.setEnabled(false);
            this._tableName.setFocusable(false);
        } else {
            this._type = format;
            this._file.setDefaultFileName(fileName + "." + this._type);
            this._tableName.setEnabled(false);
            this._tableName.setFocusable(false);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String type = this._formatGroup.getSelectedValue();
        this.setTableFocus(type);
    }
}

