/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.export;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.table.DefaultTableModel;
import oracle.dbtools.raptor.controls.ResultSetTable;
import oracle.dbtools.raptor.models.ResultSetTableModel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.SpringUtilities;
import oracle.ide.help.HelpSystem;

public class PredicatePanel
extends JPanel {
    private String _sql;
    private String _baseSql;
    private JTextField _predicate;
    private ResultSetTable _sampleTab;
    private String _conn;
    private ArrayList _bindList = null;
    private HashMap _bindMap = null;
    private boolean _dirty = true;

    public PredicatePanel(String conn, String sql, ArrayList bind) {
        this._bindList = bind;
        this.showPanel(conn, sql);
    }

    public PredicatePanel(String conn, String sql, HashMap bind) {
        this._bindMap = bind;
        this.showPanel(conn, sql);
    }

    public PredicatePanel(String conn, String sql) {
        this.showPanel(conn, sql);
    }

    public void showPanel(String conn, String sql) {
        this._baseSql = sql;
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_exporttablepredicate_html");
        this.setLayout(new SpringLayout());
        this._predicate = new JTextField();
        this._predicate.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    PredicatePanel.this._dirty = true;
                }
                PredicatePanel.this.showSampleData();
            }

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this._sampleTab = new ResultSetTable();
        this._sampleTab.setTranslatedColNames(false);
        this._sampleTab.setSize(200, 200);
        this._sampleTab.setThreaded(false);
        this._conn = conn;
        this.add(new JLabel("Where clause:"));
        this.add(this._predicate);
        this.add(new JLabel("Sample data:"));
        this.add(new JScrollPane(this._sampleTab));
        SpringUtilities.makeCompactGrid(this, 4, 1, 0, 0, 2, 2);
    }

    public void showSampleData() {
        if (this._dirty && (this._sampleTab.getModel() instanceof DefaultTableModel || ((ResultSetTableModel)this._sampleTab.getModel()).getSQL() != null && !((ResultSetTableModel)this._sampleTab.getModel()).getSQL().equals(this.getSQL()))) {
            if (this._bindList != null) {
                this._sampleTab.setQuery(Connections.getInstance().getConnection(this._conn), null, this.getSQL(), this._bindList);
            } else if (this._bindMap != null) {
                this._sampleTab.setQuery(Connections.getInstance().getConnection(this._conn), null, this.getSQL(), this._bindMap);
            } else {
                this._sampleTab.setQuery(Connections.getInstance().getConnection(this._conn), null, this.getSQL());
            }
        }
        this._dirty = false;
    }

    public void setSQL(String s) {
        s.intern();
        if (!this._baseSql.equals(s)) {
            this._baseSql = s;
            this._dirty = true;
            this._baseSql.intern();
        }
    }

    public String getSQL() {
        return this._baseSql + " " + this.getPredicate();
    }

    public void setPredicate(String sql) {
        this._predicate.setText(sql);
    }

    public String getPredicate() {
        String ret = this._predicate.getText();
        if (!ret.equals("") && ret.trim().toLowerCase().indexOf("where") != 0) {
            ret = " where " + ret;
        }
        return ret;
    }

    public ResultSetTable getTable() {
        if (this._dirty) {
            this.showSampleData();
            this._dirty = false;
        }
        return this._sampleTab;
    }
}

