/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.file;

import java.awt.Component;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.dialogs.CreateDialogArb;
import oracle.dbtools.util.Resource;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.cmd.FileOpenHistory;
import oracle.ide.component.NewFilePanel;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.editor.EditorUtil;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.DefaultNameGenerator;
import oracle.ide.net.NameGenerator;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.IdeUtil;
import oracle.ide.wizard.Wizard;
import oracle.javatools.buffer.TextBuffer;
import oracle.jdeveloper.dialogs.JDevDialogHeader;
import oracle.jdevimpl.cm.dt.sqlplus.SqlFileBuilder;
import oracle.jdevimpl.cm.dt.sqlplus.SqlNode;

public class NewSqlFile
extends Wizard {
    private Wizard _base = new SqlFileBuilder();

    public String getShortLabel() {
        return this._base.getShortLabel();
    }

    public boolean invoke(Context Context2) {
        final NewFilePanel pan = new NewFilePanel();
        pan.setFileExtension("sql");
        pan.setFileType(CreateDialogArb.getString(581));
        pan.setSupportsAutoFill(false);
        pan.setCanOverwriteOpenNodes(true);
        pan.setEnforceFileExtension(false);
        URL dir = URLFactory.newDirURL((File)Resource.raptorUser);
        pan.setDirectoryURL(dir);
        URL defName = URLFactory.newUniqueURL((URL)dir, (NameGenerator)new DefaultNameGenerator("Untitled", "sql", -1));
        pan.setFileName(URLFileSystem.getFileName((URL)defName));
        IdeMainWindow f = Ide.getMainWindow();
        int btnMask = 7;
        final JEWTDialog dlg = new JEWTDialog((Frame)f, this.getShortLabel(), btnMask);
        dlg.setContent((Component)pan);
        dlg.setTitle(CreateDialogArb.getString(580));
        JDevDialogHeader header = new JDevDialogHeader();
        header.setHeaderImage(null);
        header.setHeaderTitle(this.getShortLabel());
        header.setHeaderDescription(CreateDialogArb.getString(582));
        dlg.setDialogHeader((Component)header);
        dlg.addVetoableChangeListener(new VetoableChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                String propName = evt.getPropertyName();
                Object newValue = evt.getNewValue();
                if (propName.equals("closed") && Boolean.TRUE.equals(newValue)) {
                    try {
                        URL url = pan.getFileURL();
                        SqlNode node = null;
                        try {
                            node = (SqlNode)NodeFactory.findOrCreate(SqlNode.class, (URL)url);
                        }
                        catch (Exception ex) {
                            throw new TraversalException(ex.getLocalizedMessage());
                        }
                        TextBuffer textBuffer = null;
                        try {
                            textBuffer = node.acquireTextBuffer();
                            int textBufferLength = textBuffer.getLength();
                            if (textBufferLength > 0) {
                                textBuffer.remove(0, textBufferLength);
                                UpdateMessage.fireStructureChanged((Subject)node);
                            }
                        }
                        finally {
                            if (textBuffer != null) {
                                node.releaseTextBuffer();
                            }
                        }
                        if (!URLFileSystem.exists((URL)url)) {
                            try {
                                URLFileSystem.openOutputStream((URL)url).close();
                            }
                            catch (IOException e) {
                                throw new TraversalException(e.getLocalizedMessage());
                            }
                        }
                        final SqlNode sn = node;
                        FileOpenHistory.getInstance().updateFileHistory(url);
                        IdeUtil.invokeAfterRepaint((Runnable)new Runnable(){

                            public void run() {
                                EditorUtil.openDefaultEditorInFrame((Node)sn);
                            }
                        });
                    }
                    catch (TraversalException ex) {
                        ex.showMessageDialog((Component)dlg);
                        throw new PropertyVetoException("panel", evt);
                    }
                }
            }
        });
        return WizardLauncher.runDialog((JDialog)dlg);
    }

    public boolean isAvailable(Context Context2) {
        return true;
    }

    public String getToolTipText() {
        return this._base.getToolTipText();
    }

    public String getLongLabel() {
        return CreateDialogArb.getString(583);
    }

    public Icon getIcon() {
        return this._base.getIcon();
    }
}

